#include "TestRacyRPCReplies.h"

#include "IPDLUnitTests.h"      // fail etc.

namespace mozilla {
namespace _ipdltest {

//-----------------------------------------------------------------------------
// parent

TestRacyRPCRepliesParent::TestRacyRPCRepliesParent() : mReplyNum(0)
{
    MOZ_COUNT_CTOR(TestRacyRPCRepliesParent);
}

TestRacyRPCRepliesParent::~TestRacyRPCRepliesParent()
{
    MOZ_COUNT_DTOR(TestRacyRPCRepliesParent);
}

void
TestRacyRPCRepliesParent::Main()
{
    int replyNum = -1;
    if (!CallR_(&replyNum))
        fail("calling R()");

    if (1 != replyNum)
        fail("this should have been the first reply to R()");

    if (!SendChildTest())
        fail("sending ChildStart");
}

bool
TestRacyRPCRepliesParent::RecvA_()
{
    int replyNum = -1;
    // this R() call races with the reply being generated by the other
    // side to the R() call from Main().  This is a pretty nasty edge
    // case for which one could argue we're breaking in-order message
    // delivery, since this side will process the second reply to R()
    // before the first.
    if (!CallR_(&replyNum))
        fail("calling R()");

    if (2 != replyNum)
        fail("this should have been the second reply to R()");

    return true;
}

bool
TestRacyRPCRepliesParent::Answer_R(int* replyNum)
{
    *replyNum = ++mReplyNum;

    if (1 == *replyNum)
        if (!Send_A())
            fail("sending _A()");

    return true;
}

//-----------------------------------------------------------------------------
// child

TestRacyRPCRepliesChild::TestRacyRPCRepliesChild() : mReplyNum(0)
{
    MOZ_COUNT_CTOR(TestRacyRPCRepliesChild);
}

TestRacyRPCRepliesChild::~TestRacyRPCRepliesChild()
{
    MOZ_COUNT_DTOR(TestRacyRPCRepliesChild);
}

bool
TestRacyRPCRepliesChild::AnswerR_(int* replyNum)
{
    *replyNum = ++mReplyNum;

    if (1 == *replyNum)
        SendA_();

    return true;
}

bool
TestRacyRPCRepliesChild::RecvChildTest()
{
    int replyNum = -1;
    if (!Call_R(&replyNum))
        fail("calling R()");

    if (1 != replyNum)
        fail("this should have been the first reply to R()");

    Close();

    return true;
}

bool
TestRacyRPCRepliesChild::Recv_A()
{
    int replyNum = -1;

    if (!Call_R(&replyNum))
        fail("calling _R()");

    if (2 != replyNum)
        fail("this should have been the second reply to R()");

    return true;
}

} // namespace _ipdltest
} // namespace mozilla
