/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

var whitelist = [];

var prefSet = require("simple-prefs");

var setWhitelist = function () {

    whitelist = [];

    var str;

    var whitelistString = prefSet.prefs.whitelist.split(',');

    for (var i = 0; i < whitelistString.length; i++) {

	// remove space, trailing slash, escape any nonalpha except *, replace * with .*
	str = whitelistString[i].replace(" ", "").replace(/\/$/, "").replace(/[^a-z0-9\*]/ig, "\\$&").replace("*", ".*");

	if (str != '') {

	    whitelist.push(new RegExp('^https?:\/\/(www\.)?' + str + '\/', 'i'));
	}

    }

};

exports.getWhitelist = function () {
    return whitelist;
};

exports.init = function () {
    setWhitelist();
};

prefSet.on("whitelist", setWhitelist);

