#!/bin/bash
set -exuo pipefail

# Update system
apt-get update -yq
apt-get upgrade -yq

./bootstrap
./configure --prefix /usr

# Setup postgres cluster
sudo -u postgres pg_ctlcluster 17 main start
sudo -u postgres createuser root --superuser
sudo -u postgres createdb -O root libeufincheck

check_command()
{
    make check &> test-suite.log
}

if ! check_command ; then
    cat test-suite.log
    exit 1
fi