/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.missing;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.missing.MissingAggregator;
import org.elasticsearch.search.aggregations.bucket.missing.MissingAggregatorSupplier;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

public class MissingAggregatorFactory
extends ValuesSourceAggregatorFactory {
    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("missing", CoreValuesSourceType.ALL_CORE, MissingAggregator::new);
    }

    public MissingAggregatorFactory(String name, ValuesSourceConfig config, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
    }

    @Override
    protected MissingAggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new MissingAggregator(this.name, this.factories, this.config, searchContext, parent, CardinalityUpperBound.NONE, metadata);
    }

    @Override
    protected MissingAggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config, "missing");
        if (!(aggregatorSupplier instanceof MissingAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected MissingAggregatorSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        return ((MissingAggregatorSupplier)aggregatorSupplier).build(this.name, this.factories, this.config, searchContext, parent, cardinality, metadata);
    }
}

