/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.logging.log4j.LogManager;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;

public class NGramTokenFilterFactory
extends AbstractTokenFilterFactory {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(NGramTokenFilterFactory.class));
    private final int minGram;
    private final int maxGram;
    private final boolean preserveOriginal;
    private static final String PRESERVE_ORIG_KEY = "preserve_original";

    NGramTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        int maxAllowedNgramDiff = indexSettings.getMaxNgramDiff();
        this.minGram = settings.getAsInt("min_gram", Integer.valueOf(1));
        this.maxGram = settings.getAsInt("max_gram", Integer.valueOf(2));
        int ngramDiff = this.maxGram - this.minGram;
        if (ngramDiff > maxAllowedNgramDiff) {
            if (indexSettings.getIndexVersionCreated().onOrAfter(Version.V_7_0_0)) {
                throw new IllegalArgumentException("The difference between max_gram and min_gram in NGram Tokenizer must be less than or equal to: [" + maxAllowedNgramDiff + "] but was [" + ngramDiff + "]. This limit can be set by changing the [" + IndexSettings.MAX_NGRAM_DIFF_SETTING.getKey() + "] index level setting.");
            }
            this.deprecationLogger.deprecatedAndMaybeLog("ngram_big_difference", "Deprecated big difference between max_gram and min_gram in NGram Tokenizer,expected difference must be less than or equal to: [" + maxAllowedNgramDiff + "]", new Object[0]);
        }
        this.preserveOriginal = settings.getAsBoolean(PRESERVE_ORIG_KEY, Boolean.valueOf(false));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new NGramTokenFilter(tokenStream, this.minGram, this.maxGram, this.preserveOriginal);
    }

    public TokenFilterFactory getSynonymFilter() {
        if (this.indexSettings.getIndexVersionCreated().onOrAfter(Version.V_7_0_0)) {
            throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
        }
        DEPRECATION_LOGGER.deprecatedAndMaybeLog("synonym_tokenfilters", "Token filter [" + this.name() + "] will not be usable to parse synonyms after v7.0", new Object[0]);
        return this;
    }
}

