/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleError;
import org.armedbear.lisp.protocol.Hashtable;

@DocString(name="zip", args="pathname pathnames &optional topdir", doc="Creates a zip archive at PATHNAME whose entries enumerated via the list of PATHNAMES.\nIf the optional TOPDIR argument is specified, the archive will preserve the hierarchy of PATHNAMES relative to TOPDIR.  Without TOPDIR, there will be no sub-directories in the archive, i.e. it will be flat.")
public final class zip
extends Primitive {
    private static final Primitive zip = new zip();

    private zip() {
        super("zip", Lisp.PACKAGE_SYS, true);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second) {
        Pathname zipfilePathname = Lisp.coerceToPathname(first);
        if (second instanceof Hashtable) {
            return this.execute(zipfilePathname, (Hashtable)((Object)second));
        }
        byte[] buffer = new byte[4096];
        try {
            String zipfileNamestring = zipfilePathname.getNamestring();
            if (zipfileNamestring == null) {
                return Lisp.error(new SimpleError("Pathname has no namestring: " + zipfilePathname.princToString()));
            }
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfileNamestring));
            for (LispObject list = second; list != Lisp.NIL; list = list.cdr()) {
                Pathname pathname = Lisp.coerceToPathname(list.car());
                String namestring = pathname.getNamestring();
                if (namestring == null) {
                    out.close();
                    File zipfile = new File(zipfileNamestring);
                    zipfile.delete();
                    return Lisp.error(new SimpleError("Pathname has no namestring: " + pathname.princToString()));
                }
                File file = new File(namestring);
                this.makeEntry(out, file);
            }
            out.close();
        }
        catch (IOException e) {
            return Lisp.error(new LispError(e.getMessage()));
        }
        return zipfilePathname;
    }

    @Override
    public LispObject execute(LispObject first, LispObject second, LispObject third) {
        Pathname zipfilePathname = Lisp.coerceToPathname(first);
        try {
            String zipfileNamestring = zipfilePathname.getNamestring();
            if (zipfileNamestring == null) {
                return Lisp.error(new SimpleError("Pathname has no namestring: " + zipfilePathname.princToString()));
            }
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfileNamestring));
            Pathname root = (Pathname)Pathname.truename(Lisp.coerceToPathname(third));
            String rootPath = root.getDirectoryNamestring();
            int rootPathLength = rootPath.length();
            HashSet<String> directories = new HashSet<String>();
            LispObject list = second;
            while (list != Lisp.NIL) {
                File file;
                Pathname pathname = (Pathname)Pathname.truename(Lisp.coerceToPathname(list.car()));
                String namestring = pathname.getNamestring();
                if (namestring == null) {
                    out.close();
                    File zipfile = new File(zipfileNamestring);
                    zipfile.delete();
                    return Lisp.error(new SimpleError("Pathname has no namestring: " + pathname.princToString()));
                }
                String directory = "";
                String dir = pathname.getDirectoryNamestring();
                if (dir.length() > rootPathLength) {
                    int j;
                    String d = dir.substring(rootPathLength);
                    int i = 0;
                    while ((j = d.indexOf(47, i)) != -1) {
                        i = j + 1;
                        directory = d.substring(0, j) + '/';
                        if (directories.contains(directory)) continue;
                        directories.add(directory);
                        ZipEntry entry = new ZipEntry(directory);
                        out.putNextEntry(entry);
                        out.closeEntry();
                    }
                }
                if ((file = new File(namestring)).isDirectory()) {
                    list = list.cdr();
                    continue;
                }
                this.makeEntry(out, file, directory + file.getName());
                list = list.cdr();
            }
            out.close();
        }
        catch (IOException e) {
            return Lisp.error(new LispError(e.getMessage()));
        }
        return zipfilePathname;
    }

    public LispObject execute(Pathname zipfilePathname, Hashtable table) {
        LispObject entriesObject = table.getEntries();
        if (!(entriesObject instanceof Cons)) {
            return Lisp.NIL;
        }
        Cons entries = (Cons)entriesObject;
        String zipfileNamestring = zipfilePathname.getNamestring();
        if (zipfileNamestring == null) {
            return Lisp.error(new SimpleError("Pathname has no namestring: " + zipfilePathname.princToString()));
        }
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(zipfileNamestring));
        }
        catch (FileNotFoundException e) {
            return Lisp.error(new FileError("Failed to create file for writing zip archive", zipfilePathname));
        }
        Directories directories = new Directories(out);
        for (LispObject head = entries; head != Lisp.NIL; head = head.cdr()) {
            LispObject key = head.car().car();
            LispObject value = head.car().cdr();
            Pathname source2 = Lisp.coerceToPathname(key);
            Pathname destination = Lisp.coerceToPathname(value);
            File file = source2.getFile();
            try {
                String jarEntry = destination.getNamestring();
                if (jarEntry.startsWith("/")) {
                    jarEntry = jarEntry.substring(1);
                }
                directories.ensure(jarEntry);
                this.makeEntry(out, file, jarEntry);
                continue;
            }
            catch (FileNotFoundException e) {
                return Lisp.error(new FileError("Failed to read file for incoporation in zip archive.", source2));
            }
            catch (IOException e) {
                return Lisp.error(new FileError("Failed to add file to zip archive.", source2));
            }
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            return Lisp.error(new FileError("Failed to close zip archive.", zipfilePathname));
        }
        return zipfilePathname;
    }

    private void makeEntry(ZipOutputStream zip2, File file) throws FileNotFoundException, IOException {
        this.makeEntry(zip2, file, file.getName());
    }

    private void makeEntry(ZipOutputStream zip2, File file, String name) throws FileNotFoundException, IOException {
        int n;
        byte[] buffer = new byte[4096];
        long lastModified = file.lastModified();
        FileInputStream in = new FileInputStream(file);
        ZipEntry entry = new ZipEntry(name);
        if (lastModified > 0L) {
            entry.setTime(lastModified);
        }
        zip2.putNextEntry(entry);
        while ((n = in.read(buffer)) > 0) {
            zip2.write(buffer, 0, n);
        }
        zip2.closeEntry();
        in.close();
    }

    static class Directories
    extends HashSet<String> {
        ZipOutputStream out;

        private Directories() {
        }

        public Directories(ZipOutputStream out) {
            this.out = out;
        }

        public void ensure(String path) throws IOException {
            int j;
            int i = 0;
            while ((j = path.indexOf(47, i)) != -1) {
                i = j + 1;
                String directory = path.substring(0, j) + '/';
                if (this.contains(directory)) continue;
                this.add(directory);
                ZipEntry entry = new ZipEntry(directory);
                this.out.putNextEntry(entry);
                this.out.closeEntry();
            }
        }
    }
}

