/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CliResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J%\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0006\u0010\u0017\u001a\u00020\u000bJ\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/CommandLineProcessorResult;", "", "project", "Lcom/intellij/openapi/project/Project;", "future", "Ljava/util/concurrent/Future;", "Lcom/intellij/ide/CliResult;", "(Lcom/intellij/openapi/project/Project;Ljava/util/concurrent/Future;)V", "getFuture", "()Ljava/util/concurrent/Future;", "hasError", "", "getHasError", "()Z", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "showErrorIfFailed", "toString", "", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class CommandLineProcessorResult {
    @Nullable
    private final Project project;
    @NotNull
    private final Future<CliResult> future;
    public static final Companion Companion = new Companion(null);

    public final boolean getHasError() {
        return this.future.isDone() && this.future.get().exitCode == 1;
    }

    public final boolean showErrorIfFailed() {
        if (this.future.isDone()) {
            CliResult result2 = this.future.get();
            if (result2.exitCode == 1) {
                Messages.showErrorDialog((String)result2.message, (String)"Cannot execute command");
                return true;
            }
        }
        return false;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Future<CliResult> getFuture() {
        return this.future;
    }

    public CommandLineProcessorResult(@Nullable Project project, @NotNull Future<CliResult> future2) {
        Intrinsics.checkParameterIsNotNull(future2, (String)"future");
        this.project = project;
        this.future = future2;
    }

    @Nullable
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final Future<CliResult> component2() {
        return this.future;
    }

    @NotNull
    public final CommandLineProcessorResult copy(@Nullable Project project, @NotNull Future<CliResult> future2) {
        Intrinsics.checkParameterIsNotNull(future2, (String)"future");
        return new CommandLineProcessorResult(project, future2);
    }

    public static /* synthetic */ CommandLineProcessorResult copy$default(CommandLineProcessorResult commandLineProcessorResult, Project project, Future future2, int n, Object object) {
        if ((n & 1) != 0) {
            project = commandLineProcessorResult.project;
        }
        if ((n & 2) != 0) {
            future2 = commandLineProcessorResult.future;
        }
        return commandLineProcessorResult.copy(project, future2);
    }

    @NotNull
    public String toString() {
        return "CommandLineProcessorResult(project=" + this.project + ", future=" + this.future + ")";
    }

    public int hashCode() {
        Project project = this.project;
        Future<CliResult> future2 = this.future;
        return (project != null ? project.hashCode() : 0) * 31 + (future2 != null ? future2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CommandLineProcessorResult)) break block3;
                CommandLineProcessorResult commandLineProcessorResult = (CommandLineProcessorResult)object;
                if (!Intrinsics.areEqual((Object)this.project, (Object)commandLineProcessorResult.project) || !Intrinsics.areEqual(this.future, commandLineProcessorResult.future)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final CommandLineProcessorResult createError(@NotNull String message) {
        return Companion.createError(message);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/CommandLineProcessorResult$Companion;", "", "()V", "createError", "Lcom/intellij/ide/CommandLineProcessorResult;", "message", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final CommandLineProcessorResult createError(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Future future2 = CliResult.error((int)1, (String)message);
            Intrinsics.checkExpressionValueIsNotNull((Object)future2, (String)"CliResult.error(1, message)");
            return new CommandLineProcessorResult(null, future2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

