/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NavBarListWrapper
extends JBScrollPane
implements DataProvider {
    private static final int MAX_SIZE = 20;
    private final JList myList;

    NavBarListWrapper(final JList list2) {
        super((Component)list2);
        list2.addMouseMotionListener(new MouseMotionAdapter(){
            boolean myIsEngaged = false;

            @Override
            public void mouseMoved(MouseEvent e) {
                if (this.myIsEngaged && !UIUtil.isSelectionButtonDown((MouseEvent)e)) {
                    Point point = e.getPoint();
                    int index = list2.locationToIndex(point);
                    list2.setSelectedIndex(index);
                } else {
                    this.myIsEngaged = true;
                }
            }
        });
        ScrollingUtil.installActions((JList)list2);
        int modelSize = list2.getModel().getSize();
        this.setBorder(BorderFactory.createEmptyBorder());
        if (modelSize > 0 && modelSize <= 20) {
            list2.setVisibleRowCount(0);
            this.getViewport().setPreferredSize(list2.getPreferredSize());
        } else {
            list2.setVisibleRowCount(20);
        }
        this.myList = list2;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            NavBarListWrapper.$$$reportNull$$$0(0);
        }
        if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
            return this.myList.getSelectedValue();
        }
        if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
            return this.myList.getSelectedValues();
        }
        return null;
    }

    public void setBorder(Border border) {
        if (this.myList != null) {
            this.myList.setBorder(border);
        }
    }

    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myList, true));
    }

    public synchronized void addMouseListener(MouseListener l) {
        this.myList.addMouseListener(l);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ide/navigationToolbar/NavBarListWrapper", "getData"));
    }
}

