/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.ProjectServiceContainerCustomizer;
import com.intellij.openapi.project.impl.ProjectServiceContainerInitializedListener;
import java.util.List;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a!\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0082\b\u001a \u0010\n\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a7\u0010\u0012\u001a\u00020\u0010\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b2\u0014\b\u0004\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u00100\u0015H\u0082\b\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createActivity", "Lcom/intellij/diagnostic/Activity;", "project", "Lcom/intellij/openapi/project/impl/ProjectImpl;", "message", "Lkotlin/Function0;", "", "getExtensionPoint", "Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;", "T", "", "name", "notifyThatComponentCreated", "", "registerComponents", "runHandler", "ep", "executor", "Lkotlin/Function1;", "intellij.platform.ide.impl"})
@JvmName(name="ProjectLoadHelper")
@ApiStatus.Internal
public final class ProjectLoadHelper {
    private static final Logger LOG;

    public static final void registerComponents(@NotNull ProjectImpl project) {
        block3: {
            Activity activity;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            boolean $i$f$createActivity = false;
            if (project.isDefault() || !StartUpMeasurer.isEnabled()) {
                activity = null;
            } else {
                boolean bl = false;
                activity = StartUpMeasurer.startActivity((String)"project component registration");
            }
            Activity activity2 = activity;
            List<? extends IdeaPluginDescriptor> list2 = PluginManagerCore.getLoadedPlugins();
            if (list2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<com.intellij.ide.plugins.IdeaPluginDescriptorImpl>");
            }
            project.registerComponents(list2);
            Activity activity3 = activity2;
            activity2 = activity3 != null ? activity3.endAndStart("projectComponentRegistered") : null;
            ExtensionPointImpl<ProjectServiceContainerCustomizer> ep$iv = ProjectServiceContainerCustomizer.Companion.getEp();
            boolean $i$f$runHandler = false;
            ep$iv.processWithPluginDescriptor(true, new BiConsumer<T, PluginDescriptor>(ep$iv, project){
                final /* synthetic */ ExtensionPointImpl $ep;
                final /* synthetic */ ProjectImpl $project$inlined;
                {
                    this.$ep = extensionPointImpl;
                    this.$project$inlined = projectImpl;
                }

                public final void accept(T handler2, PluginDescriptor pluginDescriptor) {
                    PluginDescriptor pluginDescriptor2 = pluginDescriptor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pluginDescriptor2, (String)"pluginDescriptor");
                    if (Intrinsics.areEqual((Object)pluginDescriptor2.getPluginId(), (Object)PluginManagerCore.CORE_ID) ^ true) {
                        ProjectLoadHelper.access$getLOG$p().error((Throwable)new PluginException("Plugin " + pluginDescriptor + " is not approved to add " + this.$ep.getName(), pluginDescriptor.getPluginId()));
                    }
                    try {
                        T t = handler2;
                        Intrinsics.checkExpressionValueIsNotNull(t, (String)"handler");
                        ProjectServiceContainerCustomizer it = (ProjectServiceContainerCustomizer)t;
                        boolean bl = false;
                        it.serviceRegistered(this.$project$inlined);
                    }
                    catch (ProcessCanceledException e) {
                        throw (Throwable)e;
                    }
                    catch (Throwable e) {
                        ProjectLoadHelper.access$getLOG$p().error((Throwable)new PluginException(e, pluginDescriptor.getPluginId()));
                    }
                }
            });
            Activity activity4 = activity2;
            if (activity4 == null) break block3;
            activity4.end();
        }
    }

    public static final void notifyThatComponentCreated(@NotNull ProjectImpl project) {
        block2: {
            Activity activity;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            boolean $i$f$createActivity = false;
            if (project.isDefault() || !StartUpMeasurer.isEnabled()) {
                activity = null;
            } else {
                boolean bl = false;
                activity = StartUpMeasurer.startActivity((String)"projectComponentCreated event handling");
            }
            Activity activity2 = activity;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            ((ProjectLifecycleListener)application.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).projectComponentsInitialized((Project)project);
            Activity activity3 = activity2;
            activity2 = activity3 != null ? activity3.endAndStart("projectComponentCreated") : null;
            ExtensionPointImpl ep$iv = ProjectLoadHelper.getExtensionPoint("com.intellij.projectServiceContainerInitializedListener");
            boolean $i$f$runHandler = false;
            ep$iv.processWithPluginDescriptor(true, new BiConsumer<T, PluginDescriptor>(ep$iv, project){
                final /* synthetic */ ExtensionPointImpl $ep;
                final /* synthetic */ ProjectImpl $project$inlined;
                {
                    this.$ep = extensionPointImpl;
                    this.$project$inlined = projectImpl;
                }

                public final void accept(T handler2, PluginDescriptor pluginDescriptor) {
                    PluginDescriptor pluginDescriptor2 = pluginDescriptor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pluginDescriptor2, (String)"pluginDescriptor");
                    if (Intrinsics.areEqual((Object)pluginDescriptor2.getPluginId(), (Object)PluginManagerCore.CORE_ID) ^ true) {
                        ProjectLoadHelper.access$getLOG$p().error((Throwable)new PluginException("Plugin " + pluginDescriptor + " is not approved to add " + this.$ep.getName(), pluginDescriptor.getPluginId()));
                    }
                    try {
                        T t = handler2;
                        Intrinsics.checkExpressionValueIsNotNull(t, (String)"handler");
                        ProjectServiceContainerInitializedListener it = (ProjectServiceContainerInitializedListener)t;
                        boolean bl = false;
                        it.serviceCreated(this.$project$inlined);
                    }
                    catch (ProcessCanceledException e) {
                        throw (Throwable)e;
                    }
                    catch (Throwable e) {
                        ProjectLoadHelper.access$getLOG$p().error((Throwable)new PluginException(e, pluginDescriptor.getPluginId()));
                    }
                }
            });
            Activity activity4 = activity2;
            if (activity4 == null) break block2;
            activity4.end();
        }
    }

    private static final Activity createActivity(ProjectImpl project, Function0<String> message) {
        int $i$f$createActivity = 0;
        return project.isDefault() || !StartUpMeasurer.isEnabled() ? null : StartUpMeasurer.startActivity((String)((String)message.invoke()));
    }

    private static final <T> void runHandler(ExtensionPointImpl<T> ep, Function1<? super T, Unit> executor) {
        int $i$f$runHandler = 0;
        ep.processWithPluginDescriptor(true, new BiConsumer<T, PluginDescriptor>(ep, executor){
            final /* synthetic */ ExtensionPointImpl $ep;
            final /* synthetic */ Function1 $executor;

            public final void accept(T handler2, PluginDescriptor pluginDescriptor) {
                PluginDescriptor pluginDescriptor2 = pluginDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)pluginDescriptor2, (String)"pluginDescriptor");
                if (Intrinsics.areEqual((Object)pluginDescriptor2.getPluginId(), (Object)PluginManagerCore.CORE_ID) ^ true) {
                    ProjectLoadHelper.access$getLOG$p().error((Throwable)new PluginException("Plugin " + pluginDescriptor + " is not approved to add " + this.$ep.getName(), pluginDescriptor.getPluginId()));
                }
                try {
                    T t = handler2;
                    Intrinsics.checkExpressionValueIsNotNull(t, (String)"handler");
                    this.$executor.invoke(t);
                }
                catch (ProcessCanceledException e) {
                    throw (Throwable)e;
                }
                catch (Throwable e) {
                    ProjectLoadHelper.access$getLOG$p().error((Throwable)new PluginException(e, pluginDescriptor.getPluginId()));
                }
            }
            {
                this.$ep = extensionPointImpl;
                this.$executor = function1;
            }
        });
    }

    private static final <T> ExtensionPointImpl<T> getExtensionPoint(String name) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        ExtensionsArea extensionsArea = application.getExtensionArea();
        if (extensionsArea == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.extensions.impl.ExtensionsAreaImpl");
        }
        ExtensionPointImpl extensionPointImpl = ((ExtensionsAreaImpl)extensionsArea).getExtensionPoint(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointImpl, (String)"(ApplicationManager.getA\u2026).getExtensionPoint(name)");
        return extensionPointImpl;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProjectImpl.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ ExtensionPointImpl access$getExtensionPoint(String name) {
        return ProjectLoadHelper.getExtensionPoint(name);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

