/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.InjectedLanguageBlockWrapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InjectedLanguageBlockBuilder {
    private static final Logger LOG = Logger.getInstance(InjectedLanguageBlockBuilder.class);

    @NotNull
    public Block createInjectedBlock(@NotNull ASTNode node, @NotNull Block originalBlock, Indent indent, int offset, TextRange range2, @NotNull Language language) {
        if (node == null) {
            InjectedLanguageBlockBuilder.$$$reportNull$$$0(0);
        }
        if (originalBlock == null) {
            InjectedLanguageBlockBuilder.$$$reportNull$$$0(1);
        }
        if (language == null) {
            InjectedLanguageBlockBuilder.$$$reportNull$$$0(2);
        }
        return new InjectedLanguageBlockWrapper(originalBlock, offset, range2, indent, language);
    }

    public abstract CodeStyleSettings getSettings();

    public abstract boolean canProcessFragment(String var1, ASTNode var2);

    public abstract Block createBlockBeforeInjection(ASTNode var1, Wrap var2, Alignment var3, Indent var4, TextRange var5);

    public abstract Block createBlockAfterInjection(ASTNode var1, Wrap var2, Alignment var3, Indent var4, TextRange var5);

    public boolean addInjectedBlocks(List<? super Block> result2, ASTNode injectionHost, Wrap wrap, Alignment alignment, Indent indent) {
        Ref lastInjectionEndOffset = new Ref((Object)0);
        PsiLanguageInjectionHost.InjectedPsiVisitor injectedPsiVisitor = (injectedPsi, places) -> {
            Language childLanguage;
            FormattingModelBuilder builder2;
            String childText;
            if (places.size() != 1) {
                return;
            }
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)places.get(0);
            TextRange injectionRange = shred.getRangeInsideHost();
            PsiLanguageInjectionHost shredHost = shred.getHost();
            if (shredHost == null) {
                return;
            }
            ASTNode node = shredHost.getNode();
            if (node == null || !injectionHost.getTextRange().contains(injectionRange.shiftRight(node.getStartOffset()))) {
                return;
            }
            if (node != injectionHost) {
                int shift = 0;
                boolean canProcess = false;
                ASTNode prev = injectionHost;
                for (ASTNode n = injectionHost.getTreeParent(); n != null; n = n.getTreeParent()) {
                    shift += n.getStartOffset() - prev.getStartOffset();
                    if (n == node) {
                        injectionRange = injectionRange.shiftRight(shift);
                        canProcess = true;
                        break;
                    }
                    prev = n;
                }
                if (!canProcess) {
                    return;
                }
            }
            if ((injectionHost.getTextLength() == injectionRange.getEndOffset() && injectionRange.getStartOffset() == 0 || this.canProcessFragment((childText = injectionHost.getText()).substring(0, injectionRange.getStartOffset()), injectionHost) && this.canProcessFragment(childText.substring(injectionRange.getEndOffset()), injectionHost)) && (builder2 = LanguageFormatting.INSTANCE.forContext(childLanguage = injectedPsi.getLanguage(), injectionHost.getPsi())) != null) {
                int startOffset = injectionRange.getStartOffset();
                int endOffset = injectionRange.getEndOffset();
                TextRange range2 = injectionHost.getTextRange();
                int prefixLength = shred.getPrefix().length();
                int suffixLength = shred.getSuffix().length();
                int childOffset = range2.getStartOffset();
                if ((Integer)lastInjectionEndOffset.get() < startOffset) {
                    result2.add(this.createBlock(injectionHost, wrap, alignment, indent, new TextRange(((Integer)lastInjectionEndOffset.get()).intValue(), startOffset)));
                }
                this.addInjectedLanguageBlockWrapper(result2, (ASTNode)injectedPsi.getNode(), indent, childOffset + startOffset, new TextRange(prefixLength, injectedPsi.getTextLength() - suffixLength));
                lastInjectionEndOffset.set((Object)endOffset);
            }
        };
        PsiElement injectionHostPsi = injectionHost.getPsi();
        PsiFile containingFile = injectionHostPsi.getContainingFile();
        InjectedLanguageManager.getInstance((Project)containingFile.getProject()).enumerateEx(injectionHostPsi, containingFile, true, injectedPsiVisitor);
        if ((Integer)lastInjectionEndOffset.get() > 0) {
            if ((Integer)lastInjectionEndOffset.get() < injectionHost.getTextLength()) {
                result2.add((Block)this.createBlock(injectionHost, wrap, alignment, indent, new TextRange(((Integer)lastInjectionEndOffset.get()).intValue(), injectionHost.getTextLength())));
            }
            return true;
        }
        return false;
    }

    private Block createBlock(ASTNode injectionHost, Wrap wrap, Alignment alignment, Indent indent, TextRange range2) {
        if (range2.getStartOffset() == 0) {
            ASTNode leaf = injectionHost.findLeafElementAt(range2.getEndOffset() - 1);
            return this.createBlockBeforeInjection(leaf, wrap, alignment, indent, range2.shiftRight(injectionHost.getStartOffset()));
        }
        ASTNode leaf = injectionHost.findLeafElementAt(range2.getStartOffset());
        return this.createBlockAfterInjection(leaf, wrap, alignment, indent, range2.shiftRight(injectionHost.getStartOffset()));
    }

    public void addInjectedLanguageBlockWrapper(List<? super Block> result2, ASTNode injectedNode, Indent indent, int offset, @Nullable TextRange range2) {
        PsiElement childPsi;
        Language childLanguage;
        FormattingModelBuilder builder2;
        if (range2 != null) {
            if (range2.getLength() == 0) {
                return;
            }
            if (StringUtil.isEmptyOrSpaces((String)range2.substring(injectedNode.getText()))) {
                return;
            }
        }
        LOG.assertTrue((builder2 = LanguageFormatting.INSTANCE.forContext(childLanguage = (childPsi = injectedNode.getPsi()).getLanguage(), childPsi)) != null);
        FormattingModel childModel = builder2.createModel(childPsi, this.getSettings());
        Block original = childModel.getRootBlock();
        if (original.isLeaf() && !injectedNode.getText().trim().isEmpty() || !original.getSubBlocks().isEmpty()) {
            result2.add((Block)this.createInjectedBlock(injectedNode, original, indent, offset, range2, childLanguage));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "node";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "originalBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "language";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/formatter/common/InjectedLanguageBlockBuilder";
        objectArray[2] = "createInjectedBlock";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

