/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveFilesOrDirectoriesHandler
extends MoveHandlerDelegate {
    private static final Logger LOG = Logger.getInstance(MoveFilesOrDirectoriesHandler.class);

    @Override
    public boolean canMove(PsiElement[] elements2, PsiElement targetContainer, @Nullable PsiReference reference2) {
        HashSet<String> names2 = new HashSet<String>();
        for (PsiElement element2 : elements2) {
            if (element2 instanceof PsiFile) {
                PsiFile file2 = (PsiFile)element2;
                String name = file2.getName();
                if (names2.contains(name)) {
                    return false;
                }
                names2.add(name);
                continue;
            }
            if (element2 instanceof PsiDirectory) continue;
            return false;
        }
        return super.canMove(elements2, targetContainer, reference2);
    }

    @Override
    public boolean isValidTarget(PsiElement targetElement, PsiElement[] sources) {
        return MoveFilesOrDirectoriesHandler.isValidTarget(targetElement);
    }

    public static boolean isValidTarget(PsiElement psiElement) {
        if (psiElement == null) {
            return true;
        }
        if (!(psiElement instanceof PsiDirectory) && !(psiElement instanceof PsiDirectoryContainer)) {
            return false;
        }
        if (psiElement.getManager().isInProject(psiElement)) {
            return true;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
        return ScratchUtil.isScratch(virtualFile) || virtualFile != null && ProjectRootManager.getInstance((Project)psiElement.getProject()).getFileIndex().isExcluded(virtualFile);
    }

    public void doMove(PsiElement[] elements2, PsiElement targetContainer) {
        Project project = targetContainer != null ? targetContainer.getProject() : elements2[0].getProject();
        this.doMove(project, elements2, targetContainer, null);
    }

    @Override
    public PsiElement @Nullable [] adjustForMove(Project project, PsiElement[] sourceElements, PsiElement targetElement) {
        return PsiTreeUtil.filterAncestors((PsiElement[])sourceElements);
    }

    @Override
    public void doMove(Project project, PsiElement[] elements2, PsiElement targetContainer, @Nullable MoveCallback callback2) {
        if (!LOG.assertTrue(targetContainer == null || targetContainer instanceof PsiDirectory || targetContainer instanceof PsiDirectoryContainer, (Object)("container: " + targetContainer + "; elements: " + Arrays.toString(elements2) + "; working handler: " + this.toString()))) {
            return;
        }
        PsiElement[] adjustedElements = this.adjustForMove(project, elements2, targetContainer);
        if (adjustedElements != null) {
            MoveFilesOrDirectoriesUtil.doMove(project, adjustedElements, new PsiElement[]{targetContainer}, callback2);
        }
    }

    @Override
    public boolean tryToMove(PsiElement element2, Project project, DataContext dataContext, PsiReference reference2, Editor editor) {
        if (element2 instanceof PsiFile && ((PsiFile)element2).getVirtualFile() != null || element2 instanceof PsiDirectory) {
            this.doMove(project, new PsiElement[]{element2}, (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext), null);
            return true;
        }
        if (element2 instanceof PsiPlainText) {
            PsiFile file2 = element2.getContainingFile();
            if (file2 != null) {
                this.doMove(project, new PsiElement[]{file2}, null, null);
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getActionName(PsiElement @NotNull [] elements2) {
        if (elements2 == null) {
            MoveFilesOrDirectoriesHandler.$$$reportNull$$$0(0);
        }
        int fileCount = 0;
        int directoryCount = 0;
        for (PsiElement element2 : elements2) {
            if (element2 instanceof PsiFile) {
                ++fileCount;
                continue;
            }
            if (!(element2 instanceof PsiDirectory)) continue;
            ++directoryCount;
        }
        if (directoryCount == 0) {
            return fileCount == 1 ? RefactoringBundle.message((String)"move.file") : RefactoringBundle.message((String)"move.files");
        }
        if (fileCount == 0) {
            return directoryCount == 1 ? RefactoringBundle.message((String)"move.directory") : RefactoringBundle.message((String)"move.directories.with.dialog");
        }
        return RefactoringBundle.message((String)"move.files.and.directories");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesHandler", "getActionName"));
    }
}

