/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.Gray;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class LegalNoticeDialog
extends DialogWrapper {
    private final Builder myBuilder;
    private JComponent myFocusedComponent;

    public static Builder build(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String message) {
        if (title == null) {
            LegalNoticeDialog.$$$reportNull$$$0(0);
        }
        if (message == null) {
            LegalNoticeDialog.$$$reportNull$$$0(1);
        }
        return new Builder(title, message);
    }

    private LegalNoticeDialog(Builder builder2) {
        super(builder2.project, builder2.parent, true, DialogWrapper.IdeModalityType.PROJECT);
        this.myBuilder = builder2;
        this.setTitle(builder2.title);
        this.setOKButtonText(CommonBundle.message((String)"button.accept", (Object[])new Object[0]));
        this.setCancelButtonText(builder2.cancelText != null ? builder2.cancelText : CommonBundle.message((String)"button.decline", (Object[])new Object[0]));
        this.init();
        this.pack();
    }

    protected JComponent createCenterPanel() {
        JPanel iconPanel = new JPanel(new BorderLayout());
        iconPanel.add((Component)new JBLabel(AllIcons.General.WarningDialog), "North");
        JEditorPane messageArea = new JEditorPane();
        messageArea.setEditorKit(UIUtil.getHTMLEditorKit());
        messageArea.setEditable(false);
        messageArea.setPreferredSize((Dimension)JBUI.size((int)500, (int)100));
        messageArea.setBorder(new CompoundBorder(BorderFactory.createLineBorder((Color)Gray._200), JBUI.Borders.empty((int)3)));
        messageArea.setText(UIUtil.toHtml((String)this.myBuilder.message));
        this.myFocusedComponent = messageArea;
        JPanel panel2 = new JPanel(new BorderLayout(JBUIScale.scale((int)3), 0));
        panel2.add((Component)iconPanel, "West");
        panel2.add((Component)messageArea, "Center");
        return panel2;
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        if (this.myBuilder.customAction != null) {
            actions.add((Action)new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, (String)((Builder)this.myBuilder).customAction.first, ((Integer)((Builder)this.myBuilder).customAction.second).intValue()));
        }
        actions.add(this.getCancelAction());
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            LegalNoticeDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFocusedComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/LegalNoticeDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/LegalNoticeDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder {
        private final String title;
        private final String message;
        private Project project;
        private Component parent;
        private String cancelText;
        private Pair<String, Integer> customAction;

        private Builder(String title, String message) {
            this.title = title;
            this.message = message;
        }

        public Builder withParent(Project project) {
            this.project = project;
            return this;
        }

        public Builder withParent(Component parent) {
            this.parent = parent;
            return this;
        }

        public Builder withCancelText(@NotNull @Nls String text) {
            if (text == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.cancelText = text;
            return this;
        }

        public Builder withCustomAction(@NotNull @Nls String text, int exitCode) {
            if (text == null) {
                Builder.$$$reportNull$$$0(1);
            }
            assert (exitCode >= 2);
            this.customAction = Pair.pair((Object)text, (Object)exitCode);
            return this;
        }

        public int show() {
            LegalNoticeDialog dialog2 = new LegalNoticeDialog(this);
            dialog2.show();
            return dialog2.getExitCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "text";
            objectArray2[1] = "com/intellij/ui/components/LegalNoticeDialog$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withCancelText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withCustomAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

