/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diff.impl.patch.AirContentRevision;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.BeforeAfter;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextPatchBuilder {
    private static final int CONTEXT_LINES = 3;
    @NonNls
    private static final String REVISION_NAME_TEMPLATE = "(revision {0})";
    @NonNls
    private static final String DATE_NAME_TEMPLATE = "(date {0})";
    @NotNull
    private final String myBasePath;
    private final boolean myIsReversePath;
    @Nullable
    private final Runnable myCancelChecker;

    private TextPatchBuilder(@NotNull String basePath, boolean isReversePath, @Nullable Runnable cancelChecker) {
        if (basePath == null) {
            TextPatchBuilder.$$$reportNull$$$0(0);
        }
        this.myBasePath = basePath;
        this.myIsReversePath = isReversePath;
        this.myCancelChecker = cancelChecker;
    }

    @NotNull
    public static List<FilePatch> buildPatch(@NotNull Collection<? extends BeforeAfter<AirContentRevision>> changes, @NotNull String basePath, boolean reversePatch, @Nullable Runnable cancelChecker) throws VcsException {
        if (changes == null) {
            TextPatchBuilder.$$$reportNull$$$0(1);
        }
        if (basePath == null) {
            TextPatchBuilder.$$$reportNull$$$0(2);
        }
        TextPatchBuilder builder = new TextPatchBuilder(basePath, reversePatch, cancelChecker);
        return builder.build(changes);
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static List<FilePatch> buildPatch(@NotNull Collection<? extends BeforeAfter<AirContentRevision>> changes, @NotNull String basePath, boolean reversePatch, boolean isCaseSensitive, @Nullable Runnable cancelChecker) throws VcsException {
        if (changes == null) {
            TextPatchBuilder.$$$reportNull$$$0(3);
        }
        if (basePath == null) {
            TextPatchBuilder.$$$reportNull$$$0(4);
        }
        return TextPatchBuilder.buildPatch(changes, basePath, reversePatch, cancelChecker);
    }

    @NotNull
    private List<FilePatch> build(@NotNull Collection<? extends BeforeAfter<AirContentRevision>> changes) throws VcsException {
        if (changes == null) {
            TextPatchBuilder.$$$reportNull$$$0(5);
        }
        ArrayList<FilePatch> result2 = new ArrayList<FilePatch>();
        for (BeforeAfter<AirContentRevision> beforeAfter : changes) {
            AirContentRevision afterRevision;
            AirContentRevision beforeRevision;
            FilePatch patch;
            if (this.myCancelChecker != null) {
                this.myCancelChecker.run();
            }
            if ((patch = this.createPatch(beforeRevision = this.myIsReversePath ? (AirContentRevision)beforeAfter.getAfter() : (AirContentRevision)beforeAfter.getBefore(), afterRevision = this.myIsReversePath ? (AirContentRevision)beforeAfter.getBefore() : (AirContentRevision)beforeAfter.getAfter())) == null) continue;
            result2.add(patch);
        }
        ArrayList<FilePatch> arrayList = result2;
        if (arrayList == null) {
            TextPatchBuilder.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    private FilePatch createPatch(@Nullable AirContentRevision beforeRevision, @Nullable AirContentRevision afterRevision) throws VcsException {
        if (beforeRevision == null && afterRevision == null) {
            return null;
        }
        if (beforeRevision != null && beforeRevision.getPath().isDirectory()) {
            return null;
        }
        if (afterRevision != null && afterRevision.getPath().isDirectory()) {
            return null;
        }
        if (beforeRevision != null && beforeRevision.isBinary() || afterRevision != null && afterRevision.isBinary()) {
            return this.buildBinaryPatch(beforeRevision, afterRevision);
        }
        if (beforeRevision == null) {
            return this.buildAddedFile(afterRevision);
        }
        if (afterRevision == null) {
            return this.buildDeletedFile(beforeRevision);
        }
        return this.buildModifiedFile(beforeRevision, afterRevision);
    }

    @Nullable
    private TextFilePatch buildModifiedFile(@NotNull AirContentRevision beforeRevision, @NotNull AirContentRevision afterRevision) throws VcsException {
        if (beforeRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(7);
        }
        if (afterRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(8);
        }
        String beforeContent = TextPatchBuilder.getContent(beforeRevision);
        String afterContent = TextPatchBuilder.getContent(afterRevision);
        TextFilePatch patch = this.buildPatchHeading(beforeRevision, afterRevision);
        if (beforeContent.equals(afterContent)) {
            if (beforeRevision.getPath().getPath().equals(afterRevision.getPath().getPath())) {
                return null;
            }
            return patch;
        }
        List<PatchHunk> hunks = TextPatchBuilder.buildPatchHunks(beforeContent, afterContent);
        for (PatchHunk hunk : hunks) {
            patch.addHunk(hunk);
        }
        return patch;
    }

    @NotNull
    public static List<PatchHunk> buildPatchHunks(@NotNull String beforeContent, @NotNull String afterContent) {
        List<Range> hunkFragments;
        if (beforeContent == null) {
            TextPatchBuilder.$$$reportNull$$$0(9);
        }
        if (afterContent == null) {
            TextPatchBuilder.$$$reportNull$$$0(10);
        }
        if (beforeContent.isEmpty()) {
            List<PatchHunk> list = Collections.singletonList(TextPatchBuilder.createWholeFileHunk(afterContent, true, true));
            if (list == null) {
                TextPatchBuilder.$$$reportNull$$$0(11);
            }
            return list;
        }
        if (afterContent.isEmpty()) {
            List<PatchHunk> list = Collections.singletonList(TextPatchBuilder.createWholeFileHunk(beforeContent, false, true));
            if (list == null) {
                TextPatchBuilder.$$$reportNull$$$0(12);
            }
            return list;
        }
        ArrayList<PatchHunk> hunks = new ArrayList<PatchHunk>();
        List<String> beforeLines = TextPatchBuilder.tokenize(beforeContent);
        List<String> afterLines = TextPatchBuilder.tokenize(afterContent);
        boolean beforeNoNewlineAtEOF = !beforeContent.endsWith("\n");
        boolean afterNoNewlineAtEOF = !afterContent.endsWith("\n");
        List<Range> fragments = TextPatchBuilder.compareLines(beforeLines, afterLines, beforeNoNewlineAtEOF, afterNoNewlineAtEOF);
        for (int hunkStart = 0; hunkStart < fragments.size(); hunkStart += hunkFragments.size()) {
            hunkFragments = TextPatchBuilder.getAdjacentFragments(fragments, hunkStart);
            hunks.add(TextPatchBuilder.createHunk(hunkFragments, beforeLines, afterLines, beforeNoNewlineAtEOF, afterNoNewlineAtEOF));
        }
        ArrayList<PatchHunk> arrayList = hunks;
        if (arrayList == null) {
            TextPatchBuilder.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private static List<Range> getAdjacentFragments(@NotNull List<Range> fragments, int hunkStart) {
        int hunkEnd;
        if (fragments == null) {
            TextPatchBuilder.$$$reportNull$$$0(14);
        }
        for (hunkEnd = hunkStart + 1; hunkEnd < fragments.size(); ++hunkEnd) {
            Range lastFragment = fragments.get(hunkEnd - 1);
            Range nextFragment = fragments.get(hunkEnd);
            if (lastFragment.end1 + 3 < nextFragment.start1 - 3 && lastFragment.end2 + 3 < nextFragment.start2 - 3) break;
        }
        List<Range> list = fragments.subList(hunkStart, hunkEnd);
        if (list == null) {
            TextPatchBuilder.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private static PatchHunk createHunk(@NotNull List<? extends Range> hunkFragments, @NotNull List<String> beforeLines, @NotNull List<String> afterLines, boolean beforeNoNewlineAtEOF, boolean afterNoNewlineAtEOF) {
        if (hunkFragments == null) {
            TextPatchBuilder.$$$reportNull$$$0(16);
        }
        if (beforeLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(17);
        }
        if (afterLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(18);
        }
        Range first = hunkFragments.get(0);
        Range last = hunkFragments.get(hunkFragments.size() - 1);
        int contextStart1 = Math.max(first.start1 - 3, 0);
        int contextStart2 = Math.max(first.start2 - 3, 0);
        int contextEnd1 = Math.min(last.end1 + 3, beforeLines.size());
        int contextEnd2 = Math.min(last.end2 + 3, afterLines.size());
        PatchHunk hunk = new PatchHunk(contextStart1, contextEnd1, contextStart2, contextEnd2);
        int lastLine1 = contextStart1;
        int lastLine2 = contextStart2;
        for (Range range : hunkFragments) {
            int i;
            int start1 = range.start1;
            int start2 = range.start2;
            int end1 = range.end1;
            int end2 = range.end2;
            assert (start1 - lastLine1 == start2 - lastLine2);
            for (i = lastLine1; i < start1; ++i) {
                TextPatchBuilder.addLineToHunk(hunk, beforeLines, PatchLine.Type.CONTEXT, i, beforeNoNewlineAtEOF);
            }
            for (i = start1; i < end1; ++i) {
                TextPatchBuilder.addLineToHunk(hunk, beforeLines, PatchLine.Type.REMOVE, i, beforeNoNewlineAtEOF);
            }
            for (i = start2; i < end2; ++i) {
                TextPatchBuilder.addLineToHunk(hunk, afterLines, PatchLine.Type.ADD, i, afterNoNewlineAtEOF);
            }
            lastLine1 = end1;
            lastLine2 = end2;
        }
        assert (contextEnd1 - lastLine1 == contextEnd2 - lastLine2);
        for (int i = lastLine1; i < contextEnd1; ++i) {
            TextPatchBuilder.addLineToHunk(hunk, beforeLines, PatchLine.Type.CONTEXT, i, beforeNoNewlineAtEOF);
        }
        PatchHunk patchHunk = hunk;
        if (patchHunk == null) {
            TextPatchBuilder.$$$reportNull$$$0(19);
        }
        return patchHunk;
    }

    @NotNull
    private static List<Range> compareLines(@NotNull List<String> beforeLines, @NotNull List<String> afterLines, boolean beforeNoNewlineAtEOF, boolean afterNoNewlineAtEOF) {
        if (beforeLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(20);
        }
        if (afterLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(21);
        }
        if (!beforeNoNewlineAtEOF && !afterNoNewlineAtEOF) {
            return TextPatchBuilder.doCompareLines(beforeLines, afterLines);
        }
        int beforeLastLine = beforeLines.size() - 1;
        int afterLastLine = afterLines.size() - 1;
        List<String> beforeComparedLines = beforeNoNewlineAtEOF ? beforeLines.subList(0, beforeLastLine) : beforeLines;
        List<String> afterComparedLines = afterNoNewlineAtEOF ? afterLines.subList(0, afterLastLine) : afterLines;
        List<Range> ranges = TextPatchBuilder.doCompareLines(beforeComparedLines, afterComparedLines);
        if (beforeNoNewlineAtEOF && afterNoNewlineAtEOF) {
            if (beforeLines.get(beforeLastLine).equals(afterLines.get(afterLastLine))) {
                List<Range> list = ranges;
                if (list == null) {
                    TextPatchBuilder.$$$reportNull$$$0(22);
                }
                return list;
            }
            Range range = new Range(beforeLastLine, beforeLastLine + 1, afterLastLine, afterLastLine + 1);
            return TextPatchBuilder.appendRange(ranges, range);
        }
        if (beforeNoNewlineAtEOF) {
            Range range = new Range(beforeLastLine, beforeLastLine + 1, afterLastLine + 1, afterLastLine + 1);
            return TextPatchBuilder.appendRange(ranges, range);
        }
        Range range = new Range(beforeLastLine + 1, beforeLastLine + 1, afterLastLine, afterLastLine + 1);
        return TextPatchBuilder.appendRange(ranges, range);
    }

    @NotNull
    private static List<Range> appendRange(@NotNull List<? extends Range> ranges, @NotNull Range change) {
        if (ranges == null) {
            TextPatchBuilder.$$$reportNull$$$0(23);
        }
        if (change == null) {
            TextPatchBuilder.$$$reportNull$$$0(24);
        }
        if (ranges.isEmpty()) {
            List<Range> list = Collections.singletonList(change);
            if (list == null) {
                TextPatchBuilder.$$$reportNull$$$0(25);
            }
            return list;
        }
        Range lastRange = ranges.get(ranges.size() - 1);
        if (lastRange.end1 == change.start1 && lastRange.end2 == change.start2) {
            Range mergedChange = new Range(lastRange.start1, change.end1, lastRange.start2, change.end2);
            List list = ContainerUtil.append(ranges.subList(0, ranges.size() - 1), (Object[])new Range[]{mergedChange});
            if (list == null) {
                TextPatchBuilder.$$$reportNull$$$0(26);
            }
            return list;
        }
        List list = ContainerUtil.append(ranges, (Object[])new Range[]{change});
        if (list == null) {
            TextPatchBuilder.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    private static List<Range> doCompareLines(@NotNull List<String> beforeLines, @NotNull List<String> afterLines) {
        ArrayList arrayList;
        if (beforeLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(28);
        }
        if (afterLines == null) {
            TextPatchBuilder.$$$reportNull$$$0(29);
        }
        try {
            FairDiffIterable iterable = ByLine.compare(beforeLines, afterLines, (ComparisonPolicy)ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            arrayList = ContainerUtil.newArrayList((Iterable)iterable.iterateChanges());
        }
        catch (DiffTooBigException e) {
            List<Range> list = Collections.singletonList(new Range(0, beforeLines.size(), 0, afterLines.size()));
            if (list == null) {
                TextPatchBuilder.$$$reportNull$$$0(31);
            }
            return list;
        }
        if (arrayList == null) {
            TextPatchBuilder.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @NotNull
    private FilePatch buildBinaryPatch(@Nullable AirContentRevision beforeRevision, @Nullable AirContentRevision afterRevision) throws VcsException {
        assert (beforeRevision != null || afterRevision != null);
        AirContentRevision headingBeforeRevision = beforeRevision != null ? beforeRevision : afterRevision;
        AirContentRevision headingAfterRevision = afterRevision != null ? afterRevision : beforeRevision;
        byte[] beforeContent = beforeRevision != null ? beforeRevision.getContentAsBytes() : null;
        byte[] afterContent = afterRevision != null ? afterRevision.getContentAsBytes() : null;
        BinaryFilePatch patch = new BinaryFilePatch(beforeContent, afterContent);
        this.setPatchHeading((FilePatch)patch, headingBeforeRevision, headingAfterRevision);
        BinaryFilePatch binaryFilePatch = patch;
        if (binaryFilePatch == null) {
            TextPatchBuilder.$$$reportNull$$$0(32);
        }
        return binaryFilePatch;
    }

    @NotNull
    private TextFilePatch buildAddedFile(@NotNull AirContentRevision afterRevision) throws VcsException {
        if (afterRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(33);
        }
        TextFilePatch result2 = this.buildPatchHeading(afterRevision, afterRevision);
        result2.setFileStatus(FileStatus.ADDED);
        String content2 = TextPatchBuilder.getContent(afterRevision);
        if (!content2.isEmpty()) {
            result2.addHunk(TextPatchBuilder.createWholeFileHunk(content2, true, false));
        }
        TextFilePatch textFilePatch = result2;
        if (textFilePatch == null) {
            TextPatchBuilder.$$$reportNull$$$0(34);
        }
        return textFilePatch;
    }

    @NotNull
    private TextFilePatch buildDeletedFile(@NotNull AirContentRevision beforeRevision) throws VcsException {
        if (beforeRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(35);
        }
        TextFilePatch result2 = this.buildPatchHeading(beforeRevision, beforeRevision);
        result2.setFileStatus(FileStatus.DELETED);
        String content2 = TextPatchBuilder.getContent(beforeRevision);
        if (!content2.isEmpty()) {
            result2.addHunk(TextPatchBuilder.createWholeFileHunk(content2, false, false));
        }
        TextFilePatch textFilePatch = result2;
        if (textFilePatch == null) {
            TextPatchBuilder.$$$reportNull$$$0(36);
        }
        return textFilePatch;
    }

    private static void addLineToHunk(@NotNull PatchHunk hunk, @NotNull List<String> lines, @NotNull PatchLine.Type type, int index, boolean noNewlineAtEOF) {
        if (hunk == null) {
            TextPatchBuilder.$$$reportNull$$$0(37);
        }
        if (lines == null) {
            TextPatchBuilder.$$$reportNull$$$0(38);
        }
        if (type == null) {
            TextPatchBuilder.$$$reportNull$$$0(39);
        }
        String line = lines.get(index);
        boolean isLastLine = index == lines.size() - 1;
        PatchLine patchLine = new PatchLine(type, line);
        patchLine.setSuppressNewLine(noNewlineAtEOF && isLastLine);
        hunk.addLine(patchLine);
    }

    @NotNull
    private static PatchHunk createWholeFileHunk(@NotNull String content2, boolean isInsertion, boolean isWithEmptyFile) {
        if (content2 == null) {
            TextPatchBuilder.$$$reportNull$$$0(40);
        }
        PatchLine.Type type = isInsertion ? PatchLine.Type.ADD : PatchLine.Type.REMOVE;
        List<String> lines = TextPatchBuilder.tokenize(content2);
        boolean noNewlineAtEOF = !content2.endsWith("\n");
        int contentStart = 0;
        int contentEnd = lines.size();
        int emptyStart = isWithEmptyFile ? 0 : -1;
        int emptyEnd = isWithEmptyFile ? 0 : -1;
        PatchHunk hunk = new PatchHunk(isInsertion ? emptyStart : contentStart, isInsertion ? emptyEnd : contentEnd, isInsertion ? contentStart : emptyStart, isInsertion ? contentEnd : emptyEnd);
        for (int i = 0; i < lines.size(); ++i) {
            TextPatchBuilder.addLineToHunk(hunk, lines, type, i, noNewlineAtEOF);
        }
        PatchHunk patchHunk = hunk;
        if (patchHunk == null) {
            TextPatchBuilder.$$$reportNull$$$0(41);
        }
        return patchHunk;
    }

    @NotNull
    public static String getRelativePath(@NotNull String basePath, @NotNull String secondPath) {
        String secondModified;
        String baseModified;
        String relPath;
        if (basePath == null) {
            TextPatchBuilder.$$$reportNull$$$0(42);
        }
        if (secondPath == null) {
            TextPatchBuilder.$$$reportNull$$$0(43);
        }
        if ((relPath = FileUtil.getRelativePath((String)(baseModified = FileUtil.toSystemIndependentName((String)basePath)), (String)(secondModified = FileUtil.toSystemIndependentName((String)secondPath)), (char)'/', (boolean)SystemInfo.isFileSystemCaseSensitive)) == null) {
            String string = secondModified;
            if (string == null) {
                TextPatchBuilder.$$$reportNull$$$0(44);
            }
            return string;
        }
        String string = relPath;
        if (string == null) {
            TextPatchBuilder.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    private TextFilePatch buildPatchHeading(@NotNull AirContentRevision beforeRevision, @NotNull AirContentRevision afterRevision) {
        if (beforeRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(46);
        }
        if (afterRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(47);
        }
        TextFilePatch result2 = new TextFilePatch(afterRevision.getCharset(), afterRevision.getLineSeparator());
        this.setPatchHeading((FilePatch)result2, beforeRevision, afterRevision);
        TextFilePatch textFilePatch = result2;
        if (textFilePatch == null) {
            TextPatchBuilder.$$$reportNull$$$0(48);
        }
        return textFilePatch;
    }

    private void setPatchHeading(@NotNull FilePatch result2, @NotNull AirContentRevision beforeRevision, @NotNull AirContentRevision afterRevision) {
        if (result2 == null) {
            TextPatchBuilder.$$$reportNull$$$0(49);
        }
        if (beforeRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(50);
        }
        if (afterRevision == null) {
            TextPatchBuilder.$$$reportNull$$$0(51);
        }
        result2.setBeforeName(TextPatchBuilder.getRelativePath(this.myBasePath, beforeRevision.getPath().getPath()));
        result2.setBeforeVersionId(TextPatchBuilder.getRevisionName(beforeRevision));
        result2.setAfterName(TextPatchBuilder.getRelativePath(this.myBasePath, afterRevision.getPath().getPath()));
        result2.setAfterVersionId(TextPatchBuilder.getRevisionName(afterRevision));
    }

    @NotNull
    private static String getRevisionName(@NotNull AirContentRevision revision) {
        String revisionName;
        if (revision == null) {
            TextPatchBuilder.$$$reportNull$$$0(52);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(revisionName = revision.getRevisionNumber()))) {
            String string = MessageFormat.format(REVISION_NAME_TEMPLATE, revisionName);
            if (string == null) {
                TextPatchBuilder.$$$reportNull$$$0(53);
            }
            return string;
        }
        String string = MessageFormat.format(DATE_NAME_TEMPLATE, Long.toString(revision.getPath().lastModified()));
        if (string == null) {
            TextPatchBuilder.$$$reportNull$$$0(54);
        }
        return string;
    }

    @NotNull
    private static String getContent(@NotNull AirContentRevision revision) throws VcsException {
        String beforeContent;
        if (revision == null) {
            TextPatchBuilder.$$$reportNull$$$0(55);
        }
        if ((beforeContent = revision.getContentAsString()) == null) {
            throw new VcsException(String.format("Failed to fetch old content for file %s in revision %s", revision.getPath().getPath(), revision.getRevisionNumber()));
        }
        String string = beforeContent;
        if (string == null) {
            TextPatchBuilder.$$$reportNull$$$0(56);
        }
        return string;
    }

    @NotNull
    private static List<String> tokenize(@NotNull String text2) {
        if (text2 == null) {
            TextPatchBuilder.$$$reportNull$$$0(57);
        }
        List list = LineTokenizer.tokenizeIntoList((CharSequence)text2, (boolean)false, (boolean)true);
        if (list == null) {
            TextPatchBuilder.$$$reportNull$$$0(58);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 53: 
            case 54: 
            case 56: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 53: 
            case 54: 
            case 56: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 53: 
            case 54: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/TextPatchBuilder";
                break;
            }
            case 7: 
            case 35: 
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeRevision";
                break;
            }
            case 8: 
            case 33: 
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterRevision";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeContent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterContent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hunkFragments";
                break;
            }
            case 17: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeLines";
                break;
            }
            case 18: 
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterLines";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hunk";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondPath";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/TextPatchBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatchHunks";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjacentFragments";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createHunk";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "compareLines";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRange";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompareLines";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "buildBinaryPatch";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAddedFile";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDeletedFile";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createWholeFileHunk";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatchHeading";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionName";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildPatch";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 53: 
            case 54: 
            case 56: 
            case 58: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildModifiedFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildPatchHunks";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAdjacentFragments";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createHunk";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "compareLines";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "appendRange";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doCompareLines";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "buildAddedFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "buildDeletedFile";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addLineToHunk";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createWholeFileHunk";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "buildPatchHeading";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "setPatchHeading";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionName";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 48: 
            case 53: 
            case 54: 
            case 56: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

