/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.tool.ApplyPatchViewer;
import com.intellij.openapi.vcs.changes.patch.tool.PatchChangeBuilder;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApplyPatchChange {
    @NotNull
    private final ApplyPatchViewer myViewer;
    private final int myIndex;
    @NotNull
    private final LineRange myPatchDeletionRange;
    @NotNull
    private final LineRange myPatchInsertionRange;
    @NotNull
    private final AppliedTextPatch.HunkStatus myStatus;
    @Nullable
    private final List<DiffFragment> myPatchInnerDifferences;
    @NotNull
    private final List<DiffGutterOperation> myOperations;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;
    private boolean myResolved;

    ApplyPatchChange(@NotNull PatchChangeBuilder.Hunk hunk, int index, @NotNull ApplyPatchViewer viewer) {
        if (hunk == null) {
            ApplyPatchChange.$$$reportNull$$$0(0);
        }
        if (viewer == null) {
            ApplyPatchChange.$$$reportNull$$$0(1);
        }
        this.myOperations = new ArrayList<DiffGutterOperation>();
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myIndex = index;
        this.myViewer = viewer;
        this.myPatchDeletionRange = hunk.getPatchDeletionRange();
        this.myPatchInsertionRange = hunk.getPatchInsertionRange();
        this.myStatus = hunk.getStatus();
        DocumentEx patchDocument = viewer.getPatchEditor().getDocument();
        this.myPatchInnerDifferences = PatchChangeBuilder.computeInnerDifferences((Document)patchDocument, hunk);
    }

    public void reinstallHighlighters() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.myViewer.repaintDivider();
    }

    private void installHighlighters() {
        this.createResultHighlighters();
        this.createPatchHighlighters();
        this.createStatusHighlighter();
        this.createOperations();
    }

    private void createPatchHighlighters() {
        EditorEx patchEditor = this.myViewer.getPatchEditor();
        this.myHighlighters.addAll(DiffDrawUtil.createUnifiedChunkHighlighters((Editor)patchEditor, (LineRange)this.myPatchDeletionRange, (LineRange)this.myPatchInsertionRange, this.myPatchInnerDifferences));
    }

    private void createResultHighlighters() {
        LineRange resultRange = this.getResultRange();
        if (resultRange == null) {
            return;
        }
        EditorEx editor = this.myViewer.getResultEditor();
        int startLine = resultRange.start;
        int endLine = resultRange.end;
        TextDiffType type = this.getDiffType();
        boolean resolved = this.isRangeApplied();
        this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder((Editor)editor, startLine, endLine, type).withResolved(resolved).done());
    }

    private void createStatusHighlighter() {
        int line1 = this.myPatchDeletionRange.start;
        int line2 = this.myPatchInsertionRange.end;
        Color color = this.getStatusColor();
        if (this.isResolved()) {
            color = ColorUtil.mix((Color)color, (Color)this.myViewer.getPatchEditor().getGutterComponentEx().getBackground(), (double)0.6f);
        }
        String tooltip = this.getStatusText();
        EditorEx patchEditor = this.myViewer.getPatchEditor();
        DocumentEx document = patchEditor.getDocument();
        MarkupModelEx markupModel = patchEditor.getMarkupModel();
        TextRange textRange = DiffUtil.getLinesRange((Document)document, (int)line1, (int)line2);
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(null, textRange.getStartOffset(), textRange.getEndOffset(), 6000, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new MyGutterRenderer(line1, line2, color, tooltip));
        this.myHighlighters.add(highlighter);
    }

    private void destroyHighlighters() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (DiffGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    public AppliedTextPatch.HunkStatus getStatus() {
        AppliedTextPatch.HunkStatus hunkStatus = this.myStatus;
        if (hunkStatus == null) {
            ApplyPatchChange.$$$reportNull$$$0(2);
        }
        return hunkStatus;
    }

    @NotNull
    public LineRange getPatchRange() {
        return new LineRange(this.myPatchDeletionRange.start, this.myPatchInsertionRange.end);
    }

    @NotNull
    public LineRange getPatchAffectedRange() {
        LineRange lineRange = this.isRangeApplied() ? this.myPatchInsertionRange : this.myPatchDeletionRange;
        if (lineRange == null) {
            ApplyPatchChange.$$$reportNull$$$0(3);
        }
        return lineRange;
    }

    @NotNull
    public LineRange getPatchDeletionRange() {
        LineRange lineRange = this.myPatchDeletionRange;
        if (lineRange == null) {
            ApplyPatchChange.$$$reportNull$$$0(4);
        }
        return lineRange;
    }

    @NotNull
    public LineRange getPatchInsertionRange() {
        LineRange lineRange = this.myPatchInsertionRange;
        if (lineRange == null) {
            ApplyPatchChange.$$$reportNull$$$0(5);
        }
        return lineRange;
    }

    @Nullable
    public LineRange getResultRange() {
        ApplyPatchViewer.MyModel model = this.myViewer.getModel();
        int lineStart = model.getLineStart(this.myIndex);
        int lineEnd = model.getLineEnd(this.myIndex);
        if (lineStart != -1 || lineEnd != -1) {
            return new LineRange(lineStart, lineEnd);
        }
        return null;
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    public void setResolved(boolean resolved) {
        this.myResolved = resolved;
    }

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = DiffUtil.getDiffType((!this.myPatchDeletionRange.isEmpty() ? 1 : 0) != 0, (!this.myPatchInsertionRange.isEmpty() ? 1 : 0) != 0);
        if (textDiffType == null) {
            ApplyPatchChange.$$$reportNull$$$0(6);
        }
        return textDiffType;
    }

    public boolean isRangeApplied() {
        return this.myResolved || this.getStatus() == AppliedTextPatch.HunkStatus.ALREADY_APPLIED;
    }

    @NotNull
    private String getStatusText() {
        switch (this.myStatus) {
            case ALREADY_APPLIED: {
                String string = VcsBundle.message((String)"patch.apply.already.applied.status", (Object[])new Object[0]);
                if (string == null) {
                    ApplyPatchChange.$$$reportNull$$$0(7);
                }
                return string;
            }
            case EXACTLY_APPLIED: {
                String string = VcsBundle.message((String)"patch.apply.automatically.applied.status", (Object[])new Object[0]);
                if (string == null) {
                    ApplyPatchChange.$$$reportNull$$$0(8);
                }
                return string;
            }
            case NOT_APPLIED: {
                String string = VcsBundle.message((String)"patch.apply.not.applied.status", (Object[])new Object[0]);
                if (string == null) {
                    ApplyPatchChange.$$$reportNull$$$0(9);
                }
                return string;
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    private Color getStatusColor() {
        switch (this.myStatus) {
            case ALREADY_APPLIED: {
                Color color = JBColor.YELLOW.darker();
                if (color == null) {
                    ApplyPatchChange.$$$reportNull$$$0(10);
                }
                return color;
            }
            case EXACTLY_APPLIED: {
                return new JBColor(new Color(0, 180, 5), new Color(0, 147, 5));
            }
            case NOT_APPLIED: {
                Color color = JBColor.RED.darker();
                if (color == null) {
                    ApplyPatchChange.$$$reportNull$$$0(11);
                }
                return color;
            }
        }
        throw new IllegalStateException();
    }

    private void createOperations() {
        if (this.myViewer.isReadOnly()) {
            return;
        }
        if (this.isResolved()) {
            return;
        }
        if (this.myStatus == AppliedTextPatch.HunkStatus.EXACTLY_APPLIED) {
            ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(OperationType.APPLY));
        }
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(OperationType.IGNORE));
    }

    @Nullable
    private DiffGutterOperation createOperation(@NotNull OperationType type) {
        if (type == null) {
            ApplyPatchChange.$$$reportNull$$$0(12);
        }
        if (this.isResolved()) {
            return null;
        }
        EditorEx editor = this.myViewer.getPatchEditor();
        int offset = DiffGutterOperation.lineToOffset((Editor)editor, (int)this.getPatchRange().start);
        return new DiffGutterOperation.Simple((Editor)editor, offset, () -> {
            if (type == OperationType.APPLY) {
                return this.createApplyRenderer();
            }
            return this.createIgnoreRenderer();
        });
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer() {
        return ApplyPatchChange.createIconRenderer(DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]), DiffUtil.getArrowIcon((Side)Side.RIGHT), () -> this.myViewer.executeCommand(DiffBundle.message((String)"merge.dialog.accept.change.command", (Object[])new Object[0]), () -> this.myViewer.replaceChange(this)));
    }

    @Nullable
    private GutterIconRenderer createIgnoreRenderer() {
        return ApplyPatchChange.createIconRenderer(DiffBundle.message((String)"action.presentation.merge.ignore.text", (Object[])new Object[0]), AllIcons.Diff.Remove, () -> this.myViewer.executeCommand(DiffBundle.message((String)"merge.dialog.ignore.change.command", (Object[])new Object[0]), () -> this.myViewer.markChangeResolved(this)));
    }

    @Nullable
    private static GutterIconRenderer createIconRenderer(@NotNull String text2, @NotNull Icon icon2, final @NotNull Runnable perform) {
        if (text2 == null) {
            ApplyPatchChange.$$$reportNull$$$0(13);
        }
        if (icon2 == null) {
            ApplyPatchChange.$$$reportNull$$$0(14);
        }
        if (perform == null) {
            ApplyPatchChange.$$$reportNull$$$0(15);
        }
        String tooltipText = DiffUtil.createTooltipText((String)text2, null);
        return new DiffGutterRenderer(icon2, tooltipText){

            protected void handleMouseClick() {
                perform.run();
            }
        };
    }

    @NotNull
    public State storeState() {
        LineRange resultRange = this.getResultRange();
        return new State(this.myIndex, resultRange != null ? resultRange.start : -1, resultRange != null ? resultRange.end : -1, this.myResolved);
    }

    public void restoreState(@NotNull State state) {
        if (state == null) {
            ApplyPatchChange.$$$reportNull$$$0(16);
        }
        this.myResolved = state.myResolved;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hunk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "perform";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchAffectedRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchDeletionRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchInsertionRange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createOperation";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createIconRenderer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyGutterRenderer
    implements ActiveGutterRenderer {
        private final int myLine1;
        private final int myLine2;
        private final Color myColor;
        private final String myTooltip;

        MyGutterRenderer(int line1, int line2, Color color, String tooltip) {
            this.myLine1 = line1;
            this.myLine2 = line2;
            this.myColor = color;
            this.myTooltip = tooltip;
        }

        public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
            if (editor == null) {
                MyGutterRenderer.$$$reportNull$$$0(0);
            }
            if (g == null) {
                MyGutterRenderer.$$$reportNull$$$0(1);
            }
            if (r == null) {
                MyGutterRenderer.$$$reportNull$$$0(2);
            }
            LineStatusMarkerRenderer.paintSimpleRange((Graphics)g, (Editor)editor, (int)this.myLine1, (int)this.myLine2, (Color)this.myColor);
        }

        public String getTooltipText() {
            return this.myTooltip;
        }

        public boolean canDoAction(@NotNull MouseEvent e) {
            if (e == null) {
                MyGutterRenderer.$$$reportNull$$$0(3);
            }
            return LineStatusMarkerRenderer.isInsideMarkerArea((MouseEvent)e);
        }

        public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
            if (editor == null) {
                MyGutterRenderer.$$$reportNull$$$0(4);
            }
            if (e == null) {
                MyGutterRenderer.$$$reportNull$$$0(5);
            }
            if (ApplyPatchChange.this.getResultRange() != null) {
                ApplyPatchChange.this.myViewer.scrollToChange(ApplyPatchChange.this, Side.RIGHT, false);
            }
        }

        @NotNull
        public String getAccessibleName() {
            String string = VcsBundle.message((String)"patch.apply.marker.renderer", (Object[])new Object[]{this.getTooltipText()});
            if (string == null) {
                MyGutterRenderer.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange$MyGutterRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/tool/ApplyPatchChange$MyGutterRenderer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAccessibleName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "paint";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canDoAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "doAction";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class State
    extends MergeModelBase.State {
        private final boolean myResolved;

        public State(int index, int startLine, int endLine, boolean resolved) {
            super(index, startLine, endLine);
            this.myResolved = resolved;
        }
    }

    private static enum OperationType {
        APPLY,
        IGNORE;

    }
}

