/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.apache.axis.utils.XMLChar;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="YouTrack")
public class YouTrackRepository
extends BaseRepositoryImpl {
    private String myDefaultSearch = "Assignee: me sort by: updated #Unresolved";
    private static final Logger LOG = Logger.getInstance(YouTrackRepository.class);

    public YouTrackRepository() {
    }

    public YouTrackRepository(TaskRepositoryType type) {
        super(type);
    }

    @NotNull
    public BaseRepository clone() {
        return new YouTrackRepository(this);
    }

    private YouTrackRepository(YouTrackRepository other) {
        super((BaseRepositoryImpl)other);
        this.myDefaultSearch = other.getDefaultSearch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task[] getIssues(@Nullable String request, int max, long since) throws Exception {
        String query = this.getDefaultSearch();
        if (StringUtil.isNotEmpty((String)request)) {
            query = query + " " + request;
        }
        String requestUrl = "/rest/project/issues/?filter=" + YouTrackRepository.encodeUrl((String)query) + "&max=" + max + "&updatedAfter" + since;
        HttpMethod method = this.doREST(requestUrl, false);
        try {
            Element element;
            InputStream stream = method.getResponseBodyAsStream();
            String s = StreamUtil.readText((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            for (int i = 0; i < s.length(); ++i) {
                if (XMLChar.isValid((int)s.charAt(i))) continue;
                s = s.replace(s.charAt(i), ' ');
            }
            try {
                element = new SAXBuilder(false).build((Reader)new StringReader(s)).getRootElement();
            }
            catch (JDOMException e) {
                LOG.error("Can't parse YouTrack response for " + requestUrl, (Throwable)e);
                throw e;
            }
            if ("error".equals(element.getName())) {
                throw new Exception("Error from YouTrack for " + requestUrl + ": '" + element.getText() + "'");
            }
            List children = element.getChildren("issue");
            List tasks = ContainerUtil.mapNotNull((Collection)children, (Function)((NullableFunction)o -> this.createIssue((Element)o)));
            Task[] taskArray = tasks.toArray(Task.EMPTY_ARRAY);
            return taskArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        PostMethod method = new PostMethod(this.getUrl() + "/rest/user/login");
        return new BaseRepositoryImpl.HttpTestConnection<PostMethod>(method){

            protected void doTest(PostMethod method) throws Exception {
                YouTrackRepository.this.login(method);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClient login(PostMethod method) throws Exception {
        String response;
        HttpClient client = this.getHttpClient();
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.getUsername(), this.getPassword()));
        this.configureHttpMethod((HttpMethod)method);
        method.addParameter("login", this.getUsername());
        method.addParameter("password", this.getPassword());
        client.getParams().setContentCharset("UTF-8");
        client.executeMethod((HttpMethod)method);
        try {
            if (method.getStatusCode() != 200) {
                throw new HttpRequests.HttpStatusException("Cannot login", method.getStatusCode(), method.getPath());
            }
            response = method.getResponseBodyAsString(1000);
        }
        finally {
            method.releaseConnection();
        }
        if (response == null) {
            throw new NullPointerException();
        }
        if (!response.contains("<login>ok</login>")) {
            int length;
            int pos = response.indexOf("</error>");
            if (pos > (length = "<error>".length())) {
                response = response.substring(length, pos);
            }
            throw new Exception("Cannot login: " + response);
        }
        return client;
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        Element element;
        if (id == null) {
            YouTrackRepository.$$$reportNull$$$0(0);
        }
        return (element = this.fetchRequestAsElement(id)).getName().equals("issue") ? this.createIssue(element) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Element fetchRequestAsElement(@NotNull String id) throws Exception {
        if (id == null) {
            YouTrackRepository.$$$reportNull$$$0(1);
        }
        HttpMethod method = this.doREST("/rest/issue/byid/" + id, false);
        InputStream stream = method.getResponseBodyAsStream();
        Element element = new SAXBuilder(false).build(stream).getRootElement();
        Element element2 = element;
        if (element2 == null) {
            YouTrackRepository.$$$reportNull$$$0(2);
        }
        return element2;
        finally {
            method.releaseConnection();
        }
    }

    HttpMethod doREST(String request, boolean post) throws Exception {
        HttpClient client = this.login(new PostMethod(this.getUrl() + "/rest/user/login"));
        String uri = this.getUrl() + request;
        PostMethod method = post ? new PostMethod(uri) : new GetMethod(uri);
        this.configureHttpMethod((HttpMethod)method);
        int status = client.executeMethod((HttpMethod)method);
        if (status == 400) {
            InputStream string = method.getResponseBodyAsStream();
            Element element = new SAXBuilder(false).build(string).getRootElement();
            TaskUtil.prettyFormatXmlToLog((Logger)LOG, (Element)element);
            if ("error".equals(element.getName())) {
                throw new Exception(element.getText());
            }
        }
        return method;
    }

    public void setTaskState(@NotNull Task task, @NotNull CustomTaskState state) throws Exception {
        if (task == null) {
            YouTrackRepository.$$$reportNull$$$0(3);
        }
        if (state == null) {
            YouTrackRepository.$$$reportNull$$$0(4);
        }
        this.doREST("/rest/issue/execute/" + task.getId() + "?command=" + YouTrackRepository.encodeUrl((String)("state " + state.getId())), true).releaseConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<CustomTaskState> getAvailableTaskStates(@NotNull Task task) throws Exception {
        if (task == null) {
            YouTrackRepository.$$$reportNull$$$0(5);
        }
        HttpMethod method = this.doREST("/rest/issue/" + task.getId() + "/execute/intellisense?command=" + YouTrackRepository.encodeUrl((String)"state: "), false);
        InputStream stream = method.getResponseBodyAsStream();
        Element element = new SAXBuilder(false).build(stream).getRootElement();
        Set set = ContainerUtil.map2Set((Collection)element.getChild("suggest").getChildren("item"), element1 -> {
            String stateName = element1.getChildText("option");
            return new CustomTaskState(stateName, stateName);
        });
        Set set2 = set;
        if (set2 == null) {
            YouTrackRepository.$$$reportNull$$$0(6);
        }
        return set2;
        finally {
            method.releaseConnection();
        }
    }

    @Nullable
    private Task createIssue(Element element) {
        final String id = element.getAttributeValue("id");
        if (id == null) {
            return null;
        }
        final String summary = element.getAttributeValue("summary");
        if (summary == null) {
            return null;
        }
        final String description = element.getAttributeValue("description");
        String type = element.getAttributeValue("type");
        TaskType taskType = TaskType.OTHER;
        if (type != null) {
            try {
                taskType = TaskType.valueOf((String)StringUtil.toUpperCase((String)type));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        final TaskType finalTaskType = taskType;
        final Date updated = new Date(Long.parseLong(element.getAttributeValue("updated")));
        final Date created = new Date(Long.parseLong(element.getAttributeValue("created")));
        final boolean resolved = element.getAttribute("resolved") != null;
        return new Task(){

            public boolean isIssue() {
                return true;
            }

            public String getIssueUrl() {
                return YouTrackRepository.this.getUrl() + "/issue/" + this.getId();
            }

            @NotNull
            public String getId() {
                String string = id;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = summary;
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public String getDescription() {
                return description;
            }

            public Comment @NotNull [] getComments() {
                if (Comment.EMPTY_ARRAY == null) {
                    2.$$$reportNull$$$0(2);
                }
                return Comment.EMPTY_ARRAY;
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = LocalTaskImpl.getIconFromType((TaskType)this.getType(), (boolean)this.isIssue());
                if (icon == null) {
                    2.$$$reportNull$$$0(3);
                }
                return icon;
            }

            @NotNull
            public TaskType getType() {
                TaskType taskType = finalTaskType;
                if (taskType == null) {
                    2.$$$reportNull$$$0(4);
                }
                return taskType;
            }

            @Nullable
            public Date getUpdated() {
                return updated;
            }

            @Nullable
            public Date getCreated() {
                return created;
            }

            public boolean isClosed() {
                return resolved;
            }

            public TaskRepository getRepository() {
                return YouTrackRepository.this;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/tasks/youtrack/YouTrackRepository$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSummary";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComments";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public String getDefaultSearch() {
        return this.myDefaultSearch;
    }

    public void setDefaultSearch(String defaultSearch) {
        if (defaultSearch != null) {
            this.myDefaultSearch = defaultSearch;
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        YouTrackRepository repository = (YouTrackRepository)((Object)o);
        return Objects.equals(repository.getDefaultSearch(), this.getDefaultSearch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimeSpent(@NotNull LocalTask task, @NotNull String timeSpent, @NotNull String comment) throws Exception {
        if (task == null) {
            YouTrackRepository.$$$reportNull$$$0(7);
        }
        if (timeSpent == null) {
            YouTrackRepository.$$$reportNull$$$0(8);
        }
        if (comment == null) {
            YouTrackRepository.$$$reportNull$$$0(9);
        }
        this.checkVersion();
        String command = YouTrackRepository.encodeUrl((String)String.format("work Today %s %s", timeSpent, comment));
        HttpMethod method = this.doREST("/rest/issue/execute/" + task.getId() + "?command=" + command, true);
        try {
            if (method.getStatusCode() != 200) {
                InputStream stream = method.getResponseBodyAsStream();
                String message = new SAXBuilder(false).build(stream).getRootElement().getText();
                throw new Exception(message);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVersion() throws Exception {
        HttpMethod method = this.doREST("/rest/workflow/version", false);
        try {
            boolean timeTrackingAvailable;
            InputStream stream = method.getResponseBodyAsStream();
            Element element = new SAXBuilder(false).build(stream).getRootElement();
            boolean bl = timeTrackingAvailable = element.getName().equals("version") && VersionComparatorUtil.compare((String)element.getChildText("version"), (String)"4.1") >= 0;
            if (!timeTrackingAvailable) {
                throw new Exception("Time tracking is not supported in this version of Youtrack");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    protected int getFeatures() {
        return super.getFeatures() | 4 | 8;
    }

    public HttpClient getHttpClient() {
        return super.getHttpClient();
    }

    @NotNull
    protected String getDefaultScheme() {
        return "https";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/youtrack/YouTrackRepository";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeSpent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/youtrack/YouTrackRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchRequestAsElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTaskStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fetchRequestAsElement";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTaskState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableTaskStates";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateTimeSpent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

