/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

public class SortedListModel<T>
extends AbstractListModel<T> {
    private List<T> myItems = new ArrayList<T>();
    private final Comparator<? super T> myComparator;

    public SortedListModel(Comparator<? super T> comparator) {
        this.myComparator = comparator;
    }

    public SortedListModel(Collection<? extends T> items, Comparator<? super T> comparator) {
        this(comparator);
        this.addAll(items);
    }

    public static <T> SortedListModel<T> create(Comparator<? super T> comparator) {
        return new SortedListModel<T>(comparator);
    }

    public int add(T item) {
        int index = this.myComparator != null ? Collections.binarySearch(this.myItems, item, this.myComparator) : this.myItems.size();
        index = index >= 0 ? index : -(index + 1);
        this.add(index, item);
        return index;
    }

    public int[] addAll(T[] items) {
        return this.addAll(Arrays.asList(items));
    }

    public int[] addAll(Iterator<? extends T> iterator) {
        return this.addAll(ContainerUtil.collect(iterator));
    }

    public int[] addAll(Collection<? extends T> items) {
        int[] indices = new int[items.size()];
        int i = 0;
        for (T item : items) {
            int newIndex = this.add(item);
            for (int j = 0; j < i; ++j) {
                if (indices[j] < newIndex) continue;
                int n = j;
                indices[n] = indices[n] + 1;
            }
            indices[i] = newIndex;
            ++i;
        }
        return indices;
    }

    public void remove(int index) {
        this.myItems.remove(index);
        this.fireRemoved(index);
    }

    private void fireRemoved(int index) {
        this.fireIntervalRemoved(this, index, index);
    }

    public void remove(T item) {
        int index = this.indexOf(item);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public int indexOf(T item) {
        int index = Collections.binarySearch(this.myItems, item, this.myComparator);
        return index >= 0 ? index : -1;
    }

    private void add(int index, T item) {
        this.myItems.add(index, item);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public int getSize() {
        return this.myItems.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.myItems.get(index);
    }

    public void setAll(Collection<? extends T> items) {
        int newSize;
        this.clear();
        this.myItems.addAll(items);
        if (this.myComparator != null) {
            this.myItems.sort(this.myComparator);
        }
        if ((newSize = this.getSize()) > 0) {
            this.fireIntervalAdded(this, 0, newSize - 1);
        }
    }

    public void clear() {
        int oldSize = this.getSize();
        this.myItems = new ArrayList<T>();
        if (oldSize > 0) {
            this.fireIntervalRemoved(this, 0, oldSize - 1);
        }
    }

    public List<T> getItems() {
        return this.myItems;
    }

    public T get(int index) {
        return this.myItems.get(index);
    }

    public void setAll(T[] items) {
        this.setAll(Arrays.asList(items));
    }

    public Iterator<T> iterator() {
        return new MyIterator();
    }

    private class MyIterator
    implements Iterator<T> {
        private final Iterator<T> myIterator;
        private int myCounter = -1;

        MyIterator() {
            this.myIterator = SortedListModel.this.myItems.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.myIterator.hasNext();
        }

        @Override
        public T next() {
            ++this.myCounter;
            return this.myIterator.next();
        }

        @Override
        public void remove() {
            this.myIterator.remove();
            SortedListModel.this.fireRemoved(this.myCounter);
            --this.myCounter;
        }
    }
}

