/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyPsiPath {
    @Nullable
    public abstract PsiElement resolve(@NotNull PsiElement var1, @NotNull PyResolveContext var2);

    private static class AssignmentFinder
    extends PyRecursiveElementVisitor {
        private final String myAssignee;
        private PsiElement myResult;

        AssignmentFinder(String assignee) {
            this.myAssignee = assignee;
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            PyExpression lhs = node.getLeftHandSideExpression();
            if (lhs != null && this.myAssignee.equals(lhs.getText())) {
                this.myResult = node;
            }
        }
    }

    public static class ToAssignment
    extends PyPsiPath {
        private final PyPsiPath myParent;
        private final String myAssignee;

        public ToAssignment(PyPsiPath parent, String assignee) {
            this.myParent = parent;
            this.myAssignee = assignee;
        }

        @Override
        @Nullable
        public PsiElement resolve(@NotNull PsiElement context, @NotNull PyResolveContext resolveContext) {
            PsiElement parent;
            if (context == null) {
                ToAssignment.$$$reportNull$$$0(0);
            }
            if (resolveContext == null) {
                ToAssignment.$$$reportNull$$$0(1);
            }
            if ((parent = this.myParent.resolve(context, resolveContext)) == null || !resolveContext.getTypeEvalContext().maySwitchToAST(parent)) {
                return null;
            }
            AssignmentFinder finder = new AssignmentFinder(this.myAssignee);
            parent.accept((PsiElementVisitor)finder);
            return finder.myResult != null ? finder.myResult : parent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolveContext";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/codeInsight/PyPsiPath$ToAssignment";
            objectArray[2] = "resolve";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CallFinder
    extends PyRecursiveElementVisitor {
        private PsiElement myResult;
        private final String myCallName;
        private final String[] myArgs;

        CallFinder(String callName, String[] args2) {
            this.myCallName = callName;
            this.myArgs = args2;
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyExpression[] args2;
            String calleeName;
            if (this.myResult != null) {
                return;
            }
            super.visitPyCallExpression(node);
            PyExpression callee = node.getCallee();
            if (callee instanceof PyReferenceExpression && this.myCallName.equals(calleeName = ((PyReferenceExpression)callee).getReferencedName()) && this.myArgs.length <= (args2 = node.getArguments()).length) {
                boolean argsMatch = true;
                for (int i = 0; i < this.myArgs.length; ++i) {
                    if (args2[i] instanceof PyStringLiteralExpression && this.myArgs[i].equals(((PyStringLiteralExpression)args2[i]).getStringValue())) continue;
                    argsMatch = false;
                    break;
                }
                if (argsMatch) {
                    this.myResult = node;
                }
            }
        }
    }

    public static class ToCall
    extends PyPsiPath {
        private final PyPsiPath myParent;
        private final String myCallName;
        private final String[] myArgs;

        public ToCall(PyPsiPath parent, String callName, String ... args2) {
            this.myParent = parent;
            this.myCallName = callName;
            this.myArgs = args2;
        }

        @Override
        public PsiElement resolve(@NotNull PsiElement context, @NotNull PyResolveContext resolveContext) {
            PsiElement parent;
            if (context == null) {
                ToCall.$$$reportNull$$$0(0);
            }
            if (resolveContext == null) {
                ToCall.$$$reportNull$$$0(1);
            }
            if ((parent = this.myParent.resolve(context, resolveContext)) == null || !resolveContext.getTypeEvalContext().maySwitchToAST(parent)) {
                return null;
            }
            CallFinder finder = new CallFinder(this.myCallName, this.myArgs);
            parent.accept((PsiElementVisitor)finder);
            return finder.myResult != null ? finder.myResult : parent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolveContext";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/codeInsight/PyPsiPath$ToCall";
            objectArray[2] = "resolve";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToClassAttribute
    extends PyPsiPath {
        private final PyPsiPath myParent;
        private final String myAttributeName;

        public ToClassAttribute(PyPsiPath parent, String attributeName) {
            this.myAttributeName = attributeName;
            this.myParent = parent;
        }

        @Override
        public PsiElement resolve(@NotNull PsiElement context, @NotNull PyResolveContext resolveContext) {
            PsiElement parent;
            if (context == null) {
                ToClassAttribute.$$$reportNull$$$0(0);
            }
            if (resolveContext == null) {
                ToClassAttribute.$$$reportNull$$$0(1);
            }
            if (!((parent = this.myParent.resolve(context, resolveContext)) instanceof PyClass)) {
                return null;
            }
            return ((PyClass)parent).findClassAttribute(this.myAttributeName, true, resolveContext.getTypeEvalContext());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolveContext";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/codeInsight/PyPsiPath$ToClassAttribute";
            objectArray[2] = "resolve";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToFunctionRecursive
    extends PyPsiPath {
        private final PyPsiPath myParent;
        private final String myFunctionName;

        public ToFunctionRecursive(PyPsiPath parent, String functionName) {
            this.myParent = parent;
            this.myFunctionName = functionName;
        }

        @Override
        public PsiElement resolve(@NotNull PsiElement context, @NotNull PyResolveContext resolveContext) {
            PsiElement parent;
            if (context == null) {
                ToFunctionRecursive.$$$reportNull$$$0(0);
            }
            if (resolveContext == null) {
                ToFunctionRecursive.$$$reportNull$$$0(1);
            }
            if ((parent = this.myParent.resolve(context, resolveContext)) == null || !resolveContext.getTypeEvalContext().maySwitchToAST(parent)) {
                return null;
            }
            FunctionFinder finder = new FunctionFinder(this.myFunctionName);
            parent.acceptChildren((PsiElementVisitor)finder);
            return finder.myResult != null ? finder.myResult : parent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolveContext";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/codeInsight/PyPsiPath$ToFunctionRecursive";
            objectArray[2] = "resolve";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FunctionFinder
    extends PyRecursiveElementVisitor {
        private final String myName;
        private PyFunction myResult;

        FunctionFinder(String name) {
            this.myName = name;
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            super.visitPyFunction(node);
            if (this.myName.equals(node.getName())) {
                this.myResult = node;
            }
        }
    }

    public static class ToFunction
    extends PyPsiPath {
        private final PyPsiPath myParent;
        private final String myFunctionName;

        public ToFunction(PyPsiPath parent, String functionName) {
            this.myParent = parent;
            this.myFunctionName = functionName;
        }

        @Override
        public PsiElement resolve(@NotNull PsiElement context, @NotNull PyResolveContext resolveContext) {
            PsiElement parent;
            if (context == null) {
                ToFunction.$$$reportNull$$$0(0);
            }
            if (resolveContext == null) {
                ToFunction.$$$reportNull$$$0(1);
            }
            if ((parent = this.myParent.resolve(context, resolveContext)) == null) {
                return null;
            }
            if (parent instanceof PyFile) {
                return ((PyFile)parent).findTopLevelFunction(this.myFunctionName);
            }
            if (parent instanceof PyClass) {
                return ((PyClass)parent).findMethodByName(this.myFunctionName, false, resolveContext.getTypeEvalContext());
            }
            if (resolveContext.getTypeEvalContext().maySwitchToAST(parent)) {
                for (PsiElement element : parent.getChildren()) {
                    if (!(element instanceof PyFunction) || !this.myFunctionName.equals(((PyFunction)element).getName())) continue;
                    return element;
                }
            }
            return parent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolveContext";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/codeInsight/PyPsiPath$ToFunction";
            objectArray[2] = "resolve";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClassFinder
    extends PyRecursiveElementVisitor {
        private final String myName;
        private PyClass myResult;

        ClassFinder(String name) {
            this.myName = name;
        }

        @Override
        public void visitPyClass(PyClass node) {
            super.visitPyClass(node);
            if (this.myName.equals(node.getName())) {
                this.myResult = node;
            }
        }
    }

    public static class ToClass
    extends PyPsiPath {
        private final PyPsiPath myParent;
        private final String myClassName;

        public ToClass(PyPsiPath parent, String className) {
            this.myParent = parent;
            this.myClassName = className;
        }

        @Override
        public PsiElement resolve(@NotNull PsiElement context, @NotNull PyResolveContext resolveContext) {
            PsiElement parent;
            if (context == null) {
                ToClass.$$$reportNull$$$0(0);
            }
            if (resolveContext == null) {
                ToClass.$$$reportNull$$$0(1);
            }
            if ((parent = this.myParent.resolve(context, resolveContext)) == null) {
                return null;
            }
            if (parent instanceof PyFile) {
                return ((PyFile)parent).findTopLevelClass(this.myClassName);
            }
            if (resolveContext.getTypeEvalContext().maySwitchToAST(parent)) {
                if (parent instanceof PyClass) {
                    for (PsiElement element : parent.getChildren()) {
                        if (!(element instanceof PyClass) || !this.myClassName.equals(((PyClass)element).getName())) continue;
                        return element;
                    }
                }
                ClassFinder finder = new ClassFinder(this.myClassName);
                parent.acceptChildren((PsiElementVisitor)finder);
                return finder.myResult != null ? finder.myResult : parent;
            }
            return parent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolveContext";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/codeInsight/PyPsiPath$ToClass";
            objectArray[2] = "resolve";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToClassQName
    extends PyPsiPath {
        private final QualifiedName myQualifiedName;

        public ToClassQName(@NotNull String qualifiedName) {
            if (qualifiedName == null) {
                ToClassQName.$$$reportNull$$$0(0);
            }
            this.myQualifiedName = QualifiedName.fromDottedString((String)qualifiedName);
        }

        @Override
        @Nullable
        public PsiElement resolve(@NotNull PsiElement context, @NotNull PyResolveContext resolveContext) {
            if (context == null) {
                ToClassQName.$$$reportNull$$$0(1);
            }
            if (resolveContext == null) {
                ToClassQName.$$$reportNull$$$0(2);
            }
            return PyPsiFacade.getInstance(context.getProject()).findClass(this.myQualifiedName.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolveContext";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/codeInsight/PyPsiPath$ToClassQName";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolve";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToFile
    extends PyPsiPath {
        private final QualifiedName myQualifiedName;

        public ToFile(String qualifiedName) {
            this.myQualifiedName = QualifiedName.fromDottedString((String)qualifiedName);
        }

        @Override
        @Nullable
        public PsiElement resolve(@NotNull PsiElement context, @NotNull PyResolveContext resolveContext) {
            if (context == null) {
                ToFile.$$$reportNull$$$0(0);
            }
            if (resolveContext == null) {
                ToFile.$$$reportNull$$$0(1);
            }
            PyPsiFacade facade = PyPsiFacade.getInstance(context.getProject());
            return facade.resolveQualifiedName(this.myQualifiedName, facade.createResolveContextFromFoothold(context)).stream().findFirst().orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolveContext";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/codeInsight/PyPsiPath$ToFile";
            objectArray[2] = "resolve";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

