/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import icons.PythonIcons;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonConsoleToolWindow {
    public static final Key<RunContentDescriptor> CONTENT_DESCRIPTOR = Key.create((String)"CONTENT_DESCRIPTOR");
    public static final Function<Content, RunContentDescriptor> CONTENT_TO_DESCRIPTOR_FUNCTION = input -> input != null ? (RunContentDescriptor)input.getUserData(CONTENT_DESCRIPTOR) : null;
    private final Project myProject;
    private boolean myInitialized = false;

    public PythonConsoleToolWindow(Project project) {
        this.myProject = project;
    }

    public static PythonConsoleToolWindow getInstance(@NotNull Project project) {
        if (project == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(0);
        }
        return (PythonConsoleToolWindow)project.getService(PythonConsoleToolWindow.class);
    }

    public List<RunContentDescriptor> getConsoleContentDescriptors() {
        return FluentIterable.from((Iterable)Lists.newArrayList((Object[])PythonConsoleToolWindow.getToolWindow(this.myProject).getContentManager().getContents())).transform(CONTENT_TO_DESCRIPTOR_FUNCTION).filter(Predicates.notNull()).toList();
    }

    public void init(@NotNull ToolWindow toolWindow, @NotNull RunContentDescriptor contentDescriptor) {
        if (toolWindow == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(1);
        }
        if (contentDescriptor == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(2);
        }
        PythonConsoleToolWindow.setContent(toolWindow, contentDescriptor);
        if (!this.myInitialized) {
            this.doInit(toolWindow);
        }
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    private void doInit(final @NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(3);
        }
        this.myInitialized = true;
        toolWindow.setToHideOnEmptyContent(true);
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                ToolWindow window;
                if (toolWindowManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((window = PythonConsoleToolWindow.getToolWindow(PythonConsoleToolWindow.this.myProject)).isVisible() && toolWindow.getContentManager().getContentCount() == 0) {
                    PydevConsoleRunner runner = PythonConsoleRunnerFactory.getInstance().createConsoleRunner(PythonConsoleToolWindow.this.myProject, null);
                    runner.run(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/jetbrains/python/console/PythonConsoleToolWindow$1", "stateChanged"));
            }
        });
    }

    private static void setContent(ToolWindow toolWindow, RunContentDescriptor contentDescriptor) {
        toolWindow.getComponent().putClientProperty("HideIdLabel", "true");
        Content content2 = toolWindow.getContentManager().findContent(contentDescriptor.getDisplayName());
        if (content2 == null) {
            content2 = PythonConsoleToolWindow.createContent(contentDescriptor);
            toolWindow.getContentManager().addContent(content2);
        } else {
            SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true);
            PythonConsoleToolWindow.resetContent(contentDescriptor, panel2, content2);
        }
        toolWindow.getContentManager().setSelectedContent(content2);
    }

    public ToolWindow getToolWindow() {
        return PythonConsoleToolWindow.getToolWindow(this.myProject);
    }

    public static ToolWindow getToolWindow(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        ToolWindow consoleToolWindow = toolWindowManager.getToolWindow("Python Console");
        if (consoleToolWindow == null) {
            consoleToolWindow = toolWindowManager.registerToolWindow("Python Console", true, ToolWindowAnchor.BOTTOM);
            consoleToolWindow.setIcon(PythonIcons.Python.PythonConsoleToolWindow);
        }
        return consoleToolWindow;
    }

    public void setContent(RunContentDescriptor contentDescriptor) {
        PythonConsoleToolWindow.setContent(PythonConsoleToolWindow.getToolWindow(this.myProject), contentDescriptor);
    }

    private static Content createContent(@NotNull RunContentDescriptor contentDescriptor) {
        if (contentDescriptor == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(4);
        }
        SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true);
        Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel2, contentDescriptor.getDisplayName(), false);
        content2.setCloseable(true);
        PythonConsoleToolWindow.resetContent(contentDescriptor, panel2, content2);
        return content2;
    }

    private static void resetContent(RunContentDescriptor contentDescriptor, SimpleToolWindowPanel panel2, Content content2) {
        RunContentDescriptor oldDescriptor;
        RunContentDescriptor runContentDescriptor = oldDescriptor = content2.getDisposer() instanceof RunContentDescriptor ? (RunContentDescriptor)content2.getDisposer() : null;
        if (oldDescriptor != null) {
            Disposer.dispose((Disposable)oldDescriptor);
        }
        panel2.setContent(contentDescriptor.getComponent());
        content2.setComponent((JComponent)panel2);
        content2.setDisposer((Disposable)contentDescriptor);
        content2.setPreferredFocusableComponent(contentDescriptor.getComponent());
        content2.setPreferredFocusedComponent(contentDescriptor.getPreferredFocusComputable());
        content2.putUserData(CONTENT_DESCRIPTOR, (Object)contentDescriptor);
    }

    public void activate(@NotNull Runnable runnable) {
        if (runnable == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(5);
        }
        PythonConsoleToolWindow.getToolWindow(this.myProject).activate(runnable);
    }

    @Nullable
    public RunContentDescriptor getSelectedContentDescriptor() {
        return (RunContentDescriptor)CONTENT_TO_DESCRIPTOR_FUNCTION.apply((Object)PythonConsoleToolWindow.getToolWindow(this.myProject).getContentManager().getSelectedContent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/console/PythonConsoleToolWindow";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doInit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "activate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

