/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyReferringObjectsValue;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.ExceptionBreakpointCommandFactory;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.RemoteDebuggerCloseListener;
import com.jetbrains.python.debugger.pydev.ResumeOrStepCommand;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiProcessDebugger
implements ProcessDebugger {
    private static final Logger LOG = Logger.getInstance(MultiProcessDebugger.class);
    private final IPyDebugProcess myDebugProcess;
    private final ServerSocket myServerSocket;
    private final int myTimeoutInMillis;
    private final RemoteDebugger myMainDebugger;
    private final List<RemoteDebugger> myOtherDebuggers;
    private ServerSocket myDebugServerSocket;
    private DebuggerProcessAcceptor myDebugProcessAcceptor;
    private final List<DebuggerProcessListener> myOtherDebuggerCloseListener;
    private final ThreadRegistry myThreadRegistry;

    public MultiProcessDebugger(@NotNull IPyDebugProcess debugProcess, @NotNull ServerSocket serverSocket, int timeoutInMillis) {
        if (debugProcess == null) {
            MultiProcessDebugger.$$$reportNull$$$0(0);
        }
        if (serverSocket == null) {
            MultiProcessDebugger.$$$reportNull$$$0(1);
        }
        this.myOtherDebuggers = new ArrayList<RemoteDebugger>();
        this.myOtherDebuggerCloseListener = new ArrayList<DebuggerProcessListener>();
        this.myThreadRegistry = new ThreadRegistry();
        this.myDebugProcess = debugProcess;
        this.myServerSocket = serverSocket;
        this.myTimeoutInMillis = timeoutInMillis;
        try {
            this.myDebugServerSocket = MultiProcessDebugger.createServerSocket();
        }
        catch (ExecutionException e) {
            LOG.error("Failed to start debugger:", (Throwable)e);
        }
        this.myMainDebugger = new RemoteDebugger(this.myDebugProcess, this.myDebugServerSocket, this.myTimeoutInMillis);
    }

    @Override
    public boolean isConnected() {
        return this.myMainDebugger.isConnected();
    }

    @Override
    public void waitForConnect() throws Exception {
        Socket socket = this.myServerSocket.accept();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                MultiProcessDebugger.sendDebuggerPort(socket, this.myDebugServerSocket, this.myDebugProcess);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.myMainDebugger.waitForConnect();
        this.disposeAcceptor();
        this.myDebugProcessAcceptor = new DebuggerProcessAcceptor(this, this.myServerSocket);
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)this.myDebugProcessAcceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendDebuggerPort(@NotNull Socket socket, @NotNull ServerSocket serverSocket, @NotNull IPyDebugProcess processHandler) throws IOException {
        if (socket == null) {
            MultiProcessDebugger.$$$reportNull$$$0(2);
        }
        if (serverSocket == null) {
            MultiProcessDebugger.$$$reportNull$$$0(3);
        }
        if (processHandler == null) {
            MultiProcessDebugger.$$$reportNull$$$0(4);
        }
        int port = processHandler.handleDebugPort(serverSocket.getLocalPort());
        PrintWriter writer = new PrintWriter(socket.getOutputStream());
        try {
            writer.println("99\t-1\t" + port);
            writer.flush();
        }
        finally {
            socket.close();
            writer.close();
        }
    }

    @NotNull
    private static ServerSocket createServerSocket() throws ExecutionException {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to find free socket port", (Throwable)e);
        }
        ServerSocket serverSocket2 = serverSocket;
        if (serverSocket2 == null) {
            MultiProcessDebugger.$$$reportNull$$$0(5);
        }
        return serverSocket2;
    }

    @Override
    public void close() {
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.close();
        }
        this.disposeAcceptor();
        if (!this.myServerSocket.isClosed()) {
            try {
                this.myServerSocket.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing socket", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RemoteDebugger> allDebuggers() {
        ArrayList result = Lists.newArrayList((Object[])new RemoteDebugger[]{this.myMainDebugger});
        List<RemoteDebugger> list = this.myOtherDebuggers;
        synchronized (list) {
            result.addAll(this.myOtherDebuggers);
        }
        return result;
    }

    @Override
    public void disconnect() {
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.disconnect();
        }
        this.disposeAcceptor();
    }

    private void disposeAcceptor() {
        if (this.myDebugProcessAcceptor != null) {
            this.myDebugProcessAcceptor.disconnect();
            this.myDebugProcessAcceptor = null;
        }
    }

    @Override
    public String handshake() throws PyDebuggerException {
        return this.myMainDebugger.handshake();
    }

    @Override
    public PyDebugValue evaluate(String threadId, String frameId, String expression, boolean execute2) throws PyDebuggerException {
        return this.debugger(threadId).evaluate(threadId, frameId, expression, execute2);
    }

    @Override
    public PyDebugValue evaluate(String threadId, String frameId, String expression, boolean execute2, boolean trimResult) throws PyDebuggerException {
        return this.debugger(threadId).evaluate(threadId, frameId, expression, execute2, trimResult);
    }

    @Override
    public void consoleExec(String threadId, String frameId, String expression, PyDebugCallback<String> callback) {
        this.debugger(threadId).consoleExec(threadId, frameId, expression, callback);
    }

    @Override
    public XValueChildrenList loadFrame(String threadId, String frameId) throws PyDebuggerException {
        return this.debugger(threadId).loadFrame(threadId, frameId);
    }

    @Override
    public List<Pair<String, Boolean>> getSmartStepIntoVariants(String threadId, String frameId, int startContextLine, int endContextLine) throws PyDebuggerException {
        return this.debugger(threadId).getSmartStepIntoVariants(threadId, frameId, startContextLine, endContextLine);
    }

    @Override
    public XValueChildrenList loadVariable(String threadId, String frameId, PyDebugValue var) throws PyDebuggerException {
        return this.debugger(threadId).loadVariable(threadId, frameId, var);
    }

    @Override
    public ArrayChunk loadArrayItems(String threadId, String frameId, PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        return this.debugger(threadId).loadArrayItems(threadId, frameId, var, rowOffset, colOffset, rows, cols, format);
    }

    @Override
    public void loadReferrers(String threadId, String frameId, PyReferringObjectsValue var, PyDebugCallback<XValueChildrenList> callback) {
        this.debugger(threadId).loadReferrers(threadId, frameId, var, callback);
    }

    @NotNull
    private ProcessDebugger debugger(@NotNull String threadId) {
        RemoteDebugger debugger;
        if (threadId == null) {
            MultiProcessDebugger.$$$reportNull$$$0(6);
        }
        if ((debugger = this.myThreadRegistry.getDebugger(threadId)) != null) {
            RemoteDebugger remoteDebugger = debugger;
            if (remoteDebugger == null) {
                MultiProcessDebugger.$$$reportNull$$$0(7);
            }
            return remoteDebugger;
        }
        for (ProcessDebugger processDebugger : this.myOtherDebuggers) {
            for (PyThreadInfo thread : processDebugger.getThreads()) {
                if (!threadId.equals(thread.getId())) continue;
                ProcessDebugger processDebugger2 = processDebugger;
                if (processDebugger2 == null) {
                    MultiProcessDebugger.$$$reportNull$$$0(8);
                }
                return processDebugger2;
            }
        }
        RemoteDebugger remoteDebugger = this.myMainDebugger;
        if (remoteDebugger == null) {
            MultiProcessDebugger.$$$reportNull$$$0(9);
        }
        return remoteDebugger;
    }

    @Override
    public PyDebugValue changeVariable(String threadId, String frameId, PyDebugValue var, String value) throws PyDebuggerException {
        return this.debugger(threadId).changeVariable(threadId, frameId, var, value);
    }

    @Override
    public void loadFullVariableValues(@NotNull String threadId, @NotNull String frameId, @NotNull List<PyFrameAccessor.PyAsyncValue<String>> vars) throws PyDebuggerException {
        if (threadId == null) {
            MultiProcessDebugger.$$$reportNull$$$0(10);
        }
        if (frameId == null) {
            MultiProcessDebugger.$$$reportNull$$$0(11);
        }
        if (vars == null) {
            MultiProcessDebugger.$$$reportNull$$$0(12);
        }
        this.debugger(threadId).loadFullVariableValues(threadId, frameId, vars);
    }

    @Override
    public String loadSource(String path) {
        return this.myMainDebugger.loadSource(path);
    }

    @Override
    public Collection<PyThreadInfo> getThreads() {
        this.cleanOtherDebuggers();
        List<PyThreadInfo> threads = this.collectAllThreads();
        if (this.myOtherDebuggers.size() > 0) {
            return Collections.unmodifiableCollection(Collections2.transform(threads, t -> {
                if (t == null) {
                    return null;
                }
                String threadName = ThreadRegistry.threadName(t.getName(), t.getId());
                PyThreadInfo newThread = new PyThreadInfo(t.getId(), threadName, t.getFrames(), t.getStopReason(), t.getMessage());
                newThread.updateState(t.getState(), t.getFrames());
                return newThread;
            }));
        }
        return Collections.unmodifiableCollection(threads);
    }

    private List<PyThreadInfo> collectAllThreads() {
        ArrayList<PyThreadInfo> result = new ArrayList<PyThreadInfo>();
        result.addAll(this.myMainDebugger.getThreads());
        for (RemoteDebugger d : this.myOtherDebuggers) {
            result.addAll(d.getThreads());
            for (PyThreadInfo t : d.getThreads()) {
                this.myThreadRegistry.register(t.getId(), d);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOtherDebuggers() {
        List<RemoteDebugger> list = this.myOtherDebuggers;
        synchronized (list) {
            this.removeDisconnected(this.getOtherDebuggers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDisconnected(ArrayList<RemoteDebugger> debuggers) {
        boolean allConnected = true;
        for (RemoteDebugger d : debuggers) {
            if (d.isConnected()) continue;
            allConnected = false;
        }
        if (!allConnected) {
            ArrayList<RemoteDebugger> newList = new ArrayList<RemoteDebugger>();
            for (RemoteDebugger d : debuggers) {
                if (!d.isConnected()) continue;
                newList.add(d);
            }
            List<RemoteDebugger> list = this.myOtherDebuggers;
            synchronized (list) {
                this.myOtherDebuggers.clear();
                this.myOtherDebuggers.addAll(newList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<RemoteDebugger> getOtherDebuggers() {
        List<RemoteDebugger> list = this.myOtherDebuggers;
        synchronized (list) {
            return Lists.newArrayList(this.myOtherDebuggers);
        }
    }

    @Override
    public void execute(@NotNull AbstractCommand command) {
        if (command == null) {
            MultiProcessDebugger.$$$reportNull$$$0(13);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.execute(command);
        }
    }

    @Override
    public void suspendAllThreads() {
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.suspendAllThreads();
        }
    }

    @Override
    public void suspendThread(String threadId) {
        this.debugger(threadId).suspendThread(threadId);
    }

    @Override
    public void run() throws PyDebuggerException {
        this.myMainDebugger.run();
    }

    @Override
    public void smartStepInto(String threadId, String frameId, String functionName, int callOrder, int contextStartLine, int contextEndLine) {
        this.debugger(threadId).smartStepInto(threadId, frameId, functionName, callOrder, contextStartLine, contextEndLine);
    }

    @Override
    public void resumeOrStep(String threadId, ResumeOrStepCommand.Mode mode) {
        this.debugger(threadId).resumeOrStep(threadId, mode);
    }

    @Override
    public void setNextStatement(@NotNull String threadId, @NotNull XSourcePosition sourcePosition, @Nullable String functionName, @NotNull PyDebugCallback<Pair<Boolean, String>> callback) {
        if (threadId == null) {
            MultiProcessDebugger.$$$reportNull$$$0(14);
        }
        if (sourcePosition == null) {
            MultiProcessDebugger.$$$reportNull$$$0(15);
        }
        if (callback == null) {
            MultiProcessDebugger.$$$reportNull$$$0(16);
        }
        this.debugger(threadId).setNextStatement(threadId, sourcePosition, functionName, callback);
    }

    @Override
    public void setTempBreakpoint(@NotNull String type, @NotNull String file, int line2) {
        if (type == null) {
            MultiProcessDebugger.$$$reportNull$$$0(17);
        }
        if (file == null) {
            MultiProcessDebugger.$$$reportNull$$$0(18);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.setTempBreakpoint(type, file, line2);
        }
    }

    @Override
    public void removeTempBreakpoint(@NotNull String file, int line2) {
        if (file == null) {
            MultiProcessDebugger.$$$reportNull$$$0(19);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.removeTempBreakpoint(file, line2);
        }
    }

    @Override
    public void setBreakpoint(@NotNull String typeId, @NotNull String file, int line2, @Nullable String condition, @Nullable String logExpression, @Nullable String funcName, @NotNull SuspendPolicy policy) {
        if (typeId == null) {
            MultiProcessDebugger.$$$reportNull$$$0(20);
        }
        if (file == null) {
            MultiProcessDebugger.$$$reportNull$$$0(21);
        }
        if (policy == null) {
            MultiProcessDebugger.$$$reportNull$$$0(22);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.setBreakpoint(typeId, file, line2, condition, logExpression, funcName, policy);
        }
    }

    @Override
    public void removeBreakpoint(@NotNull String typeId, @NotNull String file, int line2) {
        if (typeId == null) {
            MultiProcessDebugger.$$$reportNull$$$0(23);
        }
        if (file == null) {
            MultiProcessDebugger.$$$reportNull$$$0(24);
        }
        this.allDebuggers().forEach(d -> d.removeBreakpoint(typeId, file, line2));
    }

    @Override
    public void setShowReturnValues(boolean isShowReturnValues) {
        this.allDebuggers().forEach(d -> d.setShowReturnValues(isShowReturnValues));
    }

    @Override
    public void setUnitTestDebuggingMode() {
        this.allDebuggers().forEach(d -> d.setUnitTestDebuggingMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDebugger(RemoteDebugger debugger) {
        List<RemoteDebugger> list = this.myOtherDebuggers;
        synchronized (list) {
            this.myOtherDebuggers.add(debugger);
        }
    }

    @Override
    public void addCloseListener(RemoteDebuggerCloseListener listener2) {
        this.myMainDebugger.addCloseListener(listener2);
    }

    @Override
    public List<PydevCompletionVariant> getCompletions(String threadId, String frameId, String prefix) {
        return this.debugger(threadId).getCompletions(threadId, frameId, prefix);
    }

    @Override
    public String getDescription(String threadId, String frameId, String cmd) {
        return this.debugger(threadId).getDescription(threadId, frameId, cmd);
    }

    @Override
    public void addExceptionBreakpoint(ExceptionBreakpointCommandFactory factory) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.execute(factory.createAddCommand(d));
        }
    }

    @Override
    public void removeExceptionBreakpoint(ExceptionBreakpointCommandFactory factory) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.execute(factory.createRemoveCommand(d));
        }
    }

    @Override
    public void suspendOtherThreads(PyThreadInfo thread) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.suspendOtherThreads(thread);
        }
    }

    public void removeCloseListener(RemoteDebuggerCloseListener listener2) {
        this.myMainDebugger.removeCloseListener(listener2);
    }

    public void addOtherDebuggerCloseListener(DebuggerProcessListener otherDebuggerCloseListener) {
        this.myOtherDebuggerCloseListener.add(otherDebuggerCloseListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverSocket";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/pydev/MultiProcessDebugger";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/pydev/MultiProcessDebugger";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createServerSocket";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "debugger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sendDebuggerPort";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "debugger";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadFullVariableValues";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setNextStatement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setTempBreakpoint";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeTempBreakpoint";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setBreakpoint";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DebuggerProcessListener {
        public void threadsClosed(Set<String> var1);
    }

    private static class DebuggerProcessAcceptor
    implements Runnable {
        private volatile boolean myShouldAccept;
        private final MultiProcessDebugger myMultiProcessDebugger;
        private ServerSocket myServerSocket;

        DebuggerProcessAcceptor(@NotNull MultiProcessDebugger multiProcessDebugger, @NotNull ServerSocket serverSocket) {
            if (multiProcessDebugger == null) {
                DebuggerProcessAcceptor.$$$reportNull$$$0(0);
            }
            if (serverSocket == null) {
                DebuggerProcessAcceptor.$$$reportNull$$$0(1);
            }
            this.myShouldAccept = true;
            this.myMultiProcessDebugger = multiProcessDebugger;
            this.myServerSocket = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.myShouldAccept) {
                try {
                    ServerSocket serverSocketCopy = this.myServerSocket;
                    if (serverSocketCopy == null) break;
                    Socket socket = serverSocketCopy.accept();
                    try {
                        ServerSocket serverSocket = MultiProcessDebugger.createServerSocket();
                        RemoteDebugger debugger = new RemoteDebugger(this.myMultiProcessDebugger.myDebugProcess, serverSocket, this.myMultiProcessDebugger.myTimeoutInMillis);
                        this.addCloseListener(debugger);
                        MultiProcessDebugger.sendDebuggerPort(socket, serverSocket, this.myMultiProcessDebugger.myDebugProcess);
                        socket.close();
                        debugger.waitForConnect();
                        debugger.handshake();
                        this.myMultiProcessDebugger.addDebugger(debugger);
                        this.myMultiProcessDebugger.myDebugProcess.init();
                        debugger.run();
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                    finally {
                        if (socket.isClosed()) continue;
                        socket.close();
                    }
                }
                catch (Exception ignore) {
                    if (this.myServerSocket != null) continue;
                    this.myShouldAccept = false;
                }
            }
        }

        private void addCloseListener(final @NotNull RemoteDebugger debugger) {
            if (debugger == null) {
                DebuggerProcessAcceptor.$$$reportNull$$$0(2);
            }
            debugger.addCloseListener(new RemoteDebuggerCloseListener(){

                @Override
                public void closed() {
                    this.notifyThreadsClosed(debugger);
                }

                @Override
                public void communicationError() {
                    this.notifyThreadsClosed(debugger);
                }

                @Override
                public void detached() {
                    this.notifyThreadsClosed(debugger);
                }
            });
        }

        private void notifyThreadsClosed(RemoteDebugger debugger) {
            for (DebuggerProcessListener l : this.myMultiProcessDebugger.myOtherDebuggerCloseListener) {
                l.threadsClosed(this.collectThreads(debugger));
            }
        }

        private Set<String> collectThreads(RemoteDebugger debugger) {
            HashSet<String> result = new HashSet<String>();
            for (Map.Entry entry : this.myMultiProcessDebugger.myThreadRegistry.myThreadIdToDebugger.entrySet()) {
                if (entry.getValue() != debugger) continue;
                result.add((String)entry.getKey());
            }
            return result;
        }

        public void disconnect() {
            this.myShouldAccept = false;
            if (this.myServerSocket != null && !this.myServerSocket.isClosed()) {
                try {
                    this.myServerSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.myServerSocket = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "multiProcessDebugger";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverSocket";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugger";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/debugger/pydev/MultiProcessDebugger$DebuggerProcessAcceptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCloseListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ThreadRegistry {
        private final Map<String, RemoteDebugger> myThreadIdToDebugger = Maps.newHashMap();

        private ThreadRegistry() {
        }

        public void register(String id, RemoteDebugger debugger) {
            this.myThreadIdToDebugger.put(id, debugger);
        }

        public RemoteDebugger getDebugger(String threadId) {
            return this.myThreadIdToDebugger.get(threadId);
        }

        public static String threadName(@NotNull String name, @NotNull String id) {
            int indx;
            if (name == null) {
                ThreadRegistry.$$$reportNull$$$0(0);
            }
            if (id == null) {
                ThreadRegistry.$$$reportNull$$$0(1);
            }
            if ((indx = id.indexOf("_", id.indexOf("_") + 1)) != -1) {
                id = id.substring(0, indx);
            }
            return name + "(" + id + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/debugger/pydev/MultiProcessDebugger$ThreadRegistry";
            objectArray[2] = "threadName";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

