/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.serialization.Binding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.WriteContext;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003H\u00c2\u0003\u00a2\u0006\u0002\u0010\bJ\"\u0010\t\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J \u0010\u000b\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J \u0010\u0019\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u001aH\u0016J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u001aH\u0016J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u001a\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lcom/intellij/serialization/InterfacePropertyBinding;", "Lcom/intellij/serialization/Binding;", "allowedTypes", "", "Ljava/lang/Class;", "([Ljava/lang/Class;)V", "[Ljava/lang/Class;", "component1", "()[Ljava/lang/Class;", "copy", "([Ljava/lang/Class;)Lcom/intellij/serialization/InterfacePropertyBinding;", "deserialize", "", "context", "Lcom/intellij/serialization/ReadContext;", "hostObject", "", "", "property", "Lcom/intellij/serialization/MutableAccessor;", "equals", "", "other", "hashCode", "", "serialize", "Lcom/intellij/serialization/WriteContext;", "obj", "toString", "", "intellij.platform.objectSerializer"})
public final class InterfacePropertyBinding
implements Binding {
    private final Class<?>[] allowedTypes;

    @NotNull
    public Void serialize(@NotNull Object obj2, @NotNull WriteContext context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        throw (Throwable)new IllegalStateException("InterfacePropertyBinding cannot be used as root binding");
    }

    @Override
    @NotNull
    public Void deserialize(@NotNull ReadContext context, @Nullable Object hostObject) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        throw (Throwable)new IllegalStateException("InterfacePropertyBinding cannot be used as root binding");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull WriteContext context) {
        Intrinsics.checkParameterIsNotNull((Object)hostObject, (String)"hostObject");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean $i$f$write = false;
        Object value$iv = property.readUnsafe(hostObject);
        if (!context.getFilter().isSkipped(value$iv)) {
            IonWriter writer$iv = context.getWriter();
            writer$iv.setFieldName(property.getName());
            if (value$iv == null) {
                writer$iv.writeNull();
            } else {
                void value;
                Object object = value$iv;
                IonWriter $this$write = writer$iv;
                boolean bl = false;
                Class<?> valueClass = value.getClass();
                if (!ArraysKt.contains((Object[])this.allowedTypes, valueClass)) {
                    throw (Throwable)new SerializationException("Type " + valueClass + " is not allowed for field " + property.getName());
                }
                $this$write.addTypeAnnotation(valueClass.getSimpleName());
                context.getBindingProducer().getRootBinding(valueClass).serialize(value, context);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void deserialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull ReadContext context) {
        Intrinsics.checkParameterIsNotNull((Object)hostObject, (String)"hostObject");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean $i$f$read = false;
        if (context.getReader().getType() == IonType.NULL) {
            property.set(hostObject, null);
        } else {
            Class<?> clazz;
            void $this$read;
            IonReader ionReader = context.getReader();
            Object object = hostObject;
            MutableAccessor mutableAccessor = property;
            boolean bl = false;
            Class<?> beanClass = null;
            Iterator typeAnnotationIterator = $this$read.iterateTypeAnnotations();
            if (typeAnnotationIterator.hasNext()) {
                String simpleName;
                block6: {
                    simpleName = (String)typeAnnotationIterator.next();
                    Class<?>[] $this$firstOrNull$iv = this.allowedTypes;
                    boolean $i$f$firstOrNull = false;
                    Class<?>[] classArray = $this$firstOrNull$iv;
                    int n = classArray.length;
                    for (int i = 0; i < n; ++i) {
                        Class<?> element$iv;
                        Class<?> it = element$iv = classArray[i];
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getSimpleName(), (Object)simpleName)) continue;
                        clazz = element$iv;
                        break block6;
                    }
                    clazz = null;
                }
                if (clazz == null) {
                    throw (Throwable)new SerializationException("Unknown class simple name: " + simpleName + " (allowedClasses=" + this.allowedTypes + ')');
                }
            } else {
                throw (Throwable)new SerializationException("Class simple name is not specified (allowedClasses=" + this.allowedTypes + ')');
            }
            beanClass = clazz;
            Object object2 = context.getBindingProducer().getRootBinding(beanClass).deserialize(context, hostObject);
            mutableAccessor.set(object, object2);
        }
    }

    public InterfacePropertyBinding(@NotNull Class<?>[] allowedTypes) {
        Intrinsics.checkParameterIsNotNull(allowedTypes, (String)"allowedTypes");
        this.allowedTypes = allowedTypes;
    }

    @Override
    @NotNull
    public Type createCacheKey(@Nullable Class<?> aClass, @NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return Binding.DefaultImpls.createCacheKey(this, aClass, type);
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull BindingInitializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)originalType, (String)"originalType");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Binding.DefaultImpls.init(this, originalType, context);
    }

    private final Class<?>[] component1() {
        return this.allowedTypes;
    }

    @NotNull
    public final InterfacePropertyBinding copy(@NotNull Class<?>[] allowedTypes) {
        Intrinsics.checkParameterIsNotNull(allowedTypes, (String)"allowedTypes");
        return new InterfacePropertyBinding(allowedTypes);
    }

    public static /* synthetic */ InterfacePropertyBinding copy$default(InterfacePropertyBinding interfacePropertyBinding, Class[] classArray, int n, Object object) {
        if ((n & 1) != 0) {
            classArray = interfacePropertyBinding.allowedTypes;
        }
        return interfacePropertyBinding.copy(classArray);
    }

    @NotNull
    public String toString() {
        return "InterfacePropertyBinding(allowedTypes=" + Arrays.toString(this.allowedTypes) + ")";
    }

    public int hashCode() {
        return this.allowedTypes != null ? Arrays.hashCode(this.allowedTypes) : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof InterfacePropertyBinding)) break block3;
                InterfacePropertyBinding interfacePropertyBinding = (InterfacePropertyBinding)object;
                if (!Intrinsics.areEqual(this.allowedTypes, interfacePropertyBinding.allowedTypes)) break block3;
            }
            return true;
        }
        return false;
    }
}

