/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.google.common.collect.Sets;
import java.lang.invoke.MethodHandles;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.RoutedAliasTypes;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.api.collections.CategoryRoutedAlias;
import org.apache.solr.cloud.api.collections.DimensionalRoutedAlias;
import org.apache.solr.cloud.api.collections.MaintainRoutedAliasCmd;
import org.apache.solr.cloud.api.collections.TimeRoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.AddUpdateCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RoutedAlias {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ROUTER_TYPE_NAME = "router.name";
    public static final String ROUTER_FIELD = "router.field";
    public static final String CREATE_COLLECTION_PREFIX = "create-collection.";
    public static final Set<String> MINIMAL_REQUIRED_PARAMS = Sets.newHashSet((Object[])new String[]{"router.name", "router.field"});
    public static final String ROUTED_ALIAS_NAME_CORE_PROP = "routedAliasName";
    private static final String DIMENSIONAL = "Dimensional[";
    boolean preemptiveCreateOnceAlready = false;

    public static SolrException newAliasMustExistException(String aliasName) {
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Routed alias " + aliasName + " appears to have been removed during request processing.");
    }

    public static RoutedAlias fromProps(String aliasName, Map<String, String> props) throws SolrException {
        int i;
        String typeStr = props.get(ROUTER_TYPE_NAME);
        if (typeStr == null) {
            return null;
        }
        ArrayList<RoutedAliasTypes> routerTypes = new ArrayList<RoutedAliasTypes>();
        if (typeStr.startsWith(DIMENSIONAL)) {
            typeStr = typeStr.substring(DIMENSIONAL.length(), typeStr.length() - 1);
            String[] types = typeStr.split(",");
            ArrayList<String> fields = new ArrayList<String>();
            if (types.length > 2) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "More than 2 dimensions is not supported yet. Please monitor SOLR-13628 for progress");
            }
            for (i = 0; i < types.length; ++i) {
                String typeName;
                String type = types[i];
                RoutedAlias.addRouterTypeOf(type, routerTypes);
                if (props.containsKey("router.routerList")) {
                    HashMap<String, String> tmp = new HashMap<String, String>(props);
                    List v2RouterList = (List)((Object)tmp.get("router.routerList"));
                    Map o = (Map)v2RouterList.get(i);
                    for (Map.Entry entry : o.entrySet()) {
                        props.put("router." + i + "." + (String)entry.getKey(), String.valueOf(entry.getValue()));
                    }
                }
                if (!props.containsKey(typeName = "router." + i + ".name")) {
                    props.put(typeName, type);
                }
                fields.add(props.get("router." + i + ".field"));
            }
            if (props.containsKey("router.routerList")) {
                props.remove("router.routerList");
            }
            if (!props.containsKey(ROUTER_FIELD)) {
                props.put(ROUTER_FIELD, String.join((CharSequence)",", fields));
            }
        } else {
            RoutedAlias.addRouterTypeOf(typeStr, routerTypes);
        }
        if (routerTypes.size() == 1) {
            RoutedAliasTypes routerType = (RoutedAliasTypes)routerTypes.get(0);
            return RoutedAlias.routedAliasForType(aliasName, props, routerType);
        }
        ArrayList<RoutedAlias> dimensions = new ArrayList<RoutedAlias>();
        DimensionalRoutedAlias[] dra = new DimensionalRoutedAlias[1];
        for (i = 0; i < routerTypes.size(); ++i) {
            RoutedAliasTypes routerType = (RoutedAliasTypes)routerTypes.get(i);
            dimensions.add(DimensionalRoutedAlias.dimensionForType(RoutedAlias.selectForIndex(i, props), routerType, i, () -> dra[0]));
        }
        dra[0] = new DimensionalRoutedAlias(dimensions, props.get("name"), props);
        return dra[0];
    }

    private static void addRouterTypeOf(String type, List<RoutedAliasTypes> routerTypes) {
        try {
            routerTypes.add(RoutedAliasTypes.valueOf((String)type.toUpperCase(Locale.ENGLISH)));
        }
        catch (IllegalArgumentException iae) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Router name: " + type + " is not in supported types, " + Arrays.asList(RoutedAliasTypes.values()));
        }
    }

    private static Map<String, String> selectForIndex(int i, Map<String, String> original) {
        return original.entrySet().stream().filter(e -> ((String)e.getKey()).matches("(((?!^router\\.).)*$|(^router\\." + i + ".*$))")).map(e -> new AbstractMap.SimpleEntry(((String)e.getKey()).replaceAll("(.*\\.)" + i + "\\.(.*)", "$1$2"), e.getValue())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private static RoutedAlias routedAliasForType(String aliasName, Map<String, String> props, RoutedAliasTypes routerType) {
        switch (routerType) {
            case TIME: {
                return new TimeRoutedAlias(aliasName, props);
            }
            case CATEGORY: {
                return new CategoryRoutedAlias(aliasName, props);
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Router " + routerType + " is not fully implemented. If you see thiserror in an official release please file a bug report. Available types were:" + Arrays.asList(RoutedAliasTypes.values()));
    }

    public abstract boolean updateParsedCollectionAliases(ZkStateReader var1, boolean var2);

    List<String> getCollectionList(Aliases aliases) {
        return (List)aliases.getCollectionAliasListMap().get(this.getAliasName());
    }

    abstract String computeInitialCollectionName();

    abstract String[] formattedRouteValues(SolrInputDocument var1);

    public abstract String getAliasName();

    abstract String getRouteField();

    abstract RoutedAliasTypes getRoutedAliasType();

    public abstract void validateRouteValue(AddUpdateCommand var1) throws SolrException;

    public String createCollectionsIfRequired(AddUpdateCommand cmd) {
        CandidateCollection candidateCollectionDesc = this.findCandidateGivenValue(cmd);
        try {
            return this.createAllRequiredCollections(cmd, candidateCollectionDesc);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    abstract Map<String, String> getAliasMetadata();

    public abstract Set<String> getRequiredParams();

    public abstract Set<String> getOptionalParams();

    abstract CandidateCollection findCandidateGivenValue(AddUpdateCommand var1);

    private String createAllRequiredCollections(AddUpdateCommand cmd, CandidateCollection targetCollectionDesc) {
        SolrQueryRequest req = cmd.getReq();
        SolrCore core = req.getCore();
        CoreContainer coreContainer = core.getCoreContainer();
        block5: while (true) {
            switch (targetCollectionDesc.getCreationType()) {
                case NONE: {
                    return targetCollectionDesc.destinationCollection;
                }
                case SYNCHRONOUS: {
                    targetCollectionDesc = this.doSynchronous(cmd, targetCollectionDesc, coreContainer);
                    continue block5;
                }
                case ASYNC_PREEMPTIVE: {
                    return this.doPreemptive(targetCollectionDesc, core, coreContainer);
                }
            }
            break;
        }
        throw this.unknownCreateType();
    }

    private CandidateCollection doSynchronous(AddUpdateCommand cmd, CandidateCollection targetCollectionDesc, CoreContainer coreContainer) {
        this.ensureCollection(targetCollectionDesc.getCreationCollection(), coreContainer);
        ZkController zkController = coreContainer.getZkController();
        this.updateParsedCollectionAliases(zkController.zkStateReader, true);
        List observedCols = (List)zkController.zkStateReader.aliasesManager.getAliases().getCollectionAliasListMap().get(this.getAliasName());
        if (!observedCols.contains(targetCollectionDesc.creationCollection)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "After we attempted to create " + targetCollectionDesc.creationCollection + " it did not exist");
        }
        targetCollectionDesc = this.findCandidateGivenValue(cmd);
        return targetCollectionDesc;
    }

    private String doPreemptive(CandidateCollection targetCollectionDesc, SolrCore core, CoreContainer coreContainer) {
        if (!this.preemptiveCreateOnceAlready) {
            this.preemptiveAsync(() -> {
                try {
                    this.ensureCollection(targetCollectionDesc.creationCollection, coreContainer);
                }
                catch (Exception e) {
                    log.error("Async creation of a collection for routed Alias {} failed!", (Object)this.getAliasName(), (Object)e);
                }
            }, core);
        }
        return targetCollectionDesc.destinationCollection;
    }

    protected abstract String getHeadCollectionIfOrdered(AddUpdateCommand var1);

    private void preemptiveAsync(Runnable r, SolrCore core) {
        this.preemptiveCreateOnceAlready = true;
        core.runAsync(r);
    }

    private SolrException unknownCreateType() {
        return new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown creation type while adding document to a Time Routed Alias! This is a bug caused when a creation type has been added but not all code has been updated to handle it.");
    }

    void ensureCollection(String targetCollection, CoreContainer coreContainer) {
        CollectionsHandler collectionsHandler = coreContainer.getCollectionsHandler();
        try {
            MaintainRoutedAliasCmd.remoteInvoke(collectionsHandler, this.getAliasName(), targetCollection);
            coreContainer.getZkController().getZkStateReader().aliasesManager.update();
            this.updateParsedCollectionAliases(coreContainer.getZkController().getZkStateReader(), false);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    protected abstract List<Action> calculateActions(String var1);

    static enum CreationType {
        NONE,
        ASYNC_PREEMPTIVE,
        SYNCHRONOUS;

    }

    static enum ActionType {
        ENSURE_REMOVED,
        ENSURE_EXISTS;

    }

    protected static class Action {
        final RoutedAlias sourceAlias;
        final ActionType actionType;
        final String targetCollection;

        public Action(RoutedAlias sourceAlias, ActionType actionType, String targetCollection) {
            this.sourceAlias = sourceAlias;
            this.actionType = actionType;
            this.targetCollection = targetCollection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Action action = (Action)o;
            return Objects.equals(this.sourceAlias, action.sourceAlias) && this.actionType == action.actionType && Objects.equals(this.targetCollection, action.targetCollection);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sourceAlias, this.actionType, this.targetCollection});
        }
    }

    class CandidateCollection {
        private final CreationType creationType;
        private final String destinationCollection;
        private final String creationCollection;

        CandidateCollection(CreationType creationType, String destinationCollection, String creationCollection) {
            this.creationType = creationType;
            this.destinationCollection = destinationCollection;
            this.creationCollection = creationCollection;
        }

        CandidateCollection(CreationType creationType, String collection) {
            this.creationType = creationType;
            this.destinationCollection = collection;
            this.creationCollection = collection;
        }

        CreationType getCreationType() {
            return this.creationType;
        }

        String getDestinationCollection() {
            return this.destinationCollection;
        }

        String getCreationCollection() {
            return this.creationCollection;
        }
    }
}

