/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.util.ArrayList;
import java.util.List;
import org.apache.tomcat.dbcp.dbcp.AbandonedConfig;
import org.apache.tomcat.dbcp.dbcp.AbandonedTrace;
import org.apache.tomcat.dbcp.pool.PoolableObjectFactory;
import org.apache.tomcat.dbcp.pool.impl.GenericObjectPool;

public class AbandonedObjectPool<T extends AbandonedTrace>
extends GenericObjectPool<T> {
    private final AbandonedConfig config;
    private final List<T> trace = new ArrayList<T>();

    public AbandonedObjectPool(PoolableObjectFactory<T> factory, AbandonedConfig config) {
        super(factory);
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T borrowObject() throws Exception {
        AbandonedTrace obj;
        if (this.config != null && this.config.getRemoveAbandoned() && this.getNumIdle() < 2 && this.getNumActive() > this.getMaxActive() - 3) {
            this.removeAbandoned();
        }
        if ((obj = (AbandonedTrace)super.borrowObject()) != null) {
            obj.setStackTrace();
        }
        if (obj != null && this.config != null && this.config.getRemoveAbandoned()) {
            List<T> list = this.trace;
            synchronized (list) {
                this.trace.add(obj);
            }
        }
        return (T)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(T obj) throws Exception {
        if (this.config != null && this.config.getRemoveAbandoned()) {
            List<T> list = this.trace;
            synchronized (list) {
                boolean foundObject = this.trace.remove(obj);
                if (!foundObject) {
                    return;
                }
            }
        }
        super.returnObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateObject(T obj) throws Exception {
        if (this.config != null && this.config.getRemoveAbandoned()) {
            List<T> list = this.trace;
            synchronized (list) {
                boolean foundObject = this.trace.remove(obj);
                if (!foundObject) {
                    return;
                }
            }
        }
        super.invalidateObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAbandoned() {
        long now = System.currentTimeMillis();
        long timeout = now - (long)(this.config.getRemoveAbandonedTimeout() * 1000);
        ArrayList<AbandonedTrace> remove = new ArrayList<AbandonedTrace>();
        List<T> list = this.trace;
        synchronized (list) {
            for (AbandonedTrace pc : this.trace) {
                if (pc.getLastUsed() > timeout || pc.getLastUsed() <= 0L) continue;
                remove.add(pc);
            }
        }
        for (AbandonedTrace pc : remove) {
            if (this.config.getLogAbandoned()) {
                pc.printStackTrace();
            }
            try {
                this.invalidateObject((T)pc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

