/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource;

import java.util.Vector;
import org.apache.commons.discovery.jdk.JDKHooks;

public class ClassLoaders {
    protected Vector classLoaders = new Vector();

    public int size() {
        return this.classLoaders.size();
    }

    public ClassLoader get(int idx) {
        return (ClassLoader)this.classLoaders.elementAt(idx);
    }

    public void put(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoaders.addElement(classLoader);
        }
    }

    public void put(ClassLoader classLoader, boolean prune) {
        if (!(classLoader == null || prune && this.isAncestor(classLoader))) {
            this.classLoaders.addElement(classLoader);
        }
    }

    public boolean isAncestor(ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        for (int idx = 0; idx < this.size(); ++idx) {
            for (ClassLoader walker = this.get(idx); walker != null; walker = walker.getParent()) {
                if (walker != classLoader) continue;
                return true;
            }
        }
        return false;
    }

    public static ClassLoaders getLibLoaders(Class spi, Class factory, boolean prune) {
        ClassLoaders loaders = new ClassLoaders();
        if (spi != null) {
            loaders.put(spi.getClassLoader());
        }
        if (factory != null) {
            loaders.put(factory.getClassLoader(), prune);
        }
        loaders.put(JDKHooks.getJDKHooks().getSystemClassLoader(), prune);
        return loaders;
    }

    public static ClassLoaders getAppLoaders(Class spi, Class factory, boolean prune) {
        ClassLoaders loaders = new ClassLoaders();
        loaders.put(JDKHooks.getJDKHooks().getThreadContextClassLoader());
        if (spi != null) {
            loaders.put(spi.getClassLoader(), prune);
        }
        if (factory != null) {
            loaders.put(factory.getClassLoader(), prune);
        }
        loaders.put(JDKHooks.getJDKHooks().getSystemClassLoader(), prune);
        return loaders;
    }
}

