/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.spi.ProjectAccessor;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class UsageLogger {
    private static final Logger LOG = Logger.getLogger("org.netbeans.ui.metrics.freeform");
    private static final RequestProcessor RP = new RequestProcessor(UsageLogger.class.getName(), 1, false, false);

    private UsageLogger() {
    }

    public static void log(final Project p) {
        if (LOG.isLoggable(Level.INFO)) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    Object[] data;
                    try {
                        data = UsageLogger.data(p);
                    }
                    catch (Exception x) {
                        Exceptions.printStackTrace((Throwable)x);
                        return;
                    }
                    LogRecord rec = new LogRecord(Level.INFO, "USG_FREEFORM_PROJECT");
                    rec.setParameters(data);
                    rec.setLoggerName(LOG.getName());
                    rec.setResourceBundle(NbBundle.getBundle(UsageLogger.class));
                    rec.setResourceBundleName(UsageLogger.class.getPackage().getName() + ".Bundle");
                    LOG.log(rec);
                }
            });
        }
    }

    private static Object[] data(Project p) throws Exception {
        AntProjectCookie apc;
        FileObject antScript;
        ProjectAccessor accessor = (ProjectAccessor)p.getLookup().lookup(ProjectAccessor.class);
        if (accessor == null) {
            throw new IllegalArgumentException("no ProjectAccessor");
        }
        AntProjectHelper helper = accessor.getHelper();
        PropertyEvaluator eval = accessor.getEvaluator();
        AuxiliaryConfiguration aux = ProjectUtils.getAuxiliaryConfiguration((Project)p);
        int compilationUnits = 0;
        int compilationUnitsMissingBuiltTo = 0;
        int compilationUnitsMultipleRoots = 0;
        HashSet<String> classpathEntries = new HashSet<String>();
        Element java = JavaProjectGenerator.getJavaCompilationUnits(aux);
        if (java != null) {
            for (Element compilationUnitEl : XMLUtil.findSubElements((Element)java)) {
                ++compilationUnits;
                int builtTos = 0;
                int roots = 0;
                for (Element other : XMLUtil.findSubElements((Element)compilationUnitEl)) {
                    String textEval;
                    String text;
                    String name = other.getLocalName();
                    if (name.equals("package-root")) {
                        ++roots;
                        continue;
                    }
                    if (name.equals("built-to")) {
                        ++builtTos;
                        continue;
                    }
                    if (!name.equals("classpath") || (text = XMLUtil.findText((Node)other)) == null || (textEval = eval.evaluate(text)) == null) continue;
                    for (String entry : textEval.split("[:;]")) {
                        if (entry.length() <= 0) continue;
                        classpathEntries.add(entry);
                    }
                }
                if (builtTos == 0) {
                    ++compilationUnitsMissingBuiltTo;
                }
                if (roots <= true) continue;
                ++compilationUnitsMultipleRoots;
            }
        }
        int targets = 0;
        String antScriptS = eval.getProperty("ant.script");
        if (antScriptS == null) {
            antScriptS = "build.xml";
        }
        if ((antScript = FileUtil.toFileObject((File)helper.resolveFile(antScriptS))) != null && (apc = (AntProjectCookie)DataObject.find((FileObject)antScript).getLookup().lookup(AntProjectCookie.class)) != null) {
            try {
                targets = TargetLister.getTargets((AntProjectCookie)apc).size();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        boolean webData = aux.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/2", true) != null || aux.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/1", true) != null;
        return new Object[]{UsageLogger.someOrMany(compilationUnits), UsageLogger.someOrMany(compilationUnitsMissingBuiltTo), UsageLogger.someOrMany(compilationUnitsMultipleRoots), UsageLogger.someOrMany(classpathEntries.size()), UsageLogger.someOrMany(targets), webData};
    }

    private static String someOrMany(int count) {
        if (count < 10) {
            return Integer.toString(count);
        }
        return "~e^" + Math.round(Math.log(count));
    }
}

