/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

class TopoSortGenerator
extends Generator {
    private static final int TOPO_DELAY = 32;
    private final FIFORevQueue pending;
    private final int outputType;

    TopoSortGenerator(Generator s) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        super(s.firstParent);
        RevCommit c;
        this.pending = new FIFORevQueue(this.firstParent);
        this.outputType = s.outputType() | 8;
        s.shareFreeList(this.pending);
        while ((c = s.next()) != null) {
            int i = 0;
            while (i < c.parents.length) {
                if (this.firstParent && i > 0) break;
                ++c.parents[i].inDegree;
                ++i;
            }
            this.pending.add(c);
        }
    }

    @Override
    int outputType() {
        return this.outputType;
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        q.shareFreeList(this.pending);
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        while (true) {
            if ((c = this.pending.next()) == null) {
                return null;
            }
            if (c.inDegree <= 0) break;
            c.flags |= 0x20;
        }
        int i = 0;
        while (i < c.parents.length) {
            if (this.firstParent && i > 0) break;
            RevCommit p = c.parents[i];
            if (--p.inDegree == 0 && (p.flags & 0x20) != 0) {
                p.flags &= 0xFFFFFFDF;
                this.pending.unpop(p);
            }
            ++i;
        }
        return c;
    }
}

