/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.vars;

import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleEval;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleExpression;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.Evaluator;

public class TruffleEvaluator
implements Evaluator<TruffleExpression> {
    private final JPDADebugger debugger;

    public TruffleEvaluator(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Evaluator.Result evaluate(Evaluator.Expression<TruffleExpression> expression, Evaluator.Context context) throws InvalidExpressionException {
        ObjectVariable contextVariable = context.getContextVariable();
        if (contextVariable != null && "toString()".equals(expression.getExpression())) {
            return new Evaluator.Result((Variable)contextVariable);
        }
        TruffleExpression expr = (TruffleExpression)expression.getPreprocessedObject();
        if (expr == null) {
            expr = TruffleExpression.parse(expression.getExpression());
            expression.setPreprocessedObject((Object)expr);
        }
        Variable ret = this.evaluateIn(expr, context.getCallStackFrame(), contextVariable);
        return new Evaluator.Result(ret);
    }

    private Variable evaluateIn(TruffleExpression expr, CallStackFrame callStackFrame, ObjectVariable contextVar) throws InvalidExpressionException {
        return TruffleEval.evaluate(this.debugger, expr.getExpression());
    }
}

