/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.IntroduceLocalExtensionRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.ui.IntroduceLocalExtensionPanel;
import org.netbeans.modules.refactoring.java.ui.IntroduceParameterUI;
import org.netbeans.modules.refactoring.java.ui.JavaRefactoringUIFactory;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class IntroduceLocalExtensionUI
implements RefactoringUI {
    private TreePathHandle type;
    private IntroduceLocalExtensionRefactoring refactoring;
    private IntroduceLocalExtensionPanel panel;
    private final String htmlHeader;
    private final Icon icon;
    private final String newName;
    private final String startPackage;

    private IntroduceLocalExtensionUI(TreePathHandle type, String htmlHeader, Icon icon, String newName, String startPackage) {
        this.refactoring = new IntroduceLocalExtensionRefactoring(type);
        this.type = type;
        this.htmlHeader = htmlHeader;
        this.icon = icon;
        this.newName = newName;
        this.startPackage = startPackage;
    }

    public static IntroduceLocalExtensionUI create(TreePathHandle type, CompilationInfo javac) {
        TypeElement typeElement = (TypeElement)type.resolveElement(javac);
        Icon icon = ElementIcons.getElementIcon((ElementKind)typeElement.getKind(), typeElement.getModifiers());
        String startPackage = IntroduceLocalExtensionUI.getPackageName(type.getFileObject().getParent());
        return new IntroduceLocalExtensionUI(type, typeElement.getSimpleName().toString(), icon, typeElement.getSimpleName().toString(), startPackage);
    }

    public String getName() {
        return NbBundle.getMessage(IntroduceParameterUI.class, (String)"LBL_IntroduceLocalExtension");
    }

    public String getDescription() {
        return NbBundle.getMessage(IntroduceLocalExtensionUI.class, (String)"DSC_IntroduceLocalExtension", (Object)this.htmlHeader);
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new IntroduceLocalExtensionPanel(this.htmlHeader, this.icon, this.newName, this.startPackage, this.type, parent);
        }
        return this.panel;
    }

    private Problem setParameters(boolean checkOnly) {
        if (this.panel == null) {
            return null;
        }
        this.refactoring.setNewName(this.panel.getNewName());
        this.refactoring.setSourceRoot(this.panel.getRootFolder());
        this.refactoring.setPackageName(this.panel.getPackageName());
        this.refactoring.setWrap(this.panel.getWrap());
        this.refactoring.setEquality(this.panel.getEquality());
        this.refactoring.setReplace(this.panel.getReplace());
        if (checkOnly) {
            return this.refactoring.fastCheckParameters();
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    public boolean hasParameters() {
        return true;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.refactoring.java.ui.IntroduceLocalExtensionUI");
    }

    private static String getPackageName(FileObject file) {
        ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
        return cp.getResourceName(file, '.', false);
    }

    public static JavaRefactoringUIFactory factory() {
        return new IntroduceLocalExtensionUIFactory();
    }

    public static class IntroduceLocalExtensionUIFactory
    implements JavaRefactoringUIFactory {
        @Override
        public RefactoringUI create(CompilationInfo info, TreePathHandle[] handles, FileObject[] files, NonRecursiveFolder[] packages) {
            assert (handles.length == 1);
            Element selected = handles[0].resolveElement(info);
            TreePathHandle s = handles[0];
            if (selected == null || !selected.getKind().isClass() && !selected.getKind().isInterface()) {
                TreePath classTreePath = JavaRefactoringUtils.findEnclosingClass(info, handles[0].resolve(info), true, true, true, true, true);
                if (classTreePath == null) {
                    return null;
                }
                s = TreePathHandle.create((TreePath)classTreePath, (CompilationInfo)info);
            }
            return IntroduceLocalExtensionUI.create(s, info);
        }
    }
}

