/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee.db;

import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.payara.jakartaee.db.DriverMaps;

public class DbUtil {
    private static final String __DatabaseVendor = "database-vendor";
    private static final String __DatabaseName = "databaseName";
    private static final String __Url = "URL";
    private static final String __User = "User";
    private static final String __Password = "Password";
    private static final String __NotApplicable = "NA";
    private static final String __IsXA = "isXA";
    private static final String __IsCPExisting = "is-cp-existing";
    private static final String __DerbyDatabaseName = "DatabaseName";
    private static final String __DerbyPortNumber = "PortNumber";
    private static final String __ServerName = "serverName";
    private static final String __InformixHostName = "IfxIFXHOST";
    private static final String __InformixServer = "InformixServer";
    private static final String __DerbyConnAttr = "connectionAttributes";
    private static final String __PortNumber = "portNumber";
    private static final String __SID = "SID";
    private static final String __DriverClass = "driverClass";
    static final String[] VendorsDBNameProp = new String[]{"sun_db2", "sun_oracle", "sun_msftsql", "db2", "microsoft_sql", "post-gre-sql", "mysql", "datadirect_sql", "datadirect_db2", "datadirect_informix", "datadirect_sybase", "datadirect_oracle", "jtds_sql", "jtds_sybase", "informix"};
    static final String[] Reqd_DBName = new String[]{"sun_db2", "sun_msftsql", "datadirect_sql", "microsoft_sql", "datadirect_db2", "datadirect_informix", "datadirect_sybase"};

    static Map<String, String> normalizePoolMap(Map<String, String> poolValues) {
        String driverClassName = poolValues.get("dsClassName");
        String resType = poolValues.get("resType");
        String url = "";
        String serverName = poolValues.get(__ServerName);
        String portNo = poolValues.get(__DerbyPortNumber);
        String dbName = poolValues.get(__DerbyDatabaseName);
        String dbVal = poolValues.get(__DatabaseName);
        String portVal = poolValues.get(__PortNumber);
        String sid = poolValues.get(__SID);
        String urlValue = poolValues.get(__Url);
        String driverClass = poolValues.get(__DriverClass);
        String derbyConnAttr = poolValues.get(__DerbyConnAttr);
        String password = poolValues.get(__Password);
        String user = poolValues.get(__User);
        if (driverClassName.indexOf("pointbase") != -1) {
            url = poolValues.get(__DatabaseName);
        }
        if (serverName == null) {
            for (String key : poolValues.keySet()) {
                if (!__ServerName.equalsIgnoreCase(key)) continue;
                serverName = poolValues.get(key);
                break;
            }
            poolValues.put(__ServerName, serverName);
        }
        if (urlValue == null || urlValue.equals("")) {
            if (driverClassName.indexOf("derby") != -1) {
                if (serverName != null) {
                    url = "jdbc:derby://" + serverName;
                    if (portNo != null && portNo.length() > 0) {
                        url = url + ":" + portNo;
                    }
                    url = url + "/" + dbName;
                    if (derbyConnAttr != null && !derbyConnAttr.equals("")) {
                        url = url + derbyConnAttr;
                    }
                }
            } else if (url == null || url.equals("")) {
                String urlPrefix = DriverMaps.getUrlPrefix(driverClassName, resType);
                String vName = "Unknown";
                Logger.getLogger("payara-jakartaee").log(Level.WARNING, "Unable to compute database vendor name for datasource url.");
                if (serverName != null) {
                    url = vName.equals("sun_oracle") ? urlPrefix + serverName : urlPrefix + "//" + serverName;
                    if (portVal != null && portVal.length() > 0) {
                        url = url + ":" + portVal;
                    }
                }
                if (vName.equals("sun_oracle") || vName.equals("datadirect_oracle")) {
                    url = url + ";SID=" + sid;
                } else if (Arrays.asList(Reqd_DBName).contains(vName)) {
                    url = url + ";databaseName=" + dbVal;
                } else if (Arrays.asList(VendorsDBNameProp).contains(vName) || "Unknown".equals(vName)) {
                    url = url + "/" + dbVal;
                }
            }
        } else {
            url = urlValue;
        }
        if (url != null && !url.equals("") && (driverClass == null || driverClass.equals(""))) {
            String drivername;
            DatabaseConnection databaseConnection = DbUtil.getDatabaseConnection(url);
            driverClass = databaseConnection != null ? databaseConnection.getDriverClass() : ((drivername = DriverMaps.getDriverName(url)) != null ? drivername : driverClassName);
        }
        if (user == null) {
            for (String key : poolValues.keySet()) {
                if (!__User.equalsIgnoreCase(key)) continue;
                user = poolValues.get(key);
                break;
            }
            poolValues.put(__User, user);
        }
        if (password == null) {
            for (String key : poolValues.keySet()) {
                if (!__Password.equalsIgnoreCase(key)) continue;
                password = poolValues.get(key);
                break;
            }
            poolValues.put(__Password, password);
        }
        poolValues.put(__Url, url);
        poolValues.put(__DriverClass, driverClass);
        return poolValues;
    }

    private static DatabaseConnection getDatabaseConnection(String url) {
        DatabaseConnection[] dbConns = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < dbConns.length; ++i) {
            String dbConnUrl = dbConns[i].getDatabaseURL();
            if (!dbConnUrl.startsWith(url)) continue;
            return dbConns[i];
        }
        return null;
    }

    public static final boolean notEmpty(String testedString) {
        return testedString != null && testedString.length() > 0;
    }

    public static final boolean strEmpty(String testedString) {
        return testedString == null || testedString.length() == 0;
    }

    public static final boolean strEquals(String one, String two) {
        boolean result = false;
        result = one == null ? two == null : (two == null ? false : one.equals(two));
        return result;
    }

    public static final boolean strEquivalent(String one, String two) {
        boolean result = false;
        if (DbUtil.strEmpty(one) && DbUtil.strEmpty(two)) {
            result = true;
        } else if (one != null && two != null) {
            result = one.equals(two);
        }
        return result;
    }

    public static final int strCompareTo(String one, String two) {
        int result = one == null ? (two == null ? 0 : -1) : (two == null ? 1 : one.compareTo(two));
        return result;
    }
}

