/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import java.util.Vector;
import javax.swing.Action;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebugger;
import org.netbeans.modules.cpplite.debugger.Utils;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.text.Line;

public class CallStackModel
implements TreeModel,
NodeModel,
NodeActionsProvider,
TableModel {
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private CPPLiteDebugger debugger;
    private Vector listeners = new Vector();

    public CallStackModel(ContextProvider contextProvider) {
        this.debugger = (CPPLiteDebugger)((Object)contextProvider.lookupFirst(null, CPPLiteDebugger.class));
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            return this.debugger.getCallStack();
        }
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof CPPLiteDebugger.Frame) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return this.debugger.getCallStack().length;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof CPPLiteDebugger.Frame) {
            CPPLiteDebugger.Frame frame = (CPPLiteDebugger.Frame)node;
            return frame.functionName + "; " + frame.shortFileName + ":" + frame.line;
        }
        if (node == "Root") {
            return "Root";
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof CPPLiteDebugger.Frame) {
            CPPLiteDebugger.Frame frame = (CPPLiteDebugger.Frame)node;
            return frame.level == 0 ? CURRENT_CALL_STACK : CALL_STACK;
        }
        if (node == "Root") {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof CPPLiteDebugger.Frame) {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node instanceof CPPLiteDebugger.Frame) {
            Line line = ((CPPLiteDebugger.Frame)node).location();
            if (line != null) {
                Utils.showLine(new Line[]{line});
            }
            return;
        }
        throw new UnknownTypeException(node);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        return new Action[0];
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (columnID == "CallStackFrameLocation" && node instanceof CPPLiteDebugger.Frame) {
            CPPLiteDebugger.Frame frame = (CPPLiteDebugger.Frame)node;
            return frame.fullFileName + ":" + frame.line;
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (columnID == "CallStackFrameLocation" && node instanceof CPPLiteDebugger.Frame) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    void fireChanges() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }
}

