/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import java.util.Vector;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class WatchesModel
implements NodeModelFilter,
TableModel {
    public static final String WATCH = "org/netbeans/modules/debugger/resources/watchesView/Watch";
    private CPPLiteDebugger debugger;
    private Vector listeners = new Vector();

    public WatchesModel(ContextProvider contextProvider) {
        this.debugger = (CPPLiteDebugger)((Object)contextProvider.lookupFirst(null, CPPLiteDebugger.class));
        this.debugger.setWatchesModel(this);
    }

    public String getDisplayName(NodeModel model, Object node) throws UnknownTypeException {
        return model.getDisplayName(node);
    }

    public String getIconBase(NodeModel model, Object node) throws UnknownTypeException {
        return model.getIconBase(node);
    }

    public String getShortDescription(NodeModel model, Object node) throws UnknownTypeException {
        if (node instanceof Watch) {
            if (!((Watch)node).isEnabled()) {
                return NbBundle.getMessage(WatchesModel.class, (String)"CTL_WatchDisabled");
            }
            String expression = ((Watch)node).getExpression();
            return this.debugger.evaluate(expression);
        }
        return model.getShortDescription(node);
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if ((columnID == "WatchToString" || columnID == "WatchValue") && node instanceof Watch) {
            if (!((Watch)node).isEnabled()) {
                return NbBundle.getMessage(WatchesModel.class, (String)"CTL_WatchDisabled");
            }
            String expression = ((Watch)node).getExpression();
            return this.debugger.evaluate(expression);
        }
        if (columnID == "WatchType" && node instanceof Watch) {
            return "";
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if ((columnID == "WatchToString" || columnID == "WatchValue" || columnID == "WatchType") && node instanceof Watch) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    void fireChanges() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }
}

