/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.project;

import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

public class ClientProjectNodeFactory
implements NodeFactory {
    public NodeList<?> createNodes(Project p) {
        return new PlatformsSingleton(p);
    }

    private static class PlatformsSingleton
    implements NodeList,
    FileChangeListener {
        private static Object key = "platforms";
        private ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private FileObject root;

        public PlatformsSingleton(Project p) {
            this.root = p.getProjectDirectory();
            this.root.addFileChangeListener((FileChangeListener)this);
        }

        public void fileFolderCreated(FileEvent fe) {
            this.changeSupport.fireChange();
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            this.changeSupport.fireChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.changeSupport.fireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public List keys() {
            FileObject platforms = this.root.getFileObject("platforms");
            if (platforms != null) {
                return Collections.singletonList(key);
            }
            return Collections.emptyList();
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public Node node(Object k) {
            FileObject platforms;
            if (key.equals(k) && (platforms = this.root.getFileObject("platforms")) != null) {
                try {
                    DataObject dob = DataObject.find((FileObject)platforms);
                    return dob.getNodeDelegate();
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }

        public void addNotify() {
        }

        public void removeNotify() {
        }
    }
}

