/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public class PostFlowAnalysis
extends TreeScanner {
    private Log log;
    private Types types;
    private Enter enter;
    private Names names;
    private Symtab syms;
    private List<Pair<Symbol.TypeSymbol, Symbol>> outerThisStack;
    private Symbol.TypeSymbol currentClass;
    private boolean checkThis = true;

    private PostFlowAnalysis(Context ctx) {
        this.log = Log.instance(ctx);
        this.types = Types.instance(ctx);
        this.enter = Enter.instance(ctx);
        this.names = Names.instance(ctx);
        this.syms = Symtab.instance(ctx);
        this.outerThisStack = List.nil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void analyze(Iterable<? extends Element> elems, Context ctx) {
        assert (elems != null);
        PostFlowAnalysis postFlowAnalysis = new PostFlowAnalysis(ctx);
        for (Element element : elems) {
            Env<AttrContext> env;
            if (!(element instanceof Symbol.TypeSymbol) || (env = postFlowAnalysis.enter.getClassEnv((Symbol.TypeSymbol)element)) == null) continue;
            JavaFileObject prev = postFlowAnalysis.log.useSource(env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile);
            try {
                postFlowAnalysis.scan(env.toplevel);
            }
            finally {
                postFlowAnalysis.log.useSource(prev);
            }
        }
    }

    @Override
    public void scan(JCTree tree) {
        if (tree != null && tree.type != null && tree.type.constValue() != null) {
            this.checkStringConstant(tree.pos(), tree.type.constValue());
        }
        super.scan(tree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        Symbol.TypeSymbol currentClassPrev = this.currentClass;
        this.currentClass = tree.sym;
        List<Pair<Symbol.TypeSymbol, Symbol>> prevOuterThisStack = this.outerThisStack;
        try {
            if (this.currentClass != null) {
                if (this.currentClass.hasOuterInstance()) {
                    this.outerThisDef(this.currentClass);
                }
                super.visitClassDef(tree);
            }
        }
        finally {
            this.outerThisStack = prevOuterThisStack;
            this.currentClass = currentClassPrev;
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        if (tree.name == this.names.init && (this.currentClass.isInner() || this.currentClass.isLocal())) {
            List<Pair<Symbol.TypeSymbol, Symbol>> prevOuterThisStack = this.outerThisStack;
            try {
                if (this.currentClass.hasOuterInstance()) {
                    this.outerThisDef(tree.sym);
                }
                super.visitMethodDef(tree);
            }
            finally {
                this.outerThisStack = prevOuterThisStack;
            }
        } else {
            super.visitMethodDef(tree);
        }
        if (tree.sym == null || tree.sym.owner == null || tree.type == null || tree.type == this.syms.unknownType) {
            return;
        }
        Scope.WriteableScope s = tree.sym.owner.members();
        if (s == null) {
            return;
        }
        Type type = this.types.erasure(tree.type);
        for (Symbol sym : s.getSymbolsByName(tree.name)) {
            try {
                boolean clash = sym != tree.sym && !sym.type.isErroneous() && !type.isErroneous() && this.types.isSameType(this.types.erasure(sym.type), type);
                if (!clash) continue;
                this.log.error(tree.pos(), new JCDiagnostic.Error("compiler", "name.clash.same.erasure", tree.sym, sym));
                return;
            }
            catch (AssertionError assertionError) {
            }
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        Symbol c;
        super.visitNewClass(tree);
        Symbol symbol = c = tree.constructor != null ? tree.constructor.owner : null;
        if (c != null && c != this.syms.noSymbol && c.hasOuterInstance() && tree.encl == null && c.isLocal()) {
            this.checkThis(tree.pos(), c.type.getEnclosingType().tsym);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        boolean prevCheckThis = this.checkThis;
        try {
            Symbol c;
            Symbol meth = TreeInfo.symbol(tree.meth);
            Name methName = TreeInfo.name(tree.meth);
            if (meth != null && meth.name == this.names.init && (c = meth.owner).hasOuterInstance()) {
                this.checkThis = false;
                if (tree.meth.getTag() != JCTree.Tag.SELECT && (c.isLocal() || methName == this.names._this)) {
                    this.checkThis(tree.meth.pos(), c.type.getEnclosingType().tsym);
                }
            }
            super.visitApply(tree);
        }
        finally {
            this.checkThis = prevCheckThis;
        }
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        super.visitSelect(tree);
        if (tree.selected.type != null && (tree.name == this.names._this || tree.name == this.names._super && !this.types.isDirectSuperInterface(tree.selected.type.tsym, this.currentClass))) {
            this.checkThis(tree.pos(), tree.selected.type.tsym);
        }
    }

    private void checkThis(JCDiagnostic.DiagnosticPosition pos, Symbol.TypeSymbol c) {
        if (this.checkThis && this.currentClass != c) {
            List<Pair<Symbol.TypeSymbol, Symbol>> ots = this.outerThisStack;
            if (ots.isEmpty()) {
                this.log.error(pos, new JCDiagnostic.Error("compiler", "no.encl.instance.of.type.in.scope", c));
                return;
            }
            Pair ot = (Pair)ots.head;
            Symbol.TypeSymbol otc = (Symbol.TypeSymbol)ot.fst;
            while (otc != c) {
                do {
                    if ((ots = ots.tail).isEmpty()) {
                        this.log.error(pos, new JCDiagnostic.Error("compiler", "no.encl.instance.of.type.in.scope", c));
                        return;
                    }
                    ot = (Pair)ots.head;
                } while (ot.snd != otc);
                if (otc.owner.kind != Kinds.Kind.PCK && !otc.hasOuterInstance()) {
                    this.log.error(pos, new JCDiagnostic.Error("compiler", "cant.ref.before.ctor.called", c));
                    return;
                }
                otc = (Symbol.TypeSymbol)ot.fst;
            }
        }
    }

    private void outerThisDef(Symbol owner) {
        Type target = this.types.erasure(owner.enclClass().type.getEnclosingType());
        Pair<Symbol.TypeSymbol, Symbol> outerThis = Pair.of(target.tsym, owner);
        this.outerThisStack = this.outerThisStack.prepend(outerThis);
    }

    private void checkStringConstant(JCDiagnostic.DiagnosticPosition pos, Object constValue) {
        if (constValue instanceof String && ((String)constValue).length() >= 65535) {
            this.log.error(pos, new JCDiagnostic.Error("compiler", "limit.string", new Object[0]));
        }
    }
}

