/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.blocking;

import com.sun.enterprise.web.connector.grizzly.DefaultProcessorTask;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.TaskContext;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.apache.coyote.ActionHook;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.http11.InternalOutputBuffer;
import org.apache.tomcat.util.net.SSLImplementation;

public class ProcessorBlockingTask
extends DefaultProcessorTask {
    protected SSLImplementation sslImplementation = null;

    public ProcessorBlockingTask() {
        this(true);
    }

    public ProcessorBlockingTask(boolean init) {
        this.type = 2;
        if (init) {
            this.initialize();
        }
    }

    public void initialize() {
        this.started = true;
        this.request = new Request();
        this.response = new Response();
        this.response.setHook((ActionHook)this);
        this.inputBuffer = new InternalInputBuffer(this.request, this.requestBufferSize);
        this.outputBuffer = new InternalOutputBuffer(this.response, this.maxHttpHeaderSize, true);
        this.request.setInputBuffer((InputBuffer)this.inputBuffer);
        this.response.setOutputBuffer((OutputBuffer)this.outputBuffer);
        this.request.setResponse(this.response);
        this.initializeFilters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTask() throws IOException {
        try {
            try {
                this.process(this.socket.getInputStream(), this.socket.getOutputStream());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                SelectorThread.logger().log(Level.FINE, "processorTask.errorProcessingRequest", ex);
                Object var3_2 = null;
                this.terminateProcess();
            }
            Object var3_1 = null;
            this.terminateProcess();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.terminateProcess();
            throw throwable;
        }
    }

    public void taskEvent(TaskEvent event) {
        if (event.getStatus() == 0) {
            this.taskContext = (TaskContext)event.attachement();
            if (this.taskEvent == null) {
                this.taskEvent = new TaskEvent();
            }
            this.taskEvent.attach(this.taskContext);
            this.execute();
        }
    }

    public boolean process(InputStream input, OutputStream output) throws Exception {
        this.preProcess(input, output);
        if (this.sslImplementation != null) {
            this.sslSupport = this.sslImplementation.getSSLSupport(this.socket);
        }
        this.doProcess(input, output);
        this.postProcess(input, output);
        return this.keepAlive;
    }

    public void preProcess(InputStream input, OutputStream output) throws Exception {
        if (!this.started) {
            this.initialize();
        }
        this.inputBuffer.setInputStream(input);
        this.outputBuffer.setOutputStream(output);
        this.configPreProcess();
    }

    protected boolean doProcess(InputStream input, OutputStream output) throws Exception {
        boolean exitWhile;
        boolean keptAlive = false;
        while (this.started && !this.error && this.keepAlive && !(exitWhile = this.parseRequest(input, output, keptAlive))) {
            this.invokeAdapter();
            this.postResponse();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateProcess() {
        this.taskEvent.setStatus(2);
        try {
            this.fireTaskEvent(this.taskEvent);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.clearTaskListeners();
            throw throwable;
        }
        this.clearTaskListeners();
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.maxKeepAliveRequests = maxKeepAliveRequests;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public int countBlockingKeepAlive() {
        if (this.maxKeepAliveRequests == -1) {
            return -1;
        }
        return this.maxKeepAliveRequests - this.keepAliveLeft;
    }

    public SSLImplementation getSSLImplementation() {
        return this.sslImplementation;
    }

    public void setSSLImplementation(SSLImplementation sslImplementation) {
        this.sslImplementation = sslImplementation;
    }

    public void recycle() {
        this.socket = null;
        this.dropConnection = false;
    }
}

