/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.ListFormatPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.cast.JSStringListFromIterableNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSListFormat;
import java.util.List;

public final class ListFormatPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<ListFormatPrototype> {
    protected ListFormatPrototypeBuiltins() {
        super("ListFormat.prototype", ListFormatPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ListFormatPrototype builtinEnum) {
        switch (builtinEnum) {
            case resolvedOptions: {
                return ListFormatPrototypeBuiltinsFactory.JSListFormatResolvedOptionsNodeGen.create(context, builtin, ListFormatPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case format: {
                return ListFormatPrototypeBuiltinsFactory.JSListFormatFormatNodeGen.create(context, builtin, ListFormatPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case formatToParts: {
                return ListFormatPrototypeBuiltinsFactory.JSListFormatFormatToPartsNodeGen.create(context, builtin, ListFormatPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class JSListFormatFormatToPartsNode
    extends JSBuiltinNode {
        public JSListFormatFormatToPartsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSListFormat(listFormat)"})
        public Object doFormatToParts(DynamicObject listFormat, Object value, @Cached(value="create(getContext())") JSStringListFromIterableNode strListFromIterableNode) {
            List<String> list = strListFromIterableNode.executeIterable(value);
            return JSListFormat.formatToParts(this.getContext(), listFormat, list);
        }

        @Fallback
        public void throwTypeError(Object bummer, Object value) {
            throw Errors.createTypeErrorTypeXExpected("ListFormat");
        }
    }

    public static abstract class JSListFormatFormatNode
    extends JSBuiltinNode {
        public JSListFormatFormatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSListFormat(listFormat)"})
        public String doFormat(DynamicObject listFormat, Object value, @Cached(value="create(getContext())") JSStringListFromIterableNode strListFromIterableNode) {
            List<String> list = strListFromIterableNode.executeIterable(value);
            return JSListFormat.format(listFormat, list);
        }

        @Fallback
        public void throwTypeError(Object bummer, Object value) {
            throw Errors.createTypeErrorTypeXExpected("ListFormat");
        }
    }

    public static abstract class JSListFormatResolvedOptionsNode
    extends JSBuiltinNode {
        public JSListFormatResolvedOptionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSListFormat(listFormat)"})
        public Object doResolvedOptions(DynamicObject listFormat) {
            return JSListFormat.resolvedOptions(this.getContext(), listFormat);
        }

        @Fallback
        public void doResolvedOptions(Object bummer) {
            throw Errors.createTypeErrorTypeXExpected("ListFormat");
        }
    }

    public static enum ListFormatPrototype implements BuiltinEnum<ListFormatPrototype>
    {
        resolvedOptions(0),
        format(1),
        formatToParts(1);

        private final int length;

        private ListFormatPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

