/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.WeakMapPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSWeakMap;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.WeakMap;
import java.util.WeakHashMap;

public final class WeakMapPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<WeakMapPrototype> {
    protected WeakMapPrototypeBuiltins() {
        super("WeakMap.prototype", WeakMapPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, WeakMapPrototype builtinEnum) {
        switch (builtinEnum) {
            case delete: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapDeleteNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case set: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapSetNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case get: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapGetNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case has: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapHasNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    protected static RuntimeException typeErrorKeyIsNotObject() {
        throw Errors.createTypeError("WeakMap key must be an object");
    }

    protected static RuntimeException typeErrorWeakMapExpected() {
        throw Errors.createTypeError("WeakMap expected");
    }

    public static abstract class JSWeakMapHasNode
    extends JSWeakMapBaseNode {
        public JSWeakMapHasNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSWeakMap(thisObj)", "isJSObject(key)", "!isJSProxy(key)"})
        protected Object hasCached(DynamicObject thisObj, DynamicObject key, @Cached(value="createStorageGet()") PropertyGetNode storageGetter, @Cached(value="createInvertedGet()") PropertyGetNode invertedGetter, @Cached(value="createInvertedHas()") HasHiddenKeyCacheNode invertedHas, @Cached(value="createClassProfile()") ValueProfile weakMapKlassProfile, @Cached(value="createClassProfile()") ValueProfile invertedKlassProfile, @Cached(value="createBinaryProfile()") ConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)weakMapKlassProfile.profile(storageGetter.getValue(thisObj));
            if (hasInvertedProfile.profile(invertedHas.executeHasHiddenKey(key))) {
                Object inverted = invertedKlassProfile.profile(invertedGetter.getValue(key));
                WeakHashMap invertedMap = (WeakHashMap)inverted;
                return JSWeakMapHasNode.mapHas(map, invertedMap);
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static boolean mapHas(WeakMap map, WeakHashMap<WeakMap, Object> invertedMap) {
            return invertedMap.containsKey(map);
        }

        @Specialization(guards={"isJSWeakMap(thisObj)", "isJSObject(key)"})
        protected static boolean has(DynamicObject thisObj, DynamicObject key) {
            return Boundaries.mapContainsKey(JSWeakMap.getInternalWeakMap(thisObj), key);
        }

        @Specialization(guards={"isJSWeakMap(thisObj)", "!isJSObject(key)"})
        protected static boolean hasNonObjectKey(DynamicObject thisObj, Object key) {
            return false;
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static boolean notWeakMap(Object thisObj, Object key) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }
    }

    public static abstract class JSWeakMapSetNode
    extends JSWeakMapBaseNode {
        public JSWeakMapSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSWeakMap(thisObj)", "isJSObject(key)", "!isJSProxy(key)"})
        protected Object setCached(DynamicObject thisObj, DynamicObject key, Object value, @Cached(value="createStorageGet()") PropertyGetNode storageGetter, @Cached(value="createInvertedGet()") PropertyGetNode invertedGetter, @Cached(value="createInvertedHas()") HasHiddenKeyCacheNode invertedHas, @Cached(value="createClassProfile()") ValueProfile weakMapKlassProfile, @Cached(value="createClassProfile()") ValueProfile invertedKlassProfile, @Cached(value="createBinaryProfile()") ConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)weakMapKlassProfile.profile(storageGetter.getValue(thisObj));
            if (hasInvertedProfile.profile(invertedHas.executeHasHiddenKey(key))) {
                Object inverted = invertedKlassProfile.profile(invertedGetter.getValue(key));
                WeakHashMap invertedMap = (WeakHashMap)inverted;
                JSWeakMapSetNode.mapPut(map, invertedMap, value);
            } else {
                Boundaries.mapPut(JSWeakMap.getInternalWeakMap(thisObj), key, value);
            }
            return thisObj;
        }

        @Specialization(guards={"isJSWeakMap(thisObj)", "isJSObject(key)"})
        protected static DynamicObject set(DynamicObject thisObj, DynamicObject key, Object value) {
            Boundaries.mapPut(JSWeakMap.getInternalWeakMap(thisObj), key, value);
            return thisObj;
        }

        @Specialization(guards={"isJSWeakMap(thisObj)", "!isJSObject(key)"})
        protected static DynamicObject setNonObjectKey(DynamicObject thisObj, Object key, Object value) {
            throw WeakMapPrototypeBuiltins.typeErrorKeyIsNotObject();
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static DynamicObject notWeakMap(Object thisObj, Object key, Object value) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static Object mapPut(WeakMap map, WeakHashMap<WeakMap, Object> invertedMap, Object value) {
            return invertedMap.put(map, value);
        }
    }

    public static abstract class JSWeakMapGetNode
    extends JSWeakMapBaseNode {
        public JSWeakMapGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSWeakMap(thisObj)", "isJSObject(key)", "!isJSProxy(key)"})
        protected Object getCached(DynamicObject thisObj, DynamicObject key, @Cached(value="createStorageGet()") PropertyGetNode storageGetter, @Cached(value="createInvertedGet()") PropertyGetNode invertedGetter, @Cached(value="createInvertedHas()") HasHiddenKeyCacheNode invertedHas, @Cached(value="createClassProfile()") ValueProfile weakMapKlassProfile, @Cached(value="createClassProfile()") ValueProfile invertedKlassProfile, @Cached(value="createBinaryProfile()") ConditionProfile hasInvertedProfile) {
            Object inverted;
            WeakHashMap invertedMap;
            Object value;
            WeakMap map = (WeakMap)weakMapKlassProfile.profile(storageGetter.getValue(thisObj));
            if (hasInvertedProfile.profile(invertedHas.executeHasHiddenKey(key)) && (value = JSWeakMapGetNode.mapGet(map, invertedMap = (WeakHashMap)(inverted = invertedKlassProfile.profile(invertedGetter.getValue(key))))) != null) {
                return value;
            }
            return Undefined.instance;
        }

        @Specialization(guards={"isJSWeakMap(thisObj)", "isJSObject(key)"})
        protected Object get(DynamicObject thisObj, DynamicObject key) {
            Object value = Boundaries.mapGet(JSWeakMap.getInternalWeakMap(thisObj), key);
            if (value != null) {
                return value;
            }
            return Undefined.instance;
        }

        @Specialization(guards={"isJSWeakMap(thisObj)", "!isJSObject(key)"})
        protected static Object getNonObjectKey(DynamicObject thisObj, Object key) {
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static boolean notWeakMap(Object thisObj, Object key) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static Object mapGet(WeakMap map, WeakHashMap<WeakMap, Object> invertedMap) {
            return invertedMap.get(map);
        }
    }

    public static abstract class JSWeakMapDeleteNode
    extends JSBuiltinNode {
        public JSWeakMapDeleteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSWeakMap(thisObj)", "isJSObject(key)"})
        protected static boolean delete(DynamicObject thisObj, DynamicObject key) {
            return Boundaries.mapRemove(JSWeakMap.getInternalWeakMap(thisObj), key) != null;
        }

        @Specialization(guards={"isJSWeakMap(thisObj)", "!isJSObject(key)"})
        protected static Object deleteNonObjectKey(DynamicObject thisObj, Object key) {
            return false;
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static boolean notWeakMap(Object thisObj, Object key) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }
    }

    protected static abstract class JSWeakMapBaseNode
    extends JSBuiltinNode {
        protected JSWeakMapBaseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected PropertyGetNode createStorageGet() {
            return JSWeakMap.createKeyMapGetterNode(this.getContext());
        }

        protected PropertyGetNode createInvertedGet() {
            return WeakMap.createInvertedKeyMapGetNode(this.getContext());
        }

        protected HasHiddenKeyCacheNode createInvertedHas() {
            return WeakMap.createInvertedKeyMapHasNode();
        }
    }

    public static enum WeakMapPrototype implements BuiltinEnum<WeakMapPrototype>
    {
        delete(1),
        set(2),
        get(1),
        has(1);

        private final int length;

        private WeakMapPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

