/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.simd;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.simd.JSConstructSIMDTypeNode;
import com.oracle.truffle.js.builtins.simd.SIMDBuiltinsFactory;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;

public final class SIMDBuiltins
extends JSBuiltinsContainer.SwitchEnum<SIMDConstructor> {
    public SIMDBuiltins() {
        super("SIMD", SIMDConstructor.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, SIMDConstructor builtinEnum) {
        switch (builtinEnum) {
            case SIMDTypes: {
                return CallSIMDTypeNode.create(context, builtin, SIMDBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case Float32x4: 
            case Int32x4: 
            case Int16x8: 
            case Int8x16: 
            case Uint32x4: 
            case Uint16x8: 
            case Uint8x16: 
            case Bool32x4: 
            case Bool16x8: 
            case Bool8x16: {
                return JSConstructSIMDTypeNode.create(context, builtin, SIMDBuiltins.args().varArgs().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class CallSIMDTypeNode
    extends JSBuiltinNode {
        public CallSIMDTypeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        public static CallSIMDTypeNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] createArgumentNodes) {
            return SIMDBuiltinsFactory.CallSIMDTypeNodeGen.create(context, builtin, createArgumentNodes);
        }

        @Specialization
        protected Object callSIMDType(Object ... args) {
            throw Errors.createTypeError("wrong");
        }
    }

    public static enum SIMDConstructor implements BuiltinEnum<SIMDConstructor>
    {
        Float32x4(0),
        Int32x4(0),
        Int16x8(0),
        Int8x16(0),
        Uint32x4(0),
        Uint16x8(0),
        Uint8x16(0),
        Bool32x4(0),
        Bool16x8(0),
        Bool8x16(0),
        SIMDTypes(0);

        private final int length;

        private SIMDConstructor(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

