/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes;

import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSCollator;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSDateTimeFormat;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSListFormat;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.JSPluralRules;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSRelativeTimeFormat;
import com.oracle.truffle.js.runtime.builtins.JSSIMD;
import com.oracle.truffle.js.runtime.builtins.JSSegmenter;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.JSWeakMap;
import com.oracle.truffle.js.runtime.builtins.JSWeakSet;
import com.oracle.truffle.js.runtime.java.JavaPackage;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.nio.ByteBuffer;
import java.util.List;

public final class JSGuards {
    public static final boolean FALSE = false;
    public static final boolean TRUE = true;

    private JSGuards() {
    }

    public static boolean isJSObject(Object value) {
        return JSRuntime.isObject(value);
    }

    public static boolean isJSObject(DynamicObject value) {
        return JSRuntime.isObject(value);
    }

    public static boolean isJSType(Object value) {
        return JSObject.isJSObject(value);
    }

    public static boolean isJSType(DynamicObject value) {
        return JSObject.isJSObject(value);
    }

    public static boolean isTruffleObject(Object value) {
        return value instanceof TruffleObject;
    }

    public static boolean isJavaLangString(Object value) {
        return value instanceof String;
    }

    public static boolean isForeignObject(Object value) {
        return JSRuntime.isForeignObject(value);
    }

    public static boolean isForeignObject(TruffleObject value) {
        return !JSObject.isJSObject(value) && !(value instanceof Symbol) && !(value instanceof JSLazyString) && !(value instanceof LargeInteger) && !(value instanceof BigInt);
    }

    public static boolean isUndefined(Object value) {
        return value == Undefined.instance;
    }

    public static boolean isJavaNull(Object o) {
        return o == null;
    }

    public static boolean isJSNull(Object value) {
        return value == Null.instance;
    }

    public static boolean isDynamicObject(Object value) {
        return JSObject.isDynamicObject(value);
    }

    public static boolean isJSFunction(Object value) {
        return JSFunction.isJSFunction(value);
    }

    public static boolean isJSFunctionShape(Shape shape) {
        return shape.getObjectType() == JSFunction.INSTANCE;
    }

    public static boolean isBoundJSFunction(Object value) {
        return JSGuards.isJSFunction(value) && JSFunction.isBoundFunction((DynamicObject)value);
    }

    public static boolean isJSFunction(DynamicObject value) {
        return JSFunction.isJSFunction(value);
    }

    public static boolean isCallable(Object reviver) {
        return JSRuntime.isCallable(reviver);
    }

    public static boolean isCallableProxy(DynamicObject proxy) {
        return JSRuntime.isCallableProxy(proxy);
    }

    public static boolean isJSString(DynamicObject value) {
        return JSString.isJSString(value);
    }

    public static boolean isJSString(Object value) {
        return JSString.isJSString(value);
    }

    public static boolean isJSNumber(DynamicObject value) {
        return JSNumber.isJSNumber(value);
    }

    public static boolean isJSNumber(Object value) {
        return JSNumber.isJSNumber(value);
    }

    public static boolean isJSBigInt(DynamicObject value) {
        return JSBigInt.isJSBigInt(value);
    }

    public static boolean isJSBigInt(Object value) {
        return JSBigInt.isJSBigInt(value);
    }

    public static boolean isJSBoolean(DynamicObject value) {
        return JSBoolean.isJSBoolean(value);
    }

    public static boolean isJSBoolean(Object value) {
        return JSBoolean.isJSBoolean(value);
    }

    public static boolean isJSDate(DynamicObject value) {
        return JSDate.isJSDate(value);
    }

    public static boolean isJSDate(Object value) {
        return JSDate.isJSDate(value);
    }

    public static boolean isJSArray(DynamicObject value) {
        return JSArray.isJSArray(value);
    }

    public static boolean isJSArray(Object value) {
        return JSArray.isJSArray(value);
    }

    public static boolean isJSArgumentsObject(DynamicObject value) {
        return JSArgumentsObject.isJSArgumentsObject(value);
    }

    public static boolean isJSArgumentsObject(Object value) {
        return JSArgumentsObject.isJSArgumentsObject(value);
    }

    public static boolean isJSRegExp(Object value) {
        return JSRegExp.isJSRegExp(value);
    }

    public static boolean isJSRegExp(DynamicObject value) {
        return JSRegExp.isJSRegExp(value);
    }

    public static boolean isJSUserObject(DynamicObject value) {
        return JSUserObject.isJSUserObject(value);
    }

    public static boolean isJSUserObject(Object value) {
        return JSUserObject.isJSUserObject(value);
    }

    public static boolean isJSDateTimeFormat(DynamicObject value) {
        return JSDateTimeFormat.isJSDateTimeFormat(value);
    }

    public static boolean isJSDateTimeFormat(Object value) {
        return JSDateTimeFormat.isJSDateTimeFormat(value);
    }

    public static boolean isJSCollator(DynamicObject value) {
        return JSCollator.isJSCollator(value);
    }

    public static boolean isJSCollator(Object value) {
        return JSCollator.isJSCollator(value);
    }

    public static boolean isJSListFormat(DynamicObject value) {
        return JSListFormat.isJSListFormat(value);
    }

    public static boolean isJSListFormat(Object value) {
        return JSListFormat.isJSListFormat(value);
    }

    public static boolean isJSNumberFormat(DynamicObject value) {
        return JSNumberFormat.isJSNumberFormat(value);
    }

    public static boolean isJSNumberFormat(Object value) {
        return JSNumberFormat.isJSNumberFormat(value);
    }

    public static boolean isJSPluralRules(DynamicObject value) {
        return JSPluralRules.isJSPluralRules(value);
    }

    public static boolean isJSPluralRules(Object value) {
        return JSPluralRules.isJSPluralRules(value);
    }

    public static boolean isJSRelativeTimeFormat(DynamicObject value) {
        return JSRelativeTimeFormat.isJSRelativeTimeFormat(value);
    }

    public static boolean isJSRelativeTimeFormat(Object value) {
        return JSRelativeTimeFormat.isJSRelativeTimeFormat(value);
    }

    public static boolean isJSSegmenter(DynamicObject value) {
        return JSSegmenter.isJSSegmenter(value);
    }

    public static boolean isJSSegmenter(Object value) {
        return JSSegmenter.isJSSegmenter(value);
    }

    public static boolean isNumber(Object operand) {
        return JSRuntime.isNumber(operand);
    }

    public static boolean isJavaNumber(Object operand) {
        return JSRuntime.isJavaNumber(operand);
    }

    public static boolean isNumberInteger(Object thisObj) {
        return thisObj instanceof Integer;
    }

    public static boolean isJSNumberInteger(DynamicObject thisObj) {
        return JSNumber.valueOf(thisObj) instanceof Integer;
    }

    public static boolean isString(Object operand) {
        return JSRuntime.isString(operand);
    }

    public static boolean isBoolean(Object operand) {
        return operand instanceof Boolean;
    }

    public static boolean isSymbol(Object operand) {
        return operand instanceof Symbol;
    }

    public static boolean isJSHeapArrayBuffer(DynamicObject thisObj) {
        return JSArrayBuffer.isJSHeapArrayBuffer(thisObj);
    }

    public static boolean isJSHeapArrayBuffer(Object thisObj) {
        return JSArrayBuffer.isJSHeapArrayBuffer(thisObj);
    }

    public static boolean isJSDirectArrayBuffer(DynamicObject thisObj) {
        return JSArrayBuffer.isJSDirectArrayBuffer(thisObj);
    }

    public static boolean isJSDirectArrayBuffer(Object thisObj) {
        return JSArrayBuffer.isJSDirectArrayBuffer(thisObj);
    }

    public static boolean isJSSharedArrayBuffer(DynamicObject thisObj) {
        return JSSharedArrayBuffer.isJSSharedArrayBuffer(thisObj);
    }

    public static boolean isJSSharedArrayBuffer(Object thisObj) {
        return JSSharedArrayBuffer.isJSSharedArrayBuffer(thisObj);
    }

    public static boolean isJSArrayBufferView(DynamicObject thisObj) {
        return JSArrayBufferView.isJSArrayBufferView(thisObj);
    }

    public static boolean isJSArrayBufferView(Object thisObj) {
        return JSArrayBufferView.isJSArrayBufferView(thisObj);
    }

    public static boolean isJSFastArray(DynamicObject value) {
        return JSArray.isJSFastArray(value);
    }

    public static boolean isJSFastArray(Object value) {
        return JSArray.isJSFastArray(value);
    }

    public static boolean isJSProxy(DynamicObject value) {
        return JSProxy.isProxy(value);
    }

    public static boolean isJSProxy(Object value) {
        return JSProxy.isProxy(value);
    }

    public static boolean isJSFastArguments(DynamicObject value) {
        return JSArgumentsObject.isJSFastArgumentsObject(value);
    }

    public static boolean isJSFastArguments(Object value) {
        return JSArgumentsObject.isJSFastArgumentsObject(value);
    }

    public static boolean isJSSymbol(DynamicObject value) {
        return JSSymbol.isJSSymbol(value);
    }

    public static boolean isJSSymbol(Object value) {
        return JSSymbol.isJSSymbol(value);
    }

    public static boolean isJSMap(DynamicObject value) {
        return JSMap.isJSMap(value);
    }

    public static boolean isJSMap(Object value) {
        return JSMap.isJSMap(value);
    }

    public static boolean isJSSet(DynamicObject value) {
        return JSSet.isJSSet(value);
    }

    public static boolean isJSSet(Object value) {
        return JSSet.isJSSet(value);
    }

    public static boolean isJSWeakMap(DynamicObject value) {
        return JSWeakMap.isJSWeakMap(value);
    }

    public static boolean isJSWeakMap(Object value) {
        return JSWeakMap.isJSWeakMap(value);
    }

    public static boolean isJSWeakSet(DynamicObject value) {
        return JSWeakSet.isJSWeakSet(value);
    }

    public static boolean isJSWeakSet(Object value) {
        return JSWeakSet.isJSWeakSet(value);
    }

    public static boolean isJSAdapter(Object object) {
        return JSAdapter.isJSAdapter(object);
    }

    public static boolean isJSAdapter(DynamicObject object) {
        return JSAdapter.isJSAdapter(object);
    }

    public static boolean isValidPrototype(Object prototype) {
        return JSGuards.isJSObject(prototype) || JSGuards.isJSNull(prototype);
    }

    public static boolean isByteBuffer(Object buffer) {
        return buffer instanceof ByteBuffer;
    }

    public static boolean isJSSIMD(Object object) {
        return JSSIMD.isJSSIMD(object);
    }

    public static boolean isClass(Object value) {
        return value instanceof Class;
    }

    public static boolean isList(Object value) {
        return value instanceof List;
    }

    public static boolean isJavaPackage(Object target) {
        return JavaPackage.isJavaPackage(target);
    }

    public static boolean isJavaArray(Object value) {
        return value != null && value.getClass().isArray();
    }

    public static boolean isBigInt(Object target) {
        return target instanceof BigInt;
    }

    public static boolean isBigIntZero(BigInt a) {
        return BigInt.ZERO.equals(a);
    }

    public static boolean isBigIntNegativeVal(BigInt a) {
        return a != null && a.signum() == -1;
    }

    public static boolean isDoubleInInt32Range(double value) {
        return -2.147483648E9 <= value && value <= 2.147483647E9;
    }

    public static boolean isDoubleLargerThan2e32(double d) {
        return Math.abs(d) >= 4.294967296E9;
    }

    public static boolean isLongRepresentableAsInt32(long value) {
        return JSRuntime.longIsRepresentableAsInt(value);
    }

    public static boolean isDoubleRepresentableAsLong(double d) {
        return JSRuntime.doubleIsRepresentableAsLong(d);
    }

    public static boolean isDoubleSafeInteger(double d) {
        return JSRuntime.isSafeInteger(d);
    }

    public static boolean isIntArrayIndex(int i) {
        return JSRuntime.isArrayIndex(i);
    }

    public static boolean isLongArrayIndex(long i) {
        return JSRuntime.isArrayIndex(i);
    }

    public static boolean isArgumentsDisconnected(DynamicObject argumentsArray) {
        return JSArgumentsObject.hasDisconnectedIndices(argumentsArray);
    }

    public static Class<? extends Number> getJavaNumberClass(Object value) {
        if (value != null && JSGuards.isJavaNumber(value)) {
            return ((Number)value).getClass();
        }
        return null;
    }

    public static Class<?> getNonJSObjectClass(Object value) {
        if (value != null && !JSObject.isJSObject(value)) {
            return value.getClass();
        }
        return null;
    }

    public static Class<?> getNonDynamicObjectClass(Object value) {
        if (value != null && !(value instanceof DynamicObject)) {
            return value.getClass();
        }
        return null;
    }

    public static Class<?> getNonTruffleObjectClass(Object value) {
        if (value != null && !(value instanceof TruffleObject)) {
            return value.getClass();
        }
        return null;
    }

    public static JSClass getJSClassChecked(DynamicObject object) {
        if (JSObject.isJSObject(object)) {
            return JSObject.getJSClass(object);
        }
        return null;
    }

    public static JSClass getJSClassIfObject(DynamicObject object) {
        if (JSGuards.isJSObject(object)) {
            return JSObject.getJSClass(object);
        }
        return null;
    }

    public static boolean isReferenceEquals(Object a, Object b) {
        return a == b;
    }

    public static boolean isJavaPrimitive(Object value) {
        return JSRuntime.isJavaPrimitive(value);
    }

    public static boolean isJavaPrimitiveNumber(Object value) {
        return value instanceof Number && JSRuntime.isJavaPrimitive(value);
    }

    public static boolean isNullOrUndefined(Object value) {
        return JSObject.isDynamicObject(value) && JSGuards.isNullOrUndefined((DynamicObject)value);
    }

    public static boolean isNullOrUndefined(DynamicObject value) {
        return value.getShape().getObjectType() == Null.NULL_CLASS;
    }

    public static boolean isJSObjectShape(Shape shape) {
        return shape.getObjectType() instanceof JSClass;
    }

    public static boolean isTruffleJavaObject(TruffleObject object) {
        return JavaScriptLanguage.getCurrentEnv().isHostObject((Object)object);
    }

    public static boolean isArrayIndexLengthInRange(String str) {
        return JSRuntime.arrayIndexLengthInRange(str);
    }
}

