/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.control.AwaitNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;

public class AsyncIteratorNextNode
extends AwaitNode {
    @Node.Child
    private JSFunctionCallNode methodCallNode;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected AsyncIteratorNextNode(JSContext context, JavaScriptNode iterator, JSReadFrameSlotNode asyncContextNode, JSReadFrameSlotNode asyncResultNode) {
        super(context, iterator, asyncContextNode, asyncResultNode);
        this.methodCallNode = JSFunctionCallNode.createCall();
    }

    public static AwaitNode create(JSContext context, JavaScriptNode iterator, JSReadFrameSlotNode asyncContextNode, JSReadFrameSlotNode asyncResultNode) {
        return new AsyncIteratorNextNode(context, iterator, asyncContextNode, asyncResultNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        IteratorRecord iteratorRecord = (IteratorRecord)this.expression.execute(frame);
        Object next = iteratorRecord.getNextMethod();
        DynamicObject iterator = iteratorRecord.getIterator();
        Object nextResult = this.methodCallNode.executeCall(JSArguments.createZeroArg(iterator, next));
        this.setState(frame, 1);
        return this.suspendAwait(frame, nextResult);
    }

    @Override
    public Object resume(VirtualFrame frame) {
        int index = this.getStateAsInt(frame);
        if (index == 0) {
            return this.execute(frame);
        }
        this.setState(frame, 0);
        Object result = this.resumeAwait(frame);
        if (!JSObject.isJSObject(result)) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorIterResultNotAnObject(result, this);
        }
        return result;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return new AsyncIteratorNextNode(this.context, AsyncIteratorNextNode.cloneUninitialized(this.expression), AsyncIteratorNextNode.cloneUninitialized(this.readAsyncContextNode), AsyncIteratorNextNode.cloneUninitialized(this.readAsyncResultNode));
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == TruffleObject.class;
    }
}

