/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.RepeatableNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.instrumentation.NodeObjectDescriptor;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;

public abstract class JSConstantNode
extends JavaScriptNode
implements RepeatableNode {
    public static JSConstantNode create(Object value) {
        assert (!(value instanceof Long) && !(value instanceof BigInteger));
        if (value instanceof Integer) {
            return JSConstantNode.createInt((Integer)value);
        }
        if (value instanceof Double) {
            double doubleValue = (Double)value;
            if (JSRuntime.doubleIsRepresentableAsInt(doubleValue)) {
                return JSConstantNode.createInt((int)doubleValue);
            }
            return JSConstantNode.createDouble(doubleValue);
        }
        if (value instanceof Boolean) {
            return JSConstantNode.createBoolean((Boolean)value);
        }
        if (value instanceof String) {
            return JSConstantNode.createString((String)value);
        }
        if (value == Null.instance) {
            return JSConstantNode.createNull();
        }
        if (value == Undefined.instance) {
            return JSConstantNode.createUndefined();
        }
        if (value instanceof BigInt) {
            return JSConstantNode.createBigInt((BigInt)value);
        }
        if (JSObject.isDynamicObject(value)) {
            return new JSConstantJSObjectNode((DynamicObject)value);
        }
        return new JSConstantObjectNode(value);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.LiteralTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public Object getNodeObject() {
        NodeObjectDescriptor descriptor = JSTags.createNodeObjectDescriptor();
        if (this instanceof JSConstantDoubleNode || this instanceof JSConstantIntegerNode) {
            descriptor.addProperty("type", JSTags.LiteralTag.Type.NumericLiteral.name());
        } else if (this instanceof JSConstantBooleanNode) {
            descriptor.addProperty("type", JSTags.LiteralTag.Type.BooleanLiteral.name());
        } else if (this instanceof JSConstantStringNode) {
            descriptor.addProperty("type", JSTags.LiteralTag.Type.StringLiteral.name());
        } else if (this instanceof JSConstantNullNode) {
            descriptor.addProperty("type", JSTags.LiteralTag.Type.NullLiteral.name());
        } else if (this instanceof JSConstantUndefinedNode) {
            descriptor.addProperty("type", JSTags.LiteralTag.Type.UndefinedLiteral.name());
        }
        return descriptor;
    }

    public static JSConstantNode createUndefined() {
        return new JSConstantUndefinedNode();
    }

    public static JSConstantNode createNull() {
        return new JSConstantNullNode();
    }

    public static JSConstantNode createInt(int value) {
        return new JSConstantIntegerNode(value);
    }

    public static JSConstantNode createBigInt(BigInt value) {
        return new JSConstantBigIntNode(value);
    }

    public static JSConstantNode createDouble(double value) {
        return new JSConstantDoubleNode(value);
    }

    public static JSConstantNode createConstantNumericUnit() {
        return new JSConstantNumericUnitNode();
    }

    public static JSConstantNode createBoolean(boolean value) {
        return new JSConstantBooleanNode(value);
    }

    public static JSConstantNode createString(String value) {
        return new JSConstantStringNode(value);
    }

    public abstract Object getValue();

    @Override
    public final void executeVoid(VirtualFrame frame) {
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return this.copy();
    }

    @CompilerDirectives.TruffleBoundary
    public Map<String, Object> getDebugProperties() {
        Map map = super.getDebugProperties();
        map.put("value", this.getValue() instanceof String ? JSRuntime.quote((String)this.getValue()) : this.getValue());
        return map;
    }

    @Override
    public String expressionToString() {
        Object value = this.getValue();
        if (JSRuntime.isJSPrimitive(value)) {
            String string = JSRuntime.toString(value);
            if (JSRuntime.isString(value)) {
                return JSRuntime.quote(string);
            }
            return string;
        }
        return null;
    }

    public static final class JSConstantStringNode
    extends JSConstantNode {
        private final String stringValue;

        private JSConstantStringNode(String str) {
            this.stringValue = Objects.requireNonNull(str);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.stringValue;
        }

        @Override
        public String executeString(VirtualFrame frame) {
            return this.stringValue;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == String.class;
        }

        @Override
        public Object getValue() {
            return this.stringValue;
        }
    }

    public static final class JSConstantUndefinedNode
    extends JSConstantNode {
        private JSConstantUndefinedNode() {
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return Undefined.instance;
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frame) {
            return Undefined.instance;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == DynamicObject.class;
        }

        @Override
        public Object getValue() {
            return Undefined.instance;
        }
    }

    public static final class JSConstantNullNode
    extends JSConstantNode {
        private JSConstantNullNode() {
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return Null.instance;
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frame) {
            return Null.instance;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == DynamicObject.class;
        }

        @Override
        public Object getValue() {
            return Null.instance;
        }
    }

    private static final class JSConstantJSObjectNode
    extends JSConstantNode {
        private final DynamicObject objectValue;

        private JSConstantJSObjectNode(DynamicObject obj) {
            this.objectValue = obj;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.objectValue;
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frame) {
            return this.objectValue;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == DynamicObject.class;
        }

        @Override
        public Object getValue() {
            return this.objectValue;
        }

        @Override
        public boolean hasTag(Class<? extends Tag> tag) {
            if (tag == JSTags.LiteralTag.class) {
                return false;
            }
            return super.hasTag(tag);
        }
    }

    private static final class JSConstantObjectNode
    extends JSConstantNode {
        private final Object objectValue;

        private JSConstantObjectNode(Object obj) {
            this.objectValue = obj;
            assert (!(obj instanceof JavaScriptNode)) : "must be JS value";
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.objectValue;
        }

        @Override
        public Object getValue() {
            return this.objectValue;
        }

        @Override
        public boolean hasTag(Class<? extends Tag> tag) {
            if (tag == JSTags.LiteralTag.class) {
                return false;
            }
            return super.hasTag(tag);
        }
    }

    public static final class JSConstantBooleanNode
    extends JSConstantNode {
        private final boolean booleanValue;

        private JSConstantBooleanNode(boolean value) {
            this.booleanValue = value;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == Boolean.TYPE;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.booleanValue;
        }

        @Override
        public double executeDouble(VirtualFrame frame) {
            return this.booleanValue ? 1.0 : 0.0;
        }

        @Override
        public boolean executeBoolean(VirtualFrame frame) {
            return this.booleanValue;
        }

        @Override
        public Object getValue() {
            return this.booleanValue;
        }
    }

    public static final class JSConstantBigIntNode
    extends JSConstantNode {
        private final BigInt bigIntValue;

        private JSConstantBigIntNode(BigInt value) {
            this.bigIntValue = value;
        }

        @Override
        public boolean isInstrumentable() {
            return false;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.bigIntValue;
        }

        public BigInt executeBigInt(VirtualFrame frame) {
            return this.bigIntValue;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == BigInt.class;
        }

        @Override
        public Object getValue() {
            return this.bigIntValue;
        }
    }

    public static final class JSConstantNumericUnitNode
    extends JSConstantNode {
        private JSConstantNumericUnitNode() {
        }

        @Override
        public boolean isInstrumentable() {
            return false;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            throw Errors.shouldNotReachHere();
        }

        @Override
        public Object getValue() {
            throw Errors.shouldNotReachHere();
        }
    }

    public static final class JSConstantIntegerNode
    extends JSConstantNode {
        private final int intValue;

        private JSConstantIntegerNode(int value) {
            this.intValue = value;
        }

        @Override
        public int executeInt(VirtualFrame frame) {
            return this.intValue;
        }

        @Override
        public double executeDouble(VirtualFrame frame) {
            return this.intValue;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.intValue;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == Integer.TYPE;
        }

        @Override
        public Object getValue() {
            return this.intValue;
        }
    }

    public static final class JSConstantDoubleNode
    extends JSConstantNode {
        private final double doubleValue;

        private JSConstantDoubleNode(double doubleValue) {
            this.doubleValue = doubleValue;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.doubleValue;
        }

        @Override
        public double executeDouble(VirtualFrame frame) {
            return this.doubleValue;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == Double.TYPE;
        }

        @Override
        public Object getValue() {
            return this.doubleValue;
        }
    }
}

