/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class ConstructorResultNode
extends JavaScriptNode {
    @Node.Child
    private JavaScriptNode bodyNode;
    @Node.Child
    private JavaScriptNode thisNode;
    private final boolean derived;
    @Node.Child
    private IsObjectNode isObjectNode;
    private final ConditionProfile isObject = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isNotUndefined = ConditionProfile.createBinaryProfile();

    private ConstructorResultNode(boolean derived, JavaScriptNode bodyNode, JavaScriptNode thisNode) {
        this.bodyNode = bodyNode;
        this.derived = derived;
        this.thisNode = thisNode;
        this.isObjectNode = IsObjectNode.create();
    }

    public static JavaScriptNode createBase(JavaScriptNode bodyNode, JavaScriptNode thisNode) {
        return new ConstructorResultNode(false, bodyNode, thisNode);
    }

    public static JavaScriptNode createDerived(JavaScriptNode bodyNode, JavaScriptNode thisNode) {
        return new ConstructorResultNode(true, bodyNode, thisNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object result = this.bodyNode.execute(frame);
        if (this.isObject.profile(this.isObjectNode.executeBoolean(result))) {
            return result;
        }
        if (this.derived && this.isNotUndefined.profile(result != Undefined.instance)) {
            throw Errors.createTypeError("constructor result not as expected").useCallerRealm();
        }
        Object thisObject = this.thisNode.execute(frame);
        assert (thisObject != JSFunction.CONSTRUCT);
        assert (!this.derived || JSRuntime.isObject(thisObject) || thisObject instanceof Symbol);
        return thisObject;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return new ConstructorResultNode(this.derived, ConstructorResultNode.cloneUninitialized(this.bodyNode), ConstructorResultNode.cloneUninitialized(this.thisNode));
    }
}

