/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.unary.IsConstructorNode;
import com.oracle.truffle.js.nodes.unary.RequireConstructorNodeGen;
import com.oracle.truffle.js.runtime.Errors;

public abstract class RequireConstructorNode
extends JavaScriptNode {
    @Node.Child
    @Executed
    JavaScriptNode argumentNode;
    @Node.Child
    @Executed(with={"argumentNode"})
    IsConstructorNode isConstructorNode;

    protected RequireConstructorNode(JavaScriptNode argumentNode) {
        this.argumentNode = argumentNode;
        this.isConstructorNode = IsConstructorNode.create();
    }

    @Specialization(guards={"isConstructor"})
    static Object constructor(Object constructor, boolean isConstructor) {
        return constructor;
    }

    @Fallback
    final Object typeError(Object constructor, boolean isConstructor) {
        throw Errors.createTypeError("Super constructor is not a constructor", this);
    }

    public static JavaScriptNode create(JavaScriptNode argument) {
        return RequireConstructorNodeGen.create(argument);
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return RequireConstructorNode.create(RequireConstructorNode.cloneUninitialized(this.argumentNode));
    }
}

