/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ArrayCopy;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;

public final class ZeroBasedDoubleArray
extends AbstractDoubleArray {
    private static final ZeroBasedDoubleArray ZERO_BASED_DOUBLE_ARRAY = new ZeroBasedDoubleArray(0, ZeroBasedDoubleArray.createCache());

    public static ZeroBasedDoubleArray makeZeroBasedDoubleArray(DynamicObject object, int length, int usedLength, double[] array, int integrityLevel) {
        ZeroBasedDoubleArray arrayType = (ZeroBasedDoubleArray)ZeroBasedDoubleArray.createZeroBasedDoubleArray().setIntegrityLevel(integrityLevel);
        JSAbstractArray.arraySetLength(object, length);
        JSAbstractArray.arraySetUsedLength(object, usedLength);
        JSAbstractArray.arraySetArray(object, array);
        return arrayType;
    }

    public static ZeroBasedDoubleArray createZeroBasedDoubleArray() {
        return ZERO_BASED_DOUBLE_ARRAY;
    }

    private ZeroBasedDoubleArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    public double getInBoundsFastDouble(DynamicObject object, int index, boolean condition) {
        return ZeroBasedDoubleArray.getArray(object, condition)[index];
    }

    @Override
    public void setInBoundsFast(DynamicObject object, int index, double value, boolean condition) {
        ZeroBasedDoubleArray.getArray((DynamicObject)object, (boolean)condition)[index] = value;
        if (JSTruffleOptions.TraceArrayWrites) {
            this.traceWriteValue("InBoundsFast", index, value);
        }
    }

    @Override
    public boolean isSupported(DynamicObject object, long index, boolean condition) {
        return ZeroBasedDoubleArray.isSupportedZeroBased(object, (int)index, condition);
    }

    @Override
    protected int prepareInBoundsFast(DynamicObject object, long index, boolean condition) {
        return (int)index;
    }

    @Override
    protected int prepareInBounds(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        ZeroBasedDoubleArray.prepareInBoundsZeroBased(object, index, condition, profile);
        return index;
    }

    @Override
    protected int prepareSupported(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        this.prepareSupportedZeroBased(object, index, condition, profile);
        return index;
    }

    @Override
    protected void setLengthLess(DynamicObject object, long length, boolean condition, ScriptArray.ProfileHolder profile) {
        this.setLengthLessZeroBased(object, length, condition, profile);
    }

    @Override
    public Object[] toArray(DynamicObject object) {
        return this.toArrayZeroBased(object);
    }

    @Override
    public ZeroBasedObjectArray toObject(DynamicObject object, long index, Object value, boolean condition) {
        double[] array = ZeroBasedDoubleArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object, condition);
        Object[] doubleCopy = ArrayCopy.doubleToObject(array, 0, usedLength);
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, length, usedLength, doubleCopy, this.integrityLevel);
        if (JSTruffleOptions.TraceArrayTransitions) {
            ZeroBasedDoubleArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ContiguousDoubleArray toContiguous(DynamicObject object, long index, Object value, boolean condition) {
        double[] array = ZeroBasedDoubleArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object, condition);
        ContiguousDoubleArray newArray = ContiguousDoubleArray.makeContiguousDoubleArray(object, length, array, 0L, 0, usedLength, this.integrityLevel);
        if (JSTruffleOptions.TraceArrayTransitions) {
            ZeroBasedDoubleArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public HolesDoubleArray toHoles(DynamicObject object, long index, Object value, boolean condition) {
        double[] array = ZeroBasedDoubleArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object, condition);
        HolesDoubleArray newArray = HolesDoubleArray.makeHolesDoubleArray(object, length, array, 0L, 0, usedLength, 0, this.integrityLevel);
        if (JSTruffleOptions.TraceArrayTransitions) {
            ZeroBasedDoubleArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public long firstElementIndex(DynamicObject object, boolean condition) {
        return 0L;
    }

    @Override
    public long lastElementIndex(DynamicObject object, boolean condition) {
        return ZeroBasedDoubleArray.getUsedLength(object, condition) - 1;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        double[] array = ZeroBasedDoubleArray.getArray(object);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object);
        System.arraycopy(array, (int)end, array, (int)start, Math.max(0, (int)((long)usedLength - end)));
        return this;
    }

    @Override
    public ScriptArray addRangeImpl(DynamicObject object, long offset, int size) {
        return this.addRangeImplZeroBased(object, offset, size);
    }

    @Override
    public boolean hasHoles(DynamicObject object, boolean condition) {
        int length = this.lengthInt(object, condition);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object, condition);
        return usedLength < length;
    }

    @Override
    protected ZeroBasedDoubleArray withIntegrityLevel(int newIntegrityLevel) {
        return new ZeroBasedDoubleArray(newIntegrityLevel, this.cache);
    }

    @Override
    public long nextElementIndex(DynamicObject object, long index, boolean condition) {
        return this.nextElementIndexZeroBased(object, index, condition);
    }
}

