/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNode;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.InteropArray;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;

@ExportLibrary(value=InteropLibrary.class, receiverType=DynamicObject.class)
public abstract class JSClass
extends ObjectType {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final PropertyDescriptor FREEZE_ACC_DESC = PropertyDescriptor.createEmpty();
    private static final PropertyDescriptor FREEZE_DATA_DESC;

    protected JSClass() {
    }

    @CompilerDirectives.TruffleBoundary
    public abstract DynamicObject getPrototypeOf(DynamicObject var1);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean setPrototypeOf(DynamicObject var1, DynamicObject var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean isExtensible(DynamicObject var1);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean preventExtensions(DynamicObject var1);

    @CompilerDirectives.TruffleBoundary
    public abstract PropertyDescriptor getOwnProperty(DynamicObject var1, Object var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean defineOwnProperty(DynamicObject var1, Object var2, PropertyDescriptor var3, boolean var4);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasProperty(DynamicObject var1, Object var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasProperty(DynamicObject var1, long var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasOwnProperty(DynamicObject var1, Object var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasOwnProperty(DynamicObject var1, long var2);

    public final Object get(DynamicObject thisObj, Object key) {
        return JSRuntime.nullToUndefined(this.getHelper(thisObj, (Object)thisObj, key));
    }

    public Object get(DynamicObject thisObj, long index) {
        return JSRuntime.nullToUndefined(this.getHelper(thisObj, (Object)thisObj, index));
    }

    @CompilerDirectives.TruffleBoundary
    public abstract Object getHelper(DynamicObject var1, Object var2, Object var3);

    @CompilerDirectives.TruffleBoundary
    public abstract Object getHelper(DynamicObject var1, Object var2, long var3);

    @CompilerDirectives.TruffleBoundary
    public abstract Object getOwnHelper(DynamicObject var1, Object var2, Object var3);

    @CompilerDirectives.TruffleBoundary
    public abstract Object getOwnHelper(DynamicObject var1, Object var2, long var3);

    @CompilerDirectives.TruffleBoundary
    public abstract Object getMethodHelper(DynamicObject var1, Object var2, Object var3);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean set(DynamicObject var1, Object var2, Object var3, Object var4, boolean var5);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean set(DynamicObject var1, long var2, Object var4, Object var5, boolean var6);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean setOwn(DynamicObject var1, Object var2, Object var3, Object var4, boolean var5);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean setOwn(DynamicObject var1, long var2, Object var4, Object var5, boolean var6);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean delete(DynamicObject var1, Object var2, boolean var3);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean delete(DynamicObject var1, long var2, boolean var4);

    public final List<Object> ownPropertyKeys(DynamicObject obj) {
        return this.getOwnPropertyKeys(obj, true, true);
    }

    @CompilerDirectives.TruffleBoundary
    public abstract List<Object> getOwnPropertyKeys(DynamicObject var1, boolean var2, boolean var3);

    @CompilerDirectives.TruffleBoundary
    public static List<Object> filterOwnPropertyKeys(List<Object> ownPropertyKeys, boolean strings, boolean symbols) {
        if (strings && symbols) {
            return ownPropertyKeys;
        }
        ArrayList<Object> names = new ArrayList<Object>();
        for (Object key : ownPropertyKeys) {
            if (!symbols && key instanceof Symbol || !strings && key instanceof String) continue;
            names.add(key);
        }
        return names;
    }

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasOnlyShapeProperties(DynamicObject var1);

    @CompilerDirectives.TruffleBoundary
    public abstract String getClassName(DynamicObject var1);

    @CompilerDirectives.TruffleBoundary
    public abstract String toString();

    @CompilerDirectives.TruffleBoundary
    public String defaultToString(DynamicObject object) {
        JSContext context = JSObject.getJSContext(object);
        if (context.getEcmaScriptVersion() <= 5) {
            return this.formatToString(this.getClassName(object));
        }
        String result = this.getToStringTag(object);
        return this.formatToString(result);
    }

    protected String getToStringTag(DynamicObject object) {
        Object toStringTag;
        String result = null;
        if (JSRuntime.isObject(object) && JSRuntime.isString(toStringTag = JSObject.get(object, (Object)Symbol.SYMBOL_TO_STRING_TAG))) {
            result = JSRuntime.toStringIsString(toStringTag);
        }
        if (result == null) {
            result = this.getBuiltinToStringTag(object);
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public String getBuiltinToStringTag(DynamicObject object) {
        return this.getClassName(object);
    }

    @CompilerDirectives.TruffleBoundary
    protected String formatToString(String object) {
        return "[object " + object + "]";
    }

    @CompilerDirectives.TruffleBoundary
    public abstract String safeToString(DynamicObject var1, int var2);

    public final boolean isInstance(DynamicObject object) {
        return JSClass.isInstance(object, this);
    }

    public final boolean isInstance(Object object) {
        return JSClass.isInstance(object, this);
    }

    public static boolean isInstance(Object object, JSClass jsclass) {
        return JSObject.isDynamicObject(object) && JSClass.isInstance((DynamicObject)object, jsclass);
    }

    public static boolean isInstance(DynamicObject object, JSClass jsclass) {
        return object.getShape().getObjectType() == jsclass;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean testIntegrityLevel(DynamicObject obj, boolean frozen) {
        assert (JSRuntime.isObject(obj));
        boolean status = this.isExtensible(obj);
        if (status) {
            return false;
        }
        for (Object key : this.ownPropertyKeys(obj)) {
            PropertyDescriptor desc = this.getOwnProperty(obj, key);
            if (desc == null) continue;
            if (desc.getConfigurable()) {
                return false;
            }
            if (!frozen || !desc.isDataDescriptor() || !desc.getWritable()) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean setIntegrityLevel(DynamicObject obj, boolean freeze) {
        assert (JSRuntime.isObject(obj));
        if (!this.preventExtensions(obj)) {
            return false;
        }
        List<Object> keys = this.ownPropertyKeys(obj);
        if (freeze) {
            for (Object t : keys) {
                PropertyDescriptor currentDesc = this.getOwnProperty(obj, t);
                if (currentDesc == null) continue;
                PropertyDescriptor newDesc = null;
                newDesc = currentDesc.isAccessorDescriptor() ? FREEZE_ACC_DESC : FREEZE_DATA_DESC;
                JSRuntime.definePropertyOrThrow(obj, t, newDesc);
            }
        } else {
            for (Object t : keys) {
                JSRuntime.definePropertyOrThrow(obj, t, FREEZE_ACC_DESC);
            }
        }
        return true;
    }

    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        throw Errors.shouldNotReachHere(((Object)((Object)this)).getClass().getName());
    }

    public abstract boolean usesOrdinaryGetOwnProperty();

    public abstract boolean usesOrdinaryIsExtensible();

    public final Class<?> dispatch() {
        return JSClass.class;
    }

    @ExportMessage
    static boolean isNull(DynamicObject target) {
        return JSShape.getJSClassNoCast(target.getShape()) == Null.NULL_CLASS;
    }

    @ExportMessage
    static boolean hasMembers(DynamicObject target) {
        return JSRuntime.isObject(target);
    }

    private static void ensureHasMembers(DynamicObject target) throws UnsupportedMessageException {
        if (!JSClass.hasMembers(target)) {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static Object readMember(DynamicObject target, String key, @CachedLanguage TruffleLanguage.LanguageReference<JavaScriptLanguage> languageRef, @Cached(value="create(languageRef.get().getJSContext())", uncached="getUncachedRead()") ReadElementNode readNode, @Cached.Shared(value="exportValue") @Cached ExportValueNode exportNode) throws UnknownIdentifierException, UnsupportedMessageException {
        JSClass.ensureHasMembers(target);
        Object result = readNode == null ? JSObject.getOrDefault(target, key, (Object)target, null, JSClassProfile.getUncached()) : readNode.executeWithTargetAndIndexOrDefault(target, key, null);
        if (result == null) {
            throw UnknownIdentifierException.create((String)key);
        }
        return exportNode.executeWithTarget(result, target);
    }

    @ExportMessage
    static boolean isMemberReadable(DynamicObject target, String key, @Cached.Shared(value="keyInfo") @Cached KeyInfoNode keyInfo) {
        if (!JSClass.hasMembers(target)) {
            return false;
        }
        return keyInfo.execute(target, key, 1);
    }

    @ExportMessage
    static void writeMember(DynamicObject target, String key, Object value, @Cached.Shared(value="keyInfo") @Cached KeyInfoNode keyInfo, @Cached.Shared(value="importValue") @Cached JSForeignToJSTypeNode castValueNode, @CachedLanguage TruffleLanguage.LanguageReference<JavaScriptLanguage> languageRef, @Cached(value="createCachedInterop(languageRef)", uncached="getUncachedWrite()") WriteElementNode writeNode) throws UnknownIdentifierException, UnsupportedMessageException {
        JSClass.ensureHasMembers(target);
        if (!keyInfo.execute(target, key, 6)) {
            throw UnknownIdentifierException.create((String)key);
        }
        Object importedValue = castValueNode.executeWithTarget(value);
        if (writeNode == null) {
            JSObject.set(target, key, importedValue, true);
        } else {
            writeNode.executeWithTargetAndIndexAndValue((Object)target, key, importedValue);
        }
    }

    @ExportMessage
    static boolean isMemberModifiable(DynamicObject target, String key, @Cached.Shared(value="keyInfo") @Cached KeyInfoNode keyInfo) {
        if (!JSClass.hasMembers(target)) {
            return false;
        }
        return keyInfo.execute(target, key, 2);
    }

    @ExportMessage
    static boolean isMemberInsertable(DynamicObject target, String key, @Cached.Shared(value="keyInfo") @Cached KeyInfoNode keyInfo) {
        if (!JSClass.hasMembers(target)) {
            return false;
        }
        return keyInfo.execute(target, key, 4);
    }

    @ExportMessage
    static void removeMember(DynamicObject target, String key) throws UnsupportedMessageException {
        JSClass.ensureHasMembers(target);
        JSObject.delete(target, key, true);
    }

    @ExportMessage
    static boolean isMemberRemovable(DynamicObject target, String key, @Cached.Shared(value="keyInfo") @Cached KeyInfoNode keyInfo) {
        if (!JSClass.hasMembers(target)) {
            return false;
        }
        return keyInfo.execute(target, key, 16);
    }

    @ExportMessage
    static boolean hasArrayElements(DynamicObject target) {
        ObjectType objectType = JSShape.getJSClassNoCast(target.getShape());
        return objectType instanceof JSAbstractArray || objectType instanceof JSArrayBufferView;
    }

    @ExportMessage
    static Object readArrayElement(DynamicObject target, long index, @CachedLanguage TruffleLanguage.LanguageReference<JavaScriptLanguage> languageRef, @Cached(value="create(languageRef.get().getJSContext())", uncached="getUncachedRead()") ReadElementNode readNode, @Cached.Shared(value="exportValue") @Cached ExportValueNode exportNode) throws InvalidArrayIndexException, UnsupportedMessageException {
        if (!JSClass.hasArrayElements(target)) {
            throw UnsupportedMessageException.create();
        }
        Object result = readNode == null ? JSObject.getOrDefault(target, index, (Object)target, null, JSClassProfile.getUncached()) : readNode.executeWithTargetAndIndexOrDefault(target, index, null);
        if (result == null) {
            throw InvalidArrayIndexException.create((long)index);
        }
        return exportNode.executeWithTarget(result, target);
    }

    @ExportMessage
    static boolean isArrayElementReadable(DynamicObject target, long index, @Cached.Shared(value="keyInfo") @Cached KeyInfoNode keyInfo) {
        return JSClass.hasArrayElements(target) && keyInfo.execute(target, index, 1);
    }

    @ExportMessage
    static void writeArrayElement(DynamicObject target, long index, Object value, @Cached.Shared(value="keyInfo") @Cached KeyInfoNode keyInfo, @Cached.Shared(value="importValue") @Cached JSForeignToJSTypeNode castValueNode, @CachedLanguage TruffleLanguage.LanguageReference<JavaScriptLanguage> languageRef, @Cached(value="createCachedInterop(languageRef)", uncached="getUncachedWrite()") WriteElementNode writeNode) throws InvalidArrayIndexException, UnsupportedMessageException {
        if (!JSClass.hasArrayElements(target)) {
            throw UnsupportedMessageException.create();
        }
        if (!keyInfo.execute(target, index, 6)) {
            throw InvalidArrayIndexException.create((long)index);
        }
        Object importedValue = castValueNode.executeWithTarget(value);
        if (writeNode == null) {
            JSObject.set(target, index, importedValue, true);
        } else {
            writeNode.executeWithTargetAndIndexAndValue((Object)target, index, importedValue);
        }
    }

    @ExportMessage
    static boolean isArrayElementModifiable(DynamicObject target, long index, @Cached.Shared(value="keyInfo") @Cached KeyInfoNode keyInfo) {
        return JSClass.hasArrayElements(target) && keyInfo.execute(target, index, 2);
    }

    @ExportMessage
    static boolean isArrayElementInsertable(DynamicObject target, long index, @Cached.Shared(value="keyInfo") @Cached KeyInfoNode keyInfo) {
        return JSClass.hasArrayElements(target) && keyInfo.execute(target, index, 4);
    }

    @ExportMessage
    static void removeArrayElement(DynamicObject target, long index) throws UnsupportedMessageException {
        if (!JSClass.hasArrayElements(target)) {
            throw UnsupportedMessageException.create();
        }
        JSObject.delete(target, index, true);
    }

    @ExportMessage
    static boolean isArrayElementRemovable(DynamicObject target, long index, @Cached.Shared(value="keyInfo") @Cached KeyInfoNode keyInfo) {
        return JSClass.hasArrayElements(target) && keyInfo.execute(target, index, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    static Object execute(DynamicObject target, Object[] args, @CachedLanguage JavaScriptLanguage language, @CachedContext(value=JavaScriptLanguage.class) JSRealm realm, @Cached JSInteropExecuteNode callNode, @Cached.Shared(value="exportValue") @Cached ExportValueNode exportNode) throws UnsupportedMessageException {
        language.interopBoundaryEnter(realm);
        try {
            Object result = callNode.execute(target, Undefined.instance, args);
            Object object = exportNode.executeWithTarget(result, Undefined.instance);
            return object;
        }
        finally {
            language.interopBoundaryExit(realm);
        }
    }

    @ExportMessage
    static boolean isExecutable(DynamicObject target, @Cached IsCallableNode isCallable) {
        return isCallable.executeBoolean(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    static Object instantiate(DynamicObject target, Object[] args, @CachedLanguage JavaScriptLanguage language, @CachedContext(value=JavaScriptLanguage.class) JSRealm realm, @Cached JSInteropInstantiateNode callNode, @Cached.Shared(value="exportValue") @Cached ExportValueNode exportNode) throws UnsupportedMessageException {
        language.interopBoundaryEnter(realm);
        try {
            Object result = callNode.execute(target, args);
            Object object = exportNode.executeWithTarget(result, Undefined.instance);
            return object;
        }
        finally {
            language.interopBoundaryExit(realm);
        }
    }

    @ExportMessage
    static boolean isInstantiable(DynamicObject target) {
        return JSRuntime.isConstructor(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    static Object invokeMember(DynamicObject target, String id, Object[] args, @CachedLanguage JavaScriptLanguage language, @CachedContext(value=JavaScriptLanguage.class) JSRealm realm, @Cached JSInteropInvokeNode callNode, @Cached.Shared(value="exportValue") @Cached ExportValueNode exportNode) throws UnsupportedMessageException, UnknownIdentifierException {
        JSClass.ensureHasMembers(target);
        language.interopBoundaryEnter(realm);
        try {
            Object result = callNode.execute(target, id, args);
            Object object = exportNode.executeWithTarget(result, target);
            return object;
        }
        finally {
            language.interopBoundaryExit(realm);
        }
    }

    @ExportMessage
    static boolean isMemberInvocable(DynamicObject target, String key, @Cached.Shared(value="keyInfo") @Cached KeyInfoNode keyInfo) {
        if (!JSClass.hasMembers(target)) {
            return false;
        }
        return keyInfo.execute(target, key, 8);
    }

    @ExportMessage
    static boolean hasMemberReadSideEffects(DynamicObject target, String key, @Cached.Shared(value="keyInfo") @Cached KeyInfoNode keyInfo) {
        if (!JSClass.hasMembers(target)) {
            return false;
        }
        return keyInfo.execute(target, key, 32);
    }

    @ExportMessage
    static boolean hasMemberWriteSideEffects(DynamicObject target, String key, @Cached.Shared(value="keyInfo") @Cached KeyInfoNode keyInfo) {
        if (!JSClass.hasMembers(target)) {
            return false;
        }
        return keyInfo.execute(target, key, 64);
    }

    @ExportMessage
    static boolean isString(DynamicObject target) {
        JSClass builtinClass = JSObject.getJSClass(target);
        return builtinClass == JSString.INSTANCE;
    }

    @ExportMessage
    static String asString(DynamicObject target) throws UnsupportedMessageException {
        JSClass builtinClass = JSObject.getJSClass(target);
        if (builtinClass == JSString.INSTANCE) {
            return JSString.getString(target);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean isBoolean(DynamicObject target) {
        JSClass builtinClass = JSObject.getJSClass(target);
        return builtinClass == JSBoolean.INSTANCE;
    }

    @ExportMessage
    static boolean asBoolean(DynamicObject target) throws UnsupportedMessageException {
        JSClass builtinClass = JSObject.getJSClass(target);
        if (builtinClass == JSBoolean.INSTANCE) {
            return JSBoolean.valueOf(target);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static boolean isNumber(DynamicObject target) {
        JSClass builtinClass = JSObject.getJSClass(target);
        return builtinClass == JSNumber.INSTANCE;
    }

    @ExportMessage
    static boolean fitsInByte(DynamicObject target, @Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) {
        return JSClass.isNumber(target) && numberLib.fitsInByte((Object)JSNumber.valueOf(target));
    }

    @ExportMessage
    static boolean fitsInShort(DynamicObject target, @Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) {
        return JSClass.isNumber(target) && numberLib.fitsInShort((Object)JSNumber.valueOf(target));
    }

    @ExportMessage
    static boolean fitsInInt(DynamicObject target, @Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) {
        return JSClass.isNumber(target) && numberLib.fitsInInt((Object)JSNumber.valueOf(target));
    }

    @ExportMessage
    static boolean fitsInLong(DynamicObject target, @Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) {
        return JSClass.isNumber(target) && numberLib.fitsInLong((Object)JSNumber.valueOf(target));
    }

    @ExportMessage
    static boolean fitsInFloat(DynamicObject target, @Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) {
        return JSClass.isNumber(target) && numberLib.fitsInFloat((Object)JSNumber.valueOf(target));
    }

    @ExportMessage
    static boolean fitsInDouble(DynamicObject target, @Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) {
        return JSClass.isNumber(target) && numberLib.fitsInDouble((Object)JSNumber.valueOf(target));
    }

    @ExportMessage
    static byte asByte(DynamicObject target, @Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) throws UnsupportedMessageException {
        if (JSClass.fitsInByte(target, numberLib)) {
            return numberLib.asByte((Object)JSNumber.valueOf(target));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static short asShort(DynamicObject target, @Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) throws UnsupportedMessageException {
        if (JSClass.fitsInShort(target, numberLib)) {
            return numberLib.asShort((Object)JSNumber.valueOf(target));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static int asInt(DynamicObject target, @Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) throws UnsupportedMessageException {
        if (JSClass.fitsInInt(target, numberLib)) {
            return numberLib.asInt((Object)JSNumber.valueOf(target));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static long asLong(DynamicObject target, @Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) throws UnsupportedMessageException {
        if (JSClass.fitsInLong(target, numberLib)) {
            return numberLib.asLong((Object)JSNumber.valueOf(target));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static float asFloat(DynamicObject target, @Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) throws UnsupportedMessageException {
        if (JSClass.fitsInFloat(target, numberLib)) {
            return numberLib.asFloat((Object)JSNumber.valueOf(target));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static double asDouble(DynamicObject target, @Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) throws UnsupportedMessageException {
        if (JSClass.fitsInDouble(target, numberLib)) {
            return numberLib.asDouble((Object)JSNumber.valueOf(target));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isDate"), @ExportMessage(name="isTime"), @ExportMessage(name="isTimeZone")})
    static boolean isDate(DynamicObject target) {
        return JSDate.isValidDate(target);
    }

    @ExportMessage
    static Instant asInstant(DynamicObject target) throws UnsupportedMessageException {
        if (JSClass.isDate(target)) {
            return JSDate.asInstant(target);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static LocalDate asDate(DynamicObject target, @CachedContext(value=JavaScriptLanguage.class) TruffleLanguage.ContextReference<JSRealm> contextRef) throws UnsupportedMessageException {
        if (JSClass.isDate(target)) {
            return JSDate.asLocalDate(target, (JSRealm)contextRef.get());
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static LocalTime asTime(DynamicObject target, @CachedContext(value=JavaScriptLanguage.class) TruffleLanguage.ContextReference<JSRealm> contextRef) throws UnsupportedMessageException {
        if (JSClass.isDate(target)) {
            return JSDate.asLocalTime(target, (JSRealm)contextRef.get());
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    static ZoneId asTimeZone(DynamicObject target, @CachedContext(value=JavaScriptLanguage.class) TruffleLanguage.ContextReference<JSRealm> contextRef) throws UnsupportedMessageException {
        if (JSClass.isDate(target)) {
            return ((JSRealm)contextRef.get()).getLocalTimeZoneId();
        }
        throw UnsupportedMessageException.create();
    }

    static ReadElementNode getUncachedRead() {
        return null;
    }

    static WriteElementNode getUncachedWrite() {
        return null;
    }

    static {
        FREEZE_ACC_DESC.setConfigurable(false);
        FREEZE_DATA_DESC = PropertyDescriptor.createEmpty();
        FREEZE_DATA_DESC.setConfigurable(false);
        FREEZE_DATA_DESC.setWritable(false);
    }

    @ExportMessage
    @ImportStatic(value={JSGuards.class})
    static abstract class GetArraySize {
        GetArraySize() {
        }

        @Specialization(guards={"isJSArray(target)"})
        static long array(DynamicObject target) {
            return JSArray.arrayGetLength(target);
        }

        @Specialization(guards={"isJSArrayBufferView(target)"})
        static long typedArray(DynamicObject target) {
            return JSArrayBufferView.typedArrayGetLength(target);
        }

        @Specialization(guards={"isJSArgumentsObject(target)"})
        static long argumentsObject(DynamicObject target) {
            return JSRuntime.toInteger(JSObject.get(target, (Object)"length"));
        }

        @Fallback
        static long unsupported(DynamicObject target) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    @ImportStatic(value={JSGuards.class, JSObject.class})
    static abstract class GetMembers {
        GetMembers() {
        }

        @Specialization(guards={"isJSFastArray(target)"})
        static Object fastArray(DynamicObject target, boolean internal) {
            return InteropArray.create(GetMembers.filterEnumerableNames(target, JSBuiltinObject.ordinaryOwnPropertyKeys(target), JSObject.getJSClass(target)));
        }

        @Specialization(guards={"isJSArray(target)", "!isJSFastArray(target)"})
        static Object slowArray(DynamicObject target, boolean internal) {
            return InteropArray.create(GetMembers.filterEnumerableNames(target, JSObject.ownPropertyKeys(target), JSObject.getJSClass(target)));
        }

        @Specialization(guards={"isJSArrayBufferView(target)"})
        static Object typedArray(DynamicObject target, boolean internal) {
            return GetMembers.fastArray(target, internal);
        }

        @Specialization(guards={"isJSArgumentsObject(target)"})
        static Object argumentsObject(DynamicObject target, boolean internal) {
            return GetMembers.slowArray(target, internal);
        }

        @Specialization(guards={"cachedJSClass != null", "getJSClass(target) == cachedJSClass"})
        static Object nonArrayCached(DynamicObject target, boolean internal, @Cached(value="getNonArrayJSClass(target)") JSClass cachedJSClass) throws UnsupportedMessageException {
            return InteropArray.create(JSObject.enumerableOwnNames(target));
        }

        @Specialization(guards={"!isJSArray(target)", "!isJSArrayBufferView(target)", "!isJSArgumentsObject(target)"}, replaces={"nonArrayCached"})
        static Object nonArray(DynamicObject target, boolean internal) throws UnsupportedMessageException {
            JSClass.ensureHasMembers(target);
            return InteropArray.create(JSObject.enumerableOwnNames(target));
        }

        @CompilerDirectives.TruffleBoundary
        private static String[] filterEnumerableNames(DynamicObject target, Iterable<Object> ownKeys, JSClass jsclass) {
            ArrayList<String> names = new ArrayList<String>();
            for (Object obj : ownKeys) {
                PropertyDescriptor desc;
                if (!(obj instanceof String) || JSRuntime.isArrayIndex((String)obj) || (desc = jsclass.getOwnProperty(target, obj)) == null || !desc.getEnumerable()) continue;
                names.add((String)obj);
            }
            return names.toArray(EMPTY_STRING_ARRAY);
        }

        static JSClass getNonArrayJSClass(DynamicObject object) {
            if (JSClass.hasArrayElements(object) || JSClass.isNull(object)) {
                return null;
            }
            return JSObject.getJSClass(object);
        }
    }
}

