/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.java.JavaPackage;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import java.util.EnumSet;

public final class JavaImporter
extends JSBuiltinObject
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final String CLASS_NAME = "JavaImporter";
    private static final HiddenKey PACKAGES_ID = new HiddenKey("packages");
    static final Property PACKAGES_PROPERTY;
    private static final JavaImporter INSTANCE;

    private JavaImporter() {
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public String toString() {
        return CLASS_NAME;
    }

    public static DynamicObject create(JSContext context, DynamicObject[] value) {
        DynamicObject obj = JSObject.create(context, context.getJavaImporterFactory(), new Object[]{value});
        assert (JavaImporter.isJavaImporter(obj));
        return obj;
    }

    public static boolean isJavaImporter(Object obj) {
        return JSObject.isDynamicObject(obj) && JavaImporter.isJavaImporter((DynamicObject)obj);
    }

    public static boolean isJavaImporter(DynamicObject obj) {
        return JavaImporter.isInstance(obj, (JSClass)JavaImporter.instance());
    }

    @Override
    public boolean hasOwnProperty(DynamicObject thisObj, Object name) {
        return this.getOwnHelper(thisObj, (Object)thisObj, name) != null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, Object name) {
        if (name instanceof String) {
            DynamicObject[] packages = JavaImporter.getPackages(store);
            JSRealm realm = JSObject.getJSContext(store).getRealm();
            for (DynamicObject pkg : packages) {
                Object found = JavaPackage.getClass(realm, pkg, (String)name, Object.class);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public static DynamicObject[] getPackages(DynamicObject importer) {
        assert (JavaImporter.isJavaImporter(importer));
        return (DynamicObject[])PACKAGES_PROPERTY.get(importer, JavaImporter.isJavaImporter(importer));
    }

    @Override
    public String safeToString(DynamicObject object, int depth) {
        return "[JavaImporter]";
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext context = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putDataProperty(context, prototype, Symbol.SYMBOL_TO_STRING_TAG, CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putConstructorProperty(context, prototype, ctor);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, JavaImporter.instance(), context);
        initialShape = initialShape.addProperty(PACKAGES_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return JavaImporter.instance().createConstructorAndPrototype(realm);
    }

    public static JavaImporter instance() {
        return INSTANCE;
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getJavaImporterPrototype();
    }

    static {
        INSTANCE = new JavaImporter();
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        PACKAGES_PROPERTY = JSObjectUtil.makeHiddenProperty(PACKAGES_ID, allocator.locationForType(DynamicObject[].class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
    }
}

