/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.joni;

import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.nodes.Node;

public class JoniUnsupportedRegexException
extends RuntimeException
implements TruffleException {
    private String reason;
    private String pattern;
    private String flags;

    public JoniUnsupportedRegexException(String reason) {
        this.reason = reason;
    }

    public JoniUnsupportedRegexException(String reason, Throwable cause) {
        super(cause);
        this.reason = reason;
    }

    public void setRegex(String pattern, String flags) {
        this.pattern = pattern;
        this.flags = flags;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Unsupported regular expression");
        if (this.pattern != null) {
            sb.append(" /");
            sb.append(this.pattern);
            sb.append("/");
            if (this.flags != null) {
                sb.append(this.flags);
            }
        }
        if (this.reason != null) {
            sb.append(": ");
            sb.append(this.reason);
        }
        return sb.toString();
    }

    @Override
    public final Throwable fillInStackTrace() {
        return this;
    }

    public boolean isSyntaxError() {
        return true;
    }

    public Node getLocation() {
        return null;
    }
}

