/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.project;

import java.awt.Image;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cpplite.project.ActionProviderImpl;
import org.netbeans.modules.cpplite.project.BuildConfiguration;
import org.netbeans.modules.cpplite.project.CPPLiteCProjectConfigurationProvider;
import org.netbeans.modules.cpplite.project.LogicalViewProviderImpl;
import org.netbeans.modules.cpplite.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.spi.project.ProjectFactory2;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.lookup.Lookups;

public class CPPLiteProject
implements Project {
    public static final String PROJECT_KEY = "org-netbeans-modules-cpplite-project-CPPLiteProject";
    public static final String KEY_COMPILE_COMMANDS = "compile-commands";
    public static final String KEY_COMPILE_COMMANDS_EXECUTABLE = "compile-commands-executable";
    public static final String KEY_NEXT_MARK = "next-mark";
    public static final String KEY_IS_PROJECT = "is-project";
    private final FileObject projectDirectory;
    private final Lookup lookup;
    private final AtomicReference<BuildConfiguration> buildConfigurations = new AtomicReference();

    public static Preferences getRootPreferences(FileObject root) {
        return CPPLiteProject.getRootPreferences(root, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Preferences getRootPreferences(FileObject root, boolean create) {
        String encoded = root.toURI().toString().replace("/", ".");
        Preferences projectsRoot = NbPreferences.forModule(CPPLiteProject.class).node("projects");
        try {
            for (String key : projectsRoot.keys()) {
                if (!encoded.equals(projectsRoot.get(key, null))) continue;
                return projectsRoot.node(key);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        if (!create) {
            return null;
        }
        Class<CPPLiteProject> clazz = CPPLiteProject.class;
        synchronized (CPPLiteProject.class) {
            int mark = projectsRoot.getInt(KEY_NEXT_MARK, 0);
            String key = Integer.toHexString(mark);
            projectsRoot.putInt(KEY_NEXT_MARK, mark + 1);
            projectsRoot.put(key, encoded);
            // ** MonitorExit[var4_7] (shouldn't be in output)
            return projectsRoot.node(key);
        }
    }

    public static Preferences getBuildPreferences(FileObject root) {
        return CPPLiteProject.getRootPreferences(root).node("build");
    }

    private CPPLiteProject(FileObject projectDirectory) {
        this.projectDirectory = projectDirectory;
        this.lookup = Lookups.fixed((Object[])new Object[]{new LogicalViewProviderImpl(this), new ActionProviderImpl(this), new CustomizerProviderImpl(this), new CPPLiteCProjectConfigurationProvider(CPPLiteProject.getRootPreferences(projectDirectory)), new RecommendedTemplatesImpl(), new PrivilegedTemplatesImpl(), this});
        this.buildConfigurations.set(BuildConfiguration.read(CPPLiteProject.getBuildPreferences(projectDirectory)));
    }

    public FileObject getProjectDirectory() {
        return this.projectDirectory;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public BuildConfiguration getActiveBuildConfiguration() {
        return this.buildConfigurations.get();
    }

    public void setActiveBuildConfiguration(BuildConfiguration config) {
        this.buildConfigurations.set(config);
    }

    public String getCompileCommands() {
        return CPPLiteProject.getRootPreferences(this.projectDirectory).get(KEY_COMPILE_COMMANDS, "");
    }

    public void setCompileCommands(String compileCommands) {
        CPPLiteProject.getRootPreferences(this.projectDirectory).put(KEY_COMPILE_COMMANDS, compileCommands);
    }

    public String getCompileCommandsExecutable() {
        return CPPLiteProject.getRootPreferences(this.projectDirectory).get(KEY_COMPILE_COMMANDS_EXECUTABLE, "");
    }

    public void setCompileCommandsExecutable(String compileCommandsExecutable) {
        CPPLiteProject.getRootPreferences(this.projectDirectory).put(KEY_COMPILE_COMMANDS_EXECUTABLE, compileCommandsExecutable);
    }

    private static class PrivilegedTemplatesImpl
    implements PrivilegedTemplates {
        private static final String[] TEMPLATES = new String[]{"Templates/cpplite/CTemplate.c", "Templates/cpplite/CPPTemplate.cpp", "Templates/cpplite/HTemplate.h", "Templates/cpplite/HPPTemplate.hpp"};

        private PrivilegedTemplatesImpl() {
        }

        public String[] getPrivilegedTemplates() {
            return TEMPLATES;
        }
    }

    private static class RecommendedTemplatesImpl
    implements RecommendedTemplates {
        private static final String[] TEMPLATES = new String[]{"cpplite"};

        private RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return TEMPLATES;
        }
    }

    public static final class FactoryImpl
    implements ProjectFactory2 {
        public ProjectManager.Result isProject2(FileObject projectDirectory) {
            Preferences prefs = CPPLiteProject.getRootPreferences(projectDirectory, false);
            if (prefs != null && prefs.getBoolean(CPPLiteProject.KEY_IS_PROJECT, false)) {
                return new ProjectManager.Result(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/cpplite/project/resources/project.gif")));
            }
            return null;
        }

        public boolean isProject(FileObject projectDirectory) {
            return this.isProject2(projectDirectory) != null;
        }

        public Project loadProject(FileObject projectDirectory, ProjectState state) throws IOException {
            if (this.isProject(projectDirectory)) {
                return new CPPLiteProject(projectDirectory);
            }
            return null;
        }

        public void saveProject(Project project) throws IOException, ClassCastException {
        }
    }
}

