/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.monitor.client.ClientDisplay;
import org.netbeans.modules.web.monitor.client.ContextDisplay;
import org.netbeans.modules.web.monitor.client.Controller;
import org.netbeans.modules.web.monitor.client.CookieDisplay;
import org.netbeans.modules.web.monitor.client.CurrNode;
import org.netbeans.modules.web.monitor.client.HeaderDisplay;
import org.netbeans.modules.web.monitor.client.NavigateNode;
import org.netbeans.modules.web.monitor.client.NestedNode;
import org.netbeans.modules.web.monitor.client.RequestDisplay;
import org.netbeans.modules.web.monitor.client.SavedNode;
import org.netbeans.modules.web.monitor.client.SessionDisplay;
import org.netbeans.modules.web.monitor.client.TransactionNode;
import org.netbeans.modules.web.monitor.data.DataRecord;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class TransactionView
extends TopComponent
implements ExplorerManager.Provider,
PropertyChangeListener,
ChangeListener {
    private static transient TransactionView instance = null;
    private static transient Controller controller = null;
    private transient JToggleButton timeAButton;
    private transient JToggleButton timeDButton;
    private transient JToggleButton alphaButton;
    private transient JToggleButton timestampButton;
    private transient Dimension logD = new Dimension(250, 400);
    private transient Dimension dataD = new Dimension(500, 400);
    private transient Dimension tabD = new Dimension(500, 472);
    private static transient ExplorerManager mgr = null;
    private transient JPanel logPanel = null;
    private transient JPanel dataPanel = null;
    private transient JSplitPane splitPanel = null;
    private transient double dividerRatio = 0.35;
    private transient BeanTreeView tree = null;
    private transient AbstractNode selected = null;
    private transient RequestDisplay requestDisplay = null;
    private transient CookieDisplay cookieDisplay = null;
    private transient SessionDisplay sessionDisplay = null;
    private transient ContextDisplay contextDisplay = null;
    private transient ClientDisplay clientDisplay = null;
    private transient HeaderDisplay headerDisplay = null;
    boolean fontChanged = true;
    private int displayType = 0;
    private boolean openedOnceAlready = false;

    public boolean requestFocusInWindow() {
        if (this.tree != null) {
            return this.tree.requestFocusInWindow();
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        String helpID = NbBundle.getBundle(TransactionView.class).getString("MON_Transaction_View_F1_Help_ID");
        return new HelpCtx(helpID);
    }

    private TransactionView() {
        this.setIcon(new ImageIcon(TransactionView.class.getResource("/org/netbeans/modules/web/monitor/client/icons/menuitem.gif")).getImage());
        this.setToolTipText(NbBundle.getMessage(TransactionView.class, (String)"MON_Window_Tooltip"));
        controller = Controller.getInstance();
        this.initialize();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(TransactionView.class).getString("ACS_MON_monitorDesc"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(TransactionView.class).getString("ACS_MON_monitorName"));
    }

    static synchronized TransactionView getInstance() {
        if (instance == null) {
            instance = new TransactionView();
        }
        return instance;
    }

    private void initialize() {
        mgr = new ExplorerManager();
        mgr.addPropertyChangeListener((PropertyChangeListener)this);
        mgr.setRootContext((Node)controller.getRoot());
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)mgr, (ActionMap)this.getActionMap()));
        this.setLayout(new BorderLayout());
        this.tree = new BeanTreeView();
        this.tree.setDefaultActionAllowed(true);
        this.tree.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(TransactionView.class).getString("ACS_MON_treeName"));
        this.tree.getAccessibleContext().setAccessibleName(NbBundle.getBundle(TransactionView.class).getString("ACS_MON_treeDesc"));
        this.createLogPanel();
        this.createDataPanel();
        this.splitPanel = new JSplitPane(1, this.logPanel, this.dataPanel);
        this.splitPanel.setDividerLocation((int)this.logD.getWidth());
        this.splitPanel.setResizeWeight(this.dividerRatio);
        this.splitPanel.setDividerSize(1);
        this.splitPanel.setOneTouchExpandable(true);
        this.add(this.splitPanel);
        this.setName(NbBundle.getBundle(TransactionView.class).getString("MON_Title"));
    }

    void openTransactionNodes() {
        OpenTransactionNodesRequest req = new OpenTransactionNodesRequest();
        RequestProcessor.Task t = RequestProcessor.postRequest((Runnable)req, (int)500);
    }

    public int getPersistenceType() {
        return 1;
    }

    void selectNode(Node n) {
        try {
            Node[] nodeArray;
            if (n != null) {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = n;
            } else {
                nodeArray = new Node[]{};
            }
            mgr.setSelectedNodes(nodeArray);
        }
        catch (Exception exc) {
            Logger.getLogger(TransactionView.class.getName()).log(Level.INFO, "selectNode", exc);
        }
    }

    public void open() {
        super.open();
        if (!this.openedOnceAlready) {
            this.openedOnceAlready = true;
            controller.getTransactions();
            this.openTransactionNodes();
        }
        controller.checkServer(false);
    }

    public boolean isInitialized() {
        return this.openedOnceAlready;
    }

    protected void updateTitle() {
        this.setName(NbBundle.getBundle(TransactionView.class).getString("MON_Title"));
    }

    public Object writeReplace() throws ObjectStreamException {
        return new ResolvableHelper();
    }

    private void createLogPanel() {
        JToolBar buttonPanel = new JToolBar();
        buttonPanel.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(4, 4, 4, 4)));
        buttonPanel.setFloatable(false);
        JButton updateButton = new JButton(new ImageIcon(TransactionView.class.getResource("/org/netbeans/modules/web/monitor/client/icons/update.gif")));
        updateButton.setToolTipText(NbBundle.getBundle(TransactionView.class).getString("MON_Reload_all_17"));
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.getTransactions();
            }
        });
        this.timeAButton = new JToggleButton(new ImageIcon(TransactionView.class.getResource("/org/netbeans/modules/web/monitor/client/icons/timesortA.gif")), false);
        this.timeAButton.setToolTipText(NbBundle.getBundle(TransactionView.class).getString("MON_Order_transactions_15"));
        this.timeAButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((JToggleButton)e.getSource()).isSelected()) {
                    return;
                }
                TransactionView.this.timeDButton.setSelected(false);
                TransactionView.this.alphaButton.setSelected(false);
                Controller controller = controller;
                Controller controller2 = controller;
                controller2.getClass();
                controller.setComparator(controller2.new Controller.CompTime(false));
            }
        });
        this.timeDButton = new JToggleButton(new ImageIcon(TransactionView.class.getResource("/org/netbeans/modules/web/monitor/client/icons/timesortB.gif")), true);
        this.timeDButton.setToolTipText(NbBundle.getBundle(TransactionView.class).getString("MON_Order_transactions_16"));
        this.timeDButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((JToggleButton)e.getSource()).isSelected()) {
                    return;
                }
                TransactionView.this.timeAButton.setSelected(false);
                TransactionView.this.alphaButton.setSelected(false);
                Controller controller = controller;
                Controller controller2 = controller;
                controller2.getClass();
                controller.setComparator(controller2.new Controller.CompTime(true));
            }
        });
        this.alphaButton = new JToggleButton(new ImageIcon(TransactionView.class.getResource("/org/netbeans/modules/web/monitor/client/icons/a2z.gif")), false);
        this.alphaButton.setToolTipText(NbBundle.getBundle(TransactionView.class).getString("MON_Order_transactions_14"));
        this.alphaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!((JToggleButton)e.getSource()).isSelected()) {
                    return;
                }
                TransactionView.this.timeAButton.setSelected(false);
                TransactionView.this.timeDButton.setSelected(false);
                controller.setComparator(controller.new Controller.CompAlpha());
            }
        });
        this.timestampButton = new JToggleButton(new ImageIcon(TransactionView.class.getResource("/org/netbeans/modules/web/monitor/client/icons/timestamp.gif")), TransactionNode.showTimeStamp());
        this.timestampButton.setToolTipText(NbBundle.getBundle(TransactionView.class).getString("MON_Show_time_25"));
        this.timestampButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransactionNode.toggleTimeStamp();
                controller.updateNodeNames();
            }
        });
        buttonPanel.add(updateButton);
        buttonPanel.add(this.timeDButton);
        buttonPanel.add(this.timeAButton);
        buttonPanel.add(this.alphaButton);
        JPanel sep = new JPanel(){

            @Override
            public float getAlignmentX() {
                return 0.0f;
            }

            @Override
            public float getAlignmentY() {
                return 0.0f;
            }
        };
        sep.setMaximumSize(new Dimension(10, 10));
        buttonPanel.add(sep);
        buttonPanel.add(this.timestampButton);
        this.logPanel = new JPanel();
        this.logPanel.setLayout(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        p.add("North", buttonPanel);
        p.add("Center", (Component)this.tree);
        this.logPanel.add("Center", p);
        this.logPanel.setPreferredSize(this.logD);
    }

    private void createDataPanel() {
        JTabbedPane jtp = new JTabbedPane();
        jtp.getAccessibleContext().setAccessibleName(NbBundle.getBundle(TransactionView.class).getString("ACS_MON_Transaction_dataName"));
        jtp.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(TransactionView.class).getString("ACS_MON_Transaction_dataDesc"));
        jtp.setPreferredSize(this.tabD);
        jtp.setMaximumSize(this.tabD);
        FontMetrics metrics = this.getFontMetrics(jtp.getFont());
        int scrollingUnitIncrement = metrics.getHeight();
        this.requestDisplay = new RequestDisplay();
        JScrollPane p = new JScrollPane(this.requestDisplay);
        p.getVerticalScrollBar().setUnitIncrement(scrollingUnitIncrement);
        jtp.addTab(NbBundle.getBundle(TransactionView.class).getString("MON_Request_19_Tab"), p);
        this.cookieDisplay = new CookieDisplay();
        p = new JScrollPane(this.cookieDisplay);
        p.getVerticalScrollBar().setUnitIncrement(scrollingUnitIncrement);
        jtp.addTab(NbBundle.getBundle(TransactionView.class).getString("MON_Cookies_4_Tab"), p);
        this.sessionDisplay = new SessionDisplay();
        p = new JScrollPane(this.sessionDisplay);
        p.getVerticalScrollBar().setUnitIncrement(scrollingUnitIncrement);
        jtp.addTab(NbBundle.getBundle(TransactionView.class).getString("MON_Session_24"), p);
        this.contextDisplay = new ContextDisplay();
        p = new JScrollPane(this.contextDisplay);
        p.getVerticalScrollBar().setUnitIncrement(scrollingUnitIncrement);
        jtp.addTab(NbBundle.getBundle(TransactionView.class).getString("MON_Context_23"), p);
        this.clientDisplay = new ClientDisplay();
        p = new JScrollPane(this.clientDisplay);
        p.getVerticalScrollBar().setUnitIncrement(scrollingUnitIncrement);
        jtp.addTab(NbBundle.getBundle(TransactionView.class).getString("MON_Client_Server"), p);
        this.headerDisplay = new HeaderDisplay();
        p = new JScrollPane(this.headerDisplay);
        p.getVerticalScrollBar().setUnitIncrement(scrollingUnitIncrement);
        jtp.addTab(NbBundle.getBundle(TransactionView.class).getString("MON_Header_19"), p);
        jtp.addChangeListener(this);
        this.dataPanel = new JPanel();
        this.dataPanel.setLayout(new BorderLayout());
        this.dataPanel.add("Center", jtp);
        this.dataPanel.setPreferredSize(this.dataD);
    }

    void displayTransaction(Node node) {
        if (node == null) {
            return;
        }
        if (node instanceof TransactionNode || node instanceof NestedNode) {
            try {
                this.selected = (AbstractNode)node;
            }
            catch (ClassCastException ex) {
                this.selected = null;
                this.selectNode(null);
            }
        } else {
            this.selected = null;
            this.selectNode(null);
        }
        this.showData();
    }

    void saveTransaction(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        controller.saveTransaction(nodes);
        this.selected = null;
        this.selectNode(null);
        this.showData();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setName(NbBundle.getBundle(TransactionView.class).getString("MON_Title"));
        JTabbedPane p = (JTabbedPane)e.getSource();
        this.displayType = p.getSelectedIndex();
        this.showData();
    }

    void showData() {
        DataRecord dr = null;
        try {
            if (this.selected != null) {
                dr = controller.getDataRecord(this.selected);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.displayType == 0) {
            this.requestDisplay.setData(dr);
        } else if (this.displayType == 1) {
            this.cookieDisplay.setData(dr);
        } else if (this.displayType == 2) {
            this.sessionDisplay.setData(dr);
        } else if (this.displayType == 3) {
            this.contextDisplay.setData(dr);
        } else if (this.displayType == 4) {
            this.clientDisplay.setData(dr);
        } else if (this.displayType == 5) {
            this.headerDisplay.setData(dr);
        }
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setName(NbBundle.getBundle(TransactionView.class).getString("MON_Title"));
        if (evt.getPropertyName().equals("selectedNodes") && evt.getNewValue() instanceof Node[]) {
            try {
                Node[] ns = (Node[])evt.getNewValue();
                if (ns.length == 1) {
                    this.displayTransaction(ns[0]);
                }
            }
            catch (Exception e) {
                Logger.getLogger(TransactionView.class.getName()).log(Level.INFO, "", e);
                this.selected = null;
                this.showData();
                return;
            }
        }
    }

    void blank() {
        this.selected = null;
        this.selectNode(null);
        this.showData();
    }

    public void paint(Graphics g) {
        if (this.fontChanged) {
            super.paint(g);
            return;
        }
        FontMetrics fm = g.getFontMetrics(this.getFont());
        this.fontChanged = false;
        double logWidth = (double)fm.stringWidth(NbBundle.getBundle(TransactionView.class).getString("MON_Transactions_27")) * 1.1;
        if (logWidth > this.logD.getWidth()) {
            double factor = logWidth / this.logD.getWidth();
            this.logD.setSize(logWidth, factor * this.logD.getHeight());
            this.dataD.setSize(factor * this.dataD.getWidth(), factor * this.dataD.getHeight());
        }
        this.logPanel.setPreferredSize(this.logD);
        this.dataPanel.setPreferredSize(this.dataD);
        this.splitPanel.resetToPreferredSizes();
        this.splitPanel.setDividerLocation((int)this.logD.getWidth());
        try {
            Container o = this.getParent();
            while (true) {
                if (o instanceof JFrame) {
                    JFrame parent = (JFrame)o;
                    parent.pack();
                    break;
                }
                o = o.getParent();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected String preferredID() {
        return "TransactionView";
    }

    void setTimestampButtonSelected(boolean state) {
        this.timestampButton.setSelected(state);
    }

    boolean isTimestampButtonSelected() {
        return this.timestampButton.isSelected();
    }

    void addTimestampButtonActionListener(ActionListener l) {
        this.timestampButton.addActionListener(l);
    }

    boolean isAscButtonSelected() {
        return this.timeAButton.isSelected();
    }

    boolean isDescButtonSelected() {
        return this.timeDButton.isSelected();
    }

    boolean isAlphButtonSelected() {
        return this.alphaButton.isSelected();
    }

    void toggleTaskbarButtons(boolean asc, boolean desc, boolean alph) {
        this.timeAButton.setSelected(asc);
        this.timeDButton.setSelected(desc);
        this.alphaButton.setSelected(alph);
    }

    public ExplorerManager getExplorerManager() {
        return mgr;
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)mgr, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)mgr, (boolean)false);
    }

    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 1234546018839457544L;

        Object readResolve() {
            Controller.getInstance().getTransactions();
            return TransactionView.getInstance();
        }
    }

    class OpenTransactionNodesRequest
    implements Runnable {
        OpenTransactionNodesRequest() {
        }

        @Override
        public void run() {
            this.openTransactionNodes();
        }

        void openTransactionNodes() {
            NavigateNode root = controller.getRoot();
            Children ch = root.getChildren();
            Node[] nodes = ch.getNodes();
            CurrNode cn = (CurrNode)nodes[0];
            SavedNode sn = (SavedNode)nodes[1];
            Children currCh = cn.getChildren();
            Node[] currChNodes = currCh.getNodes();
            int numCN = currChNodes.length;
            if (numCN > 0) {
                int selectThisOne = 0;
                if (TransactionView.this.timeAButton.isSelected()) {
                    selectThisOne = numCN - 1;
                }
                TransactionView.this.selectNode(currChNodes[selectThisOne]);
            } else {
                Children savedCh = sn.getChildren();
                Node[] savedChNodes = savedCh.getNodes();
                int numSN = savedChNodes.length;
                if (numSN > 0) {
                    TransactionView.this.selectNode(savedChNodes[0]);
                }
            }
        }
    }
}

