/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.wizard;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.primefaces.component.tabview.Tab;
import org.primefaces.component.wizard.Wizard;
import org.primefaces.context.RequestContext;
import org.primefaces.event.FlowEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class WizardRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Wizard wizard = (Wizard)component;
        if (wizard.isWizardRequest(context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String clientId = wizard.getClientId(context);
            String stepToGo = (String)params.get(clientId + "_stepToGo");
            String currentStep = wizard.getStep();
            FlowEvent event = new FlowEvent((UIComponent)wizard, currentStep, stepToGo);
            event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            wizard.queueEvent(event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Wizard wizard = (Wizard)component;
        if (wizard.isWizardRequest(context)) {
            this.encodeStep(context, wizard);
        } else {
            this.encodeMarkup(context, wizard);
            this.encodeScript(context, wizard);
        }
    }

    protected void encodeStep(FacesContext context, Wizard wizard) throws IOException {
        String stepToDisplay = wizard.getStep();
        UIComponent tabToDisplay = null;
        for (UIComponent child : wizard.getChildren()) {
            if (!child.getId().equals(stepToDisplay)) continue;
            tabToDisplay = child;
        }
        tabToDisplay.encodeAll(context);
        RequestContext.getCurrentInstance().addCallbackParam("currentStep", wizard.getStep());
    }

    protected void encodeScript(FacesContext context, Wizard wizard) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = wizard.getClientId(context);
        UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)wizard);
        if (form == null) {
            throw new FacesException("Wizard : \"" + clientId + "\" must be inside a form element");
        }
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('Wizard','" + wizard.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",showStepStatus:" + wizard.isShowStepStatus());
        writer.write(",showNavBar:" + wizard.isShowNavBar());
        if (wizard.getOnback() != null) {
            writer.write(",onback:function(){" + wizard.getOnback() + "}");
        }
        if (wizard.getOnnext() != null) {
            writer.write(",onnext:function(){" + wizard.getOnnext() + "}");
        }
        writer.write(",steps:[");
        boolean firstStep = true;
        String defaultStep = null;
        for (UIComponent child : wizard.getChildren()) {
            if (!(child instanceof Tab) || !child.isRendered()) continue;
            Tab tab = (Tab)child;
            if (defaultStep == null) {
                defaultStep = tab.getId();
            }
            if (!firstStep) {
                writer.write(",");
            } else {
                firstStep = false;
            }
            writer.write("'" + tab.getId() + "'");
        }
        writer.write("]");
        if (wizard.getStep() == null) {
            wizard.setStep(defaultStep);
        }
        writer.write(",initialStep:'" + wizard.getStep() + "'");
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext facesContext, Wizard wizard) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = wizard.getClientId(facesContext);
        String styleClass = wizard.getStyleClass() == null ? "ui-wizard ui-widget" : "ui-wizard ui-widget " + wizard.getStyleClass();
        writer.startElement("div", (UIComponent)wizard);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (wizard.getStyle() != null) {
            writer.writeAttribute("style", (Object)wizard.getStyle(), "style");
        }
        if (wizard.isShowStepStatus()) {
            this.encodeStepStatus(facesContext, wizard);
        }
        this.encodeContent(facesContext, wizard);
        if (wizard.isShowNavBar()) {
            this.encodeNavigators(facesContext, wizard);
        }
        writer.endElement("div");
    }

    protected void encodeCurrentStep(FacesContext facesContext, Wizard wizard) throws IOException {
        for (UIComponent child : wizard.getChildren()) {
            if (!(child instanceof Tab) || !child.isRendered()) continue;
            Tab tab = (Tab)child;
            if (wizard.getStep() != null && !tab.getId().equals(wizard.getStep())) continue;
            tab.encodeAll(facesContext);
            break;
        }
    }

    protected void encodeNavigators(FacesContext facesContext, Wizard wizard) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = wizard.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-wizard-navbar ui-helper-clearfix", null);
        this.encodeNavigator(facesContext, wizard, clientId + "_back", wizard.getBackLabel(), "ui-wizard-nav-back", "ui-icon-arrowthick-1-w");
        this.encodeNavigator(facesContext, wizard, clientId + "_next", wizard.getNextLabel(), "ui-wizard-nav-next", "ui-icon-arrowthick-1-e");
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext facesContext, Wizard wizard) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = wizard.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_content"), "id");
        writer.writeAttribute("class", (Object)"ui-wizard-content", null);
        this.encodeCurrentStep(facesContext, wizard);
        writer.endElement("div");
    }

    protected void encodeStepStatus(FacesContext context, Wizard wizard) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String currentStep = wizard.getStep();
        boolean currentFound = false;
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-wizard-step-titles ui-helper-reset ui-helper-clearfix", null);
        for (UIComponent child : wizard.getChildren()) {
            String titleStyleClass;
            if (!(child instanceof Tab) || !child.isRendered()) continue;
            Tab tab = (Tab)child;
            String title = tab.getTitle();
            UIComponent titleFacet = tab.getFacet("title");
            boolean active = !currentFound && (currentStep == null || tab.getId().equals(currentStep));
            String string = titleStyleClass = active ? "ui-wizard-step-title ui-state-default ui-state-highlight ui-corner-all" : "ui-wizard-step-title ui-state-default ui-corner-all";
            if (tab.getTitleStyleClass() != null) {
                titleStyleClass = titleStyleClass + " " + tab.getTitleStyleClass();
            }
            if (active) {
                currentFound = true;
            }
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)titleStyleClass, null);
            if (tab.getTitleStyle() != null) {
                writer.writeAttribute("style", (Object)tab.getTitleStyle(), null);
            }
            if (tab.getTitletip() != null) {
                writer.writeAttribute("title", (Object)tab.getTitletip(), null);
            }
            if (titleFacet != null) {
                titleFacet.encodeAll(context);
            } else if (title != null) {
                writer.writeText((Object)title, null);
            }
            writer.endElement("li");
        }
        writer.endElement("ul");
    }

    protected void encodeNavigator(FacesContext facesContext, Wizard wizard, String id, String label, String buttonClass, String icon) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("button", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)("ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left " + buttonClass), null);
        String iconClass = "ui-button-icon-left ui-icon ui-c " + icon;
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.writeText((Object)label, "value");
        writer.endElement("span");
        writer.endElement("button");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

