<?php



namespace {

	/**
	 * Adds a parameter to a stored procedure or a remote stored procedure
	 * <p>Binds a parameter to a stored procedure or a remote stored procedure.</p>
	 * @param resource $stmt <p>Statement resource, obtained with <code>mssql_init()</code>.</p>
	 * @param string $param_name <p>The parameter name, as a string.</p> <p><b>Note</b>:</p><p>You have to include the <i>@</i> character, like in the T-SQL syntax. See the explanation included in <code>mssql_execute()</code>.</p>
	 * @param mixed $var <p>The PHP variable you'll bind the MSSQL parameter to. It is passed by reference, to retrieve OUTPUT and RETVAL values after the procedure execution.</p>
	 * @param int $type <p>One of: <b><code>SQLTEXT</code></b>, <b><code>SQLVARCHAR</code></b>, <b><code>SQLCHAR</code></b>, <b><code>SQLINT1</code></b>, <b><code>SQLINT2</code></b>, <b><code>SQLINT4</code></b>, <b><code>SQLBIT</code></b>, <b><code>SQLFLT4</code></b>, <b><code>SQLFLT8</code></b>, <b><code>SQLFLTN</code></b>.</p>
	 * @param bool $is_output <p>Whether the value is an OUTPUT parameter or not. If it's an OUTPUT parameter and you don't mention it, it will be treated as a normal input parameter and no error will be thrown.</p>
	 * @param bool $is_null <p>Whether the parameter is <b><code>NULL</code></b> or not. Passing the <b><code>NULL</code></b> value as <code>var</code> will not do the job.</p>
	 * @param int $maxlen <p>Used with char/varchar values. You have to indicate the length of the data so if the parameter is a varchar(50), the type must be <b><code>SQLVARCHAR</code></b> and this value <i>50</i>.</p>
	 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
	 * @link http://php.net/manual/en/function.mssql-bind.php
	 * @see mssql_execute(), mssql_free_statement(), mssql_init()
	 * @since PHP 4 >= 4.0.7, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_bind($stmt, string $param_name, &$var, int $type, bool $is_output = FALSE, bool $is_null = FALSE, int $maxlen = -1): bool {}

	/**
	 * Close MS SQL Server connection
	 * <p>Closes the link to a MS SQL Server database that's associated with the specified link identifier. If the link identifier isn't specified, the last opened link is assumed.</p><p>Note that this isn't usually necessary, as non-persistent open links are automatically closed at the end of the script's execution.</p>
	 * @param resource $link_identifier <p>A MS SQL link identifier, returned by <code>mssql_connect()</code>.</p> <p>This function will not close persistent links generated by <code>mssql_pconnect()</code>.</p>
	 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
	 * @link http://php.net/manual/en/function.mssql-close.php
	 * @see mssql_connect(), mssql_pconnect()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_close($link_identifier = NULL): bool {}

	/**
	 * Open MS SQL server connection
	 * <p><b>mssql_connect()</b> establishes a connection to a MS SQL server.</p><p>The link to the server will be closed as soon as the execution of the script ends, unless it's closed earlier by explicitly calling <code>mssql_close()</code>.</p>
	 * @param string $servername <p>The MS SQL server. It can also include a port number, e.g. <i>hostname:port</i> (Linux), or <i>hostname,port</i> (Windows).</p>
	 * @param string $username <p>The username.</p>
	 * @param string $password <p>The password.</p>
	 * @param bool $new_link <p>If a second call is made to <b>mssql_connect()</b> with the same arguments, no new link will be established, but instead, the link identifier of the already opened link will be returned. This parameter modifies this behavior and makes <b>mssql_connect()</b> always open a new link, even if <b>mssql_connect()</b> was called before with the same parameters.</p>
	 * @return resource <p>Returns a MS SQL link identifier on success, or <b><code>FALSE</code></b> on error.</p>
	 * @link http://php.net/manual/en/function.mssql-connect.php
	 * @see mssql_close(), mssql_pconnect()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_connect(string $servername = NULL, string $username = NULL, string $password = NULL, bool $new_link = FALSE) {}

	/**
	 * Moves internal row pointer
	 * <p><b>mssql_data_seek()</b> moves the internal row pointer of the MS SQL result associated with the specified result identifier to point to the specified row number, first row being number 0. The next call to <code>mssql_fetch_row()</code> would return that row.</p>
	 * @param resource $result_identifier <p>The result resource that is being evaluated.</p>
	 * @param int $row_number <p>The desired row number of the new result pointer.</p>
	 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
	 * @link http://php.net/manual/en/function.mssql-data-seek.php
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_data_seek($result_identifier, int $row_number): bool {}

	/**
	 * Executes a stored procedure on a MS SQL server database
	 * <p>Executes a stored procedure on a MS SQL server database</p>
	 * @param resource $stmt <p>Statement handle obtained with <code>mssql_init()</code>.</p>
	 * @param bool $skip_results <p>Whenever to skip the results or not.</p>
	 * @return mixed
	 * @link http://php.net/manual/en/function.mssql-execute.php
	 * @see mssql_bind(), mssql_free_statement(), mssql_init()
	 * @since PHP 4 >= 4.0.7, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_execute($stmt, bool $skip_results = FALSE) {}

	/**
	 * Fetch a result row as an associative array, a numeric array, or both
	 * <p><b>mssql_fetch_array()</b> is an extended version of <code>mssql_fetch_row()</code>. In addition to storing the data in the numeric indices of the result array, it also stores the data in associative indices, using the field names as keys.</p><p>An important thing to note is that using <b>mssql_fetch_array()</b> is NOT significantly slower than using <code>mssql_fetch_row()</code>, while it provides a significant added value.</p>
	 * @param resource $result <p>The result resource that is being evaluated. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @param int $result_type <p>The type of array that is to be fetched. It's a constant and can take the following values: <b><code>MSSQL_ASSOC</code></b>, <b><code>MSSQL_NUM</code></b>, and <b><code>MSSQL_BOTH</code></b>.</p>
	 * @return array <p>Returns an array that corresponds to the fetched row, or <b><code>FALSE</code></b> if there are no more rows.</p>
	 * @link http://php.net/manual/en/function.mssql-fetch-array.php
	 * @see mssql_fetch_row()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_fetch_array($result, int $result_type = MSSQL_BOTH): array {}

	/**
	 * Returns an associative array of the current row in the result
	 * <p>Returns an associative array that corresponds to the fetched row and moves the internal data pointer ahead. <b>mssql_fetch_assoc()</b> is equivalent to calling <code>mssql_fetch_array()</code> with <b><code>MSSQL_ASSOC</code></b> for the optional second parameter.</p>
	 * @param resource $result_id <p>The result resource that is being evaluated. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @return array <p>Returns an associative array that corresponds to the fetched row, or <b><code>FALSE</code></b> if there are no more rows.</p>
	 * @link http://php.net/manual/en/function.mssql-fetch-assoc.php
	 * @since PHP 4 >= 4.2.0, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_fetch_assoc($result_id): array {}

	/**
	 * Returns the next batch of records
	 * <p>Returns the next batch of records.</p>
	 * @param resource $result <p>The result resource that is being evaluated. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @return int <p>Returns the number of rows in the returned batch.</p>
	 * @link http://php.net/manual/en/function.mssql-fetch-batch.php
	 * @since PHP 4 >= 4.0.4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_fetch_batch($result): int {}

	/**
	 * Get field information
	 * <p><b>mssql_fetch_field()</b> can be used in order to obtain information about fields in a certain query result.</p>
	 * @param resource $result <p>The result resource that is being evaluated. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @param int $field_offset <p>The numerical field offset. If the field offset is not specified, the next field that was not yet retrieved by this function is retrieved. The <code>field_offset</code> starts at 0.</p>
	 * @return object <p>Returns an object containing field information.</p><p>The properties of the object are:</p><ul> <li>  name - column name. if the column is a result of a function, this property is set to computed#N, where #N is a serial number.  </li> <li>  column_source - the table from which the column was taken  </li> <li>  max_length - maximum length of the column  </li> <li>  numeric - 1 if the column is numeric  </li> <li>  type - the column type.  </li> </ul>
	 * @link http://php.net/manual/en/function.mssql-fetch-field.php
	 * @see mssql_field_seek()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_fetch_field($result, int $field_offset = -1): object {}

	/**
	 * Fetch row as object
	 * <p><b>mssql_fetch_object()</b> is similar to <code>mssql_fetch_array()</code>, with one difference - an object is returned, instead of an array. Indirectly, that means that you can only access the data by the field names, and not by their offsets (numbers are illegal property names).</p><p>Speed-wise, the function is identical to <code>mssql_fetch_array()</code>, and almost as quick as <code>mssql_fetch_row()</code> (the difference is insignificant).</p>
	 * @param resource $result <p>The result resource that is being evaluated. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @return object <p>Returns an object with properties that correspond to the fetched row, or <b><code>FALSE</code></b> if there are no more rows.</p>
	 * @link http://php.net/manual/en/function.mssql-fetch-object.php
	 * @see mssql_fetch_array(), mssql_fetch_row()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_fetch_object($result): object {}

	/**
	 * Get row as enumerated array
	 * <p><b>mssql_fetch_row()</b> fetches one row of data from the result associated with the specified result identifier. The row is returned as an array. Each result column is stored in an array offset, starting at offset 0.</p><p>Subsequent call to <b>mssql_fetch_row()</b> would return the next row in the result set, or <b><code>FALSE</code></b> if there are no more rows.</p>
	 * @param resource $result <p>The result resource that is being evaluated. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @return array <p>Returns an array that corresponds to the fetched row, or <b><code>FALSE</code></b> if there are no more rows.</p>
	 * @link http://php.net/manual/en/function.mssql-fetch-row.php
	 * @see mssql_fetch_array(), mssql_fetch_object(), mssql_data_seek(), mssql_result()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_fetch_row($result): array {}

	/**
	 * Get the length of a field
	 * <p>Returns the length of field no. <code>offset</code> in <code>result</code>.</p>
	 * @param resource $result <p>The result resource that is being evaluated. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @param int $offset <p>The field offset, starts at 0. If omitted, the current field is used.</p>
	 * @return int <p>The length of the specified field index on success or <b><code>FALSE</code></b> on failure.</p>
	 * @link http://php.net/manual/en/function.mssql-field-length.php
	 * @see mssql_field_name(), mssql_field_type()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_field_length($result, int $offset = -1): int {}

	/**
	 * Get the name of a field
	 * <p>Returns the name of field no. <code>offset</code> in <code>result</code>.</p>
	 * @param resource $result <p>The result resource that is being evaluated. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @param int $offset <p>The field offset, starts at 0. If omitted, the current field is used.</p>
	 * @return string <p>The name of the specified field index on success or <b><code>FALSE</code></b> on failure.</p>
	 * @link http://php.net/manual/en/function.mssql-field-name.php
	 * @see mssql_field_length(), mssql_field_type()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_field_name($result, int $offset = -1): string {}

	/**
	 * Seeks to the specified field offset
	 * <p>Seeks to the specified field offset. If the next call to <code>mssql_fetch_field()</code> won't include a field offset, this field would be returned.</p>
	 * @param resource $result <p>The result resource that is being evaluated. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @param int $field_offset <p>The field offset, starts at 0.</p>
	 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
	 * @link http://php.net/manual/en/function.mssql-field-seek.php
	 * @see mssql_fetch_field()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_field_seek($result, int $field_offset): bool {}

	/**
	 * Gets the type of a field
	 * <p>Returns the type of field no. <code>offset</code> in <code>result</code>.</p>
	 * @param resource $result <p>The result resource that is being evaluated. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @param int $offset <p>The field offset, starts at 0. If omitted, the current field is used.</p>
	 * @return string <p>The type of the specified field index on success or <b><code>FALSE</code></b> on failure.</p>
	 * @link http://php.net/manual/en/function.mssql-field-type.php
	 * @see mssql_field_length(), mssql_field_name()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_field_type($result, int $offset = -1): string {}

	/**
	 * Free result memory
	 * <p><b>mssql_free_result()</b> only needs to be called if you are worried about using too much memory while your script is running. All result memory will automatically be freed when the script ends. You may call <b>mssql_free_result()</b> with the result identifier as an argument and the associated result memory will be freed.</p>
	 * @param resource $result <p>The result resource that is being freed. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
	 * @link http://php.net/manual/en/function.mssql-free-result.php
	 * @see mssql_free_statement()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_free_result($result): bool {}

	/**
	 * Free statement memory
	 * <p><b>mssql_free_statement()</b> only needs to be called if you are worried about using too much memory while your script is running. All statement memory will automatically be freed when the script ends. You may call <b>mssql_free_statement()</b> with the statement identifier as an argument and the associated statement memory will be freed.</p>
	 * @param resource $stmt <p>Statement resource, obtained with <code>mssql_init()</code>.</p>
	 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
	 * @link http://php.net/manual/en/function.mssql-free-statement.php
	 * @see mssql_bind(), mssql_execute(), mssql_init(), mssql_free_result()
	 * @since PHP 4 >= 4.3.2, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_free_statement($stmt): bool {}

	/**
	 * Returns the last message from the server
	 * <p>Gets the last message from the MS-SQL server</p>
	 * @return string <p>Returns last error message from server, or an empty string if no error messages are returned from MSSQL.</p>
	 * @link http://php.net/manual/en/function.mssql-get-last-message.php
	 * @see mssql_min_error_severity(), mssql_min_message_severity()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_get_last_message(): string {}

	/**
	 * Converts a 16 byte binary GUID to a string
	 * <p>Converts a 16 byte binary GUID to a string.</p>
	 * @param string $binary <p>A 16 byte binary GUID.</p>
	 * @param bool $short_format <p>Whenever to use short format.</p>
	 * @return string <p>Returns the converted string on success.</p>
	 * @link http://php.net/manual/en/function.mssql-guid-string.php
	 * @since PHP 4 >= 4.0.7, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_guid_string(string $binary, bool $short_format = FALSE): string {}

	/**
	 * Initializes a stored procedure or a remote stored procedure
	 * <p>Initializes a stored procedure or a remote stored procedure.</p>
	 * @param string $sp_name <p>Stored procedure name, like <i>ownew.sp_name</i> or <i>otherdb.owner.sp_name</i>.</p>
	 * @param resource $link_identifier <p>A MS SQL link identifier, returned by <code>mssql_connect()</code>.</p>
	 * @return resource <p>Returns a resource identifier "statement", used in subsequent calls to <code>mssql_bind()</code> and <code>mssql_execute()</code>, or <b><code>FALSE</code></b> on errors.</p>
	 * @link http://php.net/manual/en/function.mssql-init.php
	 * @see mssql_bind(), mssql_execute(), mssql_free_statement()
	 * @since PHP 4 >= 4.0.7, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_init(string $sp_name, $link_identifier = NULL) {}

	/**
	 * Sets the minimum error severity
	 * <p>Sets the minimum error severity.</p>
	 * @param int $severity <p>The new error severity.</p>
	 * @return void <p>No value is returned.</p>
	 * @link http://php.net/manual/en/function.mssql-min-error-severity.php
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_min_error_severity(int $severity): void {}

	/**
	 * Sets the minimum message severity
	 * <p>Sets the minimum message severity.</p>
	 * @param int $severity <p>The new message severity.</p>
	 * @return void <p>No value is returned.</p>
	 * @link http://php.net/manual/en/function.mssql-min-message-severity.php
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_min_message_severity(int $severity): void {}

	/**
	 * Move the internal result pointer to the next result
	 * <p>When sending more than one SQL statement to the server or executing a stored procedure with multiple results, it will cause the server to return multiple result sets. This function will test for additional results available form the server. If an additional result set exists it will free the existing result set and prepare to fetch the rows from the new result set.</p>
	 * @param resource $result_id <p>The result resource that is being evaluated. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @return bool <p>Returns <b><code>TRUE</code></b> if an additional result set was available or <b><code>FALSE</code></b> otherwise.</p>
	 * @link http://php.net/manual/en/function.mssql-next-result.php
	 * @since PHP 4 >= 4.0.5, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_next_result($result_id): bool {}

	/**
	 * Gets the number of fields in result
	 * <p><b>mssql_num_fields()</b> returns the number of fields in a result set.</p>
	 * @param resource $result <p>The result resource that is being evaluated. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @return int <p>Returns the number of fields, as an integer.</p>
	 * @link http://php.net/manual/en/function.mssql-num-fields.php
	 * @see mssql_query(), mssql_fetch_field(), mssql_num_rows()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_num_fields($result): int {}

	/**
	 * Gets the number of rows in result
	 * <p><b>mssql_num_rows()</b> returns the number of rows in a result set.</p>
	 * @param resource $result <p>The result resource that is being evaluated. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @return int <p>Returns the number of rows, as an integer.</p>
	 * @link http://php.net/manual/en/function.mssql-num-rows.php
	 * @see mssql_query(), mssql_fetch_row()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_num_rows($result): int {}

	/**
	 * Open persistent MS SQL connection
	 * <p><b>mssql_pconnect()</b> acts very much like <code>mssql_connect()</code> with two major differences.</p><p>First, when connecting, the function would first try to find a (persistent) link that's already open with the same host, username and password. If one is found, an identifier for it will be returned instead of opening a new connection.</p><p>Second, the connection to the SQL server will not be closed when the execution of the script ends. Instead, the link will remain open for future use (<code>mssql_close()</code> will not close links established by <b>mssql_pconnect()</b>).</p><p>This type of links is therefore called 'persistent'.</p>
	 * @param string $servername <p>The MS SQL server. It can also include a port number. e.g. <i>hostname:port</i>.</p>
	 * @param string $username <p>The username.</p>
	 * @param string $password <p>The password.</p>
	 * @param bool $new_link <p>If a second call is made to <b>mssql_pconnect()</b> with the same arguments, no new link will be established, but instead, the link identifier of the already opened link will be returned. This parameter modifies this behavior and makes <b>mssql_pconnect()</b> always open a new link, even if <b>mssql_pconnect()</b> was called before with the same parameters.</p>
	 * @return resource <p>Returns a positive MS SQL persistent link identifier on success, or <b><code>FALSE</code></b> on error.</p>
	 * @link http://php.net/manual/en/function.mssql-pconnect.php
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_pconnect(string $servername = NULL, string $username = NULL, string $password = NULL, bool $new_link = FALSE) {}

	/**
	 * Send MS SQL query
	 * <p><b>mssql_query()</b> sends a query to the currently active database on the server that's associated with the specified link identifier.</p>
	 * @param string $query <p>An SQL query.</p>
	 * @param resource $link_identifier <p>A MS SQL link identifier, returned by <code>mssql_connect()</code> or <code>mssql_pconnect()</code>.</p> <p>If the link identifier isn't specified, the last opened link is assumed. If no link is open, the function tries to establish a link as if <code>mssql_connect()</code> was called, and use it.</p>
	 * @param int $batch_size <p>The number of records to batch in the buffer.</p>
	 * @return mixed <p>Returns a MS SQL result resource on success, <b><code>TRUE</code></b> if no rows were returned, or <b><code>FALSE</code></b> on error.</p>
	 * @link http://php.net/manual/en/function.mssql-query.php
	 * @see mssql_select_db(), mssql_connect()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_query(string $query, $link_identifier = NULL, int $batch_size = 0) {}

	/**
	 * Get result data
	 * <p><b>mssql_result()</b> returns the contents of one cell from a MS SQL result set.</p>
	 * @param resource $result <p>The result resource that is being evaluated. This result comes from a call to <code>mssql_query()</code>.</p>
	 * @param int $row <p>The row number.</p>
	 * @param mixed $field <p>Can be the field's offset, the field's name or the field's table dot field's name (tablename.fieldname). If the column name has been aliased ('select foo as bar from...'), it uses the alias instead of the column name.</p> <p><b>Note</b>:</p><p>Specifying a numeric offset for the <code>field</code> argument is much quicker than specifying a <i>fieldname</i> or <i>tablename.fieldname</i> argument.</p>
	 * @return string <p>Returns the contents of the specified cell.</p>
	 * @link http://php.net/manual/en/function.mssql-result.php
	 * @see mssql_fetch_row(), mssql_fetch_array(), mssql_fetch_assoc(), mssql_fetch_object()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_result($result, int $row, $field): string {}

	/**
	 * Returns the number of records affected by the query
	 * <p>Returns the number of records affected by the last write query.</p>
	 * @param resource $link_identifier <p>A MS SQL link identifier, returned by <code>mssql_connect()</code> or <code>mssql_pconnect()</code>.</p>
	 * @return int <p>Returns the number of records affected by last operation.</p>
	 * @link http://php.net/manual/en/function.mssql-rows-affected.php
	 * @since PHP 4 >= 4.0.4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_rows_affected($link_identifier): int {}

	/**
	 * Select MS SQL database
	 * <p><b>mssql_select_db()</b> sets the current active database on the server that's associated with the specified link identifier.</p><p>Every subsequent call to <code>mssql_query()</code> will be made on the active database.</p>
	 * @param string $database_name <p>The database name.</p> <p>To escape the name of a database that contains spaces, hyphens ("-"), or any other exceptional characters, the database name must be enclosed in brackets, as is shown in the example, below. This technique must also be applied when selecting a database name that is also a reserved word (such as <i>primary</i>).</p>
	 * @param resource $link_identifier <p>A MS SQL link identifier, returned by <code>mssql_connect()</code> or <code>mssql_pconnect()</code>.</p> <p>If no link identifier is specified, the last opened link is assumed. If no link is open, the function will try to establish a link as if <code>mssql_connect()</code> was called, and use it.</p>
	 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
	 * @link http://php.net/manual/en/function.mssql-select-db.php
	 * @see mssql_connect(), mssql_pconnect(), mssql_query()
	 * @since PHP 4, PHP 5, PECL odbtp >= 1.1.1
	 */
	function mssql_select_db(string $database_name, $link_identifier = NULL): bool {}

	/**
	 * Return an associative array. Used on <code>mssql_fetch_array()</code>'s <i>result_type</i> parameter.
	 */
	define('MSSQL_ASSOC', null);

	/**
	 * Return an array with both numeric keys and keys with their field name. This is the default value for <code>mssql_fetch_array()</code>'s <i>result_type</i> parameter.
	 */
	define('MSSQL_BOTH', null);

	/**
	 * Return an array with numeric keys. Used on <code>mssql_fetch_array()</code>'s <i>result_type</i> parameter.
	 */
	define('MSSQL_NUM', null);

	/**
	 * Indicates the '<i>BIT</i>' type in MSSQL, used by <code>mssql_bind()</code>'s <i>type</i> parameter.
	 */
	define('SQLBIT', null);

	/**
	 * Indicates the '<i>CHAR</i>' type in MSSQL, used by <code>mssql_bind()</code>'s <i>type</i> parameter.
	 */
	define('SQLCHAR', null);

	/**
	 * Represents an four byte float.
	 */
	define('SQLFLT4', null);

	/**
	 * Represents an eight byte float.
	 */
	define('SQLFLT8', null);

	/**
	 * Represents one byte, with a range of -128 to 127.
	 */
	define('SQLINT1', null);

	/**
	 * Represents two bytes, with a range of -32768 to 32767.
	 */
	define('SQLINT2', null);

	/**
	 * Represents four bytes, with a range of -2147483648 to 2147483647.
	 */
	define('SQLINT4', null);

	/**
	 * Indicates the '<i>TEXT</i>' type in MSSQL, used by <code>mssql_bind()</code>'s <i>type</i> parameter.
	 */
	define('SQLTEXT', null);

	/**
	 * Indicates the '<i>VARCHAR</i>' type in MSSQL, used by <code>mssql_bind()</code>'s <i>type</i> parameter.
	 */
	define('SQLVARCHAR', null);

}
