/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.util.Consumer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.CharsetUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.Decoder;
import org.jetbrains.io.fastCgi.DecodeRecordState;
import org.jetbrains.io.fastCgi.FastCgiDecoder$WhenMappings;
import org.jetbrains.io.fastCgi.FastCgiService;
import org.jetbrains.io.fastCgi.FastCgiServiceKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002\u001e\u001fB\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J%\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000eH\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiDecoder;", "Lorg/jetbrains/io/Decoder;", "Lorg/jetbrains/io/Decoder$FullMessageConsumer;", "", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "responseHandler", "Lorg/jetbrains/io/fastCgi/FastCgiService;", "(Lcom/intellij/util/Consumer;Lorg/jetbrains/io/fastCgi/FastCgiService;)V", "contentLength", "", "dataBuffers", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lio/netty/buffer/ByteBuf;", "id", "paddingLength", "state", "Lorg/jetbrains/io/fastCgi/DecodeRecordState;", "type", "channelInactive", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "contentReceived", "buffer", "isCumulateBuffer", "(Lio/netty/buffer/ByteBuf;Lio/netty/channel/ChannelHandlerContext;Z)Ljava/lang/Boolean;", "messageReceived", "input", "ProtocolStatus", "RecordType", "intellij.platform.builtInServer.impl"})
public final class FastCgiDecoder
extends Decoder
implements Decoder.FullMessageConsumer<Boolean> {
    private DecodeRecordState state;
    private int type;
    private int id;
    private int contentLength;
    private int paddingLength;
    private final Int2ObjectOpenHashMap<ByteBuf> dataBuffers;
    private final Consumer<String> errorOutputConsumer;
    private final FastCgiService responseHandler;

    protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        while (true) {
            switch (FastCgiDecoder$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    ByteBuf buffer;
                    if (this.paddingLength > 0) {
                        if (input.readableBytes() > this.paddingLength) {
                            input.skipBytes(this.paddingLength);
                            this.paddingLength = 0;
                        } else {
                            this.paddingLength -= input.readableBytes();
                            input.skipBytes(input.readableBytes());
                            return;
                        }
                    }
                    if (this.getBufferIfSufficient(input, 8, context) == null) {
                        return;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)buffer, (String)"getBufferIfSufficient(in\u2026ENGTH, context) ?: return");
                    buffer.skipBytes(1);
                    this.type = buffer.readUnsignedByte();
                    this.id = buffer.readUnsignedShort();
                    this.contentLength = buffer.readUnsignedShort();
                    this.paddingLength = buffer.readUnsignedByte();
                    buffer.skipBytes(1);
                    this.state = DecodeRecordState.CONTENT;
                    break;
                }
                case 2: {
                    if (this.contentLength > 0 && this.readContent(input, context, this.contentLength, this) == null) {
                        return;
                    }
                    this.state = DecodeRecordState.HEADER;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(@NotNull ChannelHandlerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            if (!this.dataBuffers.isEmpty()) {
                for (ByteBuf buffer : (ObjectCollection)this.dataBuffers.values()) {
                    try {
                        buffer.release();
                    }
                    catch (Throwable e) {
                        FastCgiServiceKt.getLOG().error(e);
                    }
                }
                this.dataBuffers.clear();
            }
        }
        finally {
            super.channelInactive(context);
        }
    }

    @NotNull
    public Boolean contentReceived(@NotNull ByteBuf buffer, @NotNull ChannelHandlerContext context, boolean isCumulateBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        switch (this.type) {
            case 6: {
                ByteBuf data = (ByteBuf)this.dataBuffers.get(this.id);
                ByteBuf sliced = isCumulateBuffer ? buffer : buffer.slice(buffer.readerIndex(), this.contentLength);
                ByteBuf byteBuf = data;
                if (byteBuf == null) {
                    this.dataBuffers.put(this.id, (Object)sliced);
                } else if (byteBuf instanceof CompositeByteBuf) {
                    ((CompositeByteBuf)data).addComponent(sliced);
                    ((CompositeByteBuf)data).writerIndex(data.writerIndex() + sliced.readableBytes());
                } else {
                    if (sliced instanceof CompositeByteBuf) {
                        int readable = data.readableBytes();
                        data = (ByteBuf)((CompositeByteBuf)sliced).addComponent(0, data);
                        ((CompositeByteBuf)data).writerIndex(data.writerIndex() + readable);
                    } else {
                        int newLength = data.readableBytes() + sliced.readableBytes();
                        data = (ByteBuf)context.alloc().compositeBuffer(1024).addComponents(new ByteBuf[]{data, sliced});
                        ((CompositeByteBuf)data).writerIndex(data.writerIndex() + newLength);
                    }
                    this.dataBuffers.put(this.id, (Object)data);
                }
                sliced.retain();
                break;
            }
            case 7: {
                try {
                    this.errorOutputConsumer.consume((Object)buffer.toString(buffer.readerIndex(), this.contentLength, CharsetUtil.UTF_8));
                }
                catch (Throwable e) {
                    FastCgiServiceKt.getLOG().error(e);
                }
                break;
            }
            case 3: {
                int appStatus = buffer.readInt();
                short protocolStatus = buffer.readUnsignedByte();
                if (appStatus != 0 || protocolStatus != ProtocolStatus.REQUEST_COMPLETE.ordinal()) {
                    FastCgiServiceKt.getLOG().warn("Protocol status " + protocolStatus);
                    this.dataBuffers.remove(this.id);
                    this.responseHandler.responseReceived(this.id, null);
                    break;
                }
                if (protocolStatus == ProtocolStatus.REQUEST_COMPLETE.ordinal()) {
                    this.responseHandler.responseReceived(this.id, (ByteBuf)this.dataBuffers.remove(this.id));
                    break;
                }
                FastCgiServiceKt.getLOG().warn("protocolStatus " + protocolStatus);
                break;
            }
            default: {
                FastCgiServiceKt.getLOG().error("Unknown type " + this.type);
            }
        }
        return true;
    }

    public FastCgiDecoder(@NotNull Consumer<String> errorOutputConsumer, @NotNull FastCgiService responseHandler) {
        Intrinsics.checkParameterIsNotNull(errorOutputConsumer, (String)"errorOutputConsumer");
        Intrinsics.checkParameterIsNotNull((Object)responseHandler, (String)"responseHandler");
        this.errorOutputConsumer = errorOutputConsumer;
        this.responseHandler = responseHandler;
        this.state = DecodeRecordState.HEADER;
        this.dataBuffers = new Int2ObjectOpenHashMap();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiDecoder$ProtocolStatus;", "", "(Ljava/lang/String;I)V", "REQUEST_COMPLETE", "CANT_MPX_CONN", "OVERLOADED", "UNKNOWN_ROLE", "intellij.platform.builtInServer.impl"})
    private static final class ProtocolStatus
    extends Enum<ProtocolStatus> {
        public static final /* enum */ ProtocolStatus REQUEST_COMPLETE;
        public static final /* enum */ ProtocolStatus CANT_MPX_CONN;
        public static final /* enum */ ProtocolStatus OVERLOADED;
        public static final /* enum */ ProtocolStatus UNKNOWN_ROLE;
        private static final /* synthetic */ ProtocolStatus[] $VALUES;

        static {
            ProtocolStatus[] protocolStatusArray = new ProtocolStatus[4];
            ProtocolStatus[] protocolStatusArray2 = protocolStatusArray;
            protocolStatusArray[0] = REQUEST_COMPLETE = new ProtocolStatus();
            protocolStatusArray[1] = CANT_MPX_CONN = new ProtocolStatus();
            protocolStatusArray[2] = OVERLOADED = new ProtocolStatus();
            protocolStatusArray[3] = UNKNOWN_ROLE = new ProtocolStatus();
            $VALUES = protocolStatusArray;
        }

        public static ProtocolStatus[] values() {
            return (ProtocolStatus[])$VALUES.clone();
        }

        public static ProtocolStatus valueOf(String string) {
            return Enum.valueOf(ProtocolStatus.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiDecoder$RecordType;", "", "()V", "END_REQUEST", "", "STDERR", "STDOUT", "intellij.platform.builtInServer.impl"})
    public static final class RecordType {
        public static final int END_REQUEST = 3;
        public static final int STDOUT = 6;
        public static final int STDERR = 7;
        public static final RecordType INSTANCE;

        private RecordType() {
        }

        static {
            RecordType recordType;
            INSTANCE = recordType = new RecordType();
        }
    }
}

